/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.AttestationConveyancePreference;
import com.webauthn4j.data.AuthenticatorSelectionCriteria;
import com.webauthn4j.data.PublicKeyCredentialDescriptor;
import com.webauthn4j.data.PublicKeyCredentialParameters;
import com.webauthn4j.data.PublicKeyCredentialRpEntity;
import com.webauthn4j.data.PublicKeyCredentialUserEntity;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CollectionUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicKeyCredentialCreationOptions {
    private final PublicKeyCredentialRpEntity rp;
    private final PublicKeyCredentialUserEntity user;
    private final Challenge challenge;
    private final List<PublicKeyCredentialParameters> pubKeyCredParams;
    private final Long timeout;
    private final List<PublicKeyCredentialDescriptor> excludeCredentials;
    private final AuthenticatorSelectionCriteria authenticatorSelection;
    private final AttestationConveyancePreference attestation;
    private final AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> extensions;

    @JsonCreator
    public PublicKeyCredentialCreationOptions(@JsonProperty(value="rp") @NotNull PublicKeyCredentialRpEntity rp2, @JsonProperty(value="user") @NotNull PublicKeyCredentialUserEntity user, @JsonProperty(value="challenge") @NotNull Challenge challenge2, @JsonProperty(value="pubKeyCredParams") @NotNull List<PublicKeyCredentialParameters> pubKeyCredParams, @JsonProperty(value="timeout") @Nullable Long timeout2, @JsonProperty(value="excludeCredentials") @Nullable List<PublicKeyCredentialDescriptor> excludeCredentials, @JsonProperty(value="authenticatorSelection") @Nullable AuthenticatorSelectionCriteria authenticatorSelection, @JsonProperty(value="attestation") @Nullable AttestationConveyancePreference attestation, @JsonProperty(value="extensions") @Nullable AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> extensions) {
        AssertUtil.notNull(rp2, "rp must not be null");
        AssertUtil.notNull(user, "user must not be null");
        AssertUtil.notNull(challenge2, "challenge must not be null");
        AssertUtil.notNull(pubKeyCredParams, "pubKeyCredParams must not be null");
        this.rp = rp2;
        this.user = user;
        this.challenge = challenge2;
        this.pubKeyCredParams = CollectionUtil.unmodifiableList(pubKeyCredParams);
        this.timeout = timeout2;
        this.excludeCredentials = CollectionUtil.unmodifiableList(excludeCredentials);
        this.authenticatorSelection = authenticatorSelection;
        this.attestation = attestation;
        this.extensions = extensions;
    }

    public PublicKeyCredentialCreationOptions(@NotNull PublicKeyCredentialRpEntity rp2, @NotNull PublicKeyCredentialUserEntity user, @NotNull Challenge challenge2, @NotNull List<PublicKeyCredentialParameters> pubKeyCredParams) {
        this(rp2, user, challenge2, pubKeyCredParams, null, Collections.emptyList(), null, null, null);
    }

    @NotNull
    public PublicKeyCredentialRpEntity getRp() {
        return this.rp;
    }

    @NotNull
    public PublicKeyCredentialUserEntity getUser() {
        return this.user;
    }

    @NotNull
    public Challenge getChallenge() {
        return this.challenge;
    }

    @NotNull
    public List<PublicKeyCredentialParameters> getPubKeyCredParams() {
        return this.pubKeyCredParams;
    }

    @Nullable
    public Long getTimeout() {
        return this.timeout;
    }

    @Nullable
    public List<PublicKeyCredentialDescriptor> getExcludeCredentials() {
        return this.excludeCredentials;
    }

    @Nullable
    public AuthenticatorSelectionCriteria getAuthenticatorSelection() {
        return this.authenticatorSelection;
    }

    @Nullable
    public AttestationConveyancePreference getAttestation() {
        return this.attestation;
    }

    @Nullable
    public AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialCreationOptions that = (PublicKeyCredentialCreationOptions)o;
        return Objects.equals(this.rp, that.rp) && Objects.equals(this.user, that.user) && Objects.equals(this.challenge, that.challenge) && Objects.equals(this.pubKeyCredParams, that.pubKeyCredParams) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.excludeCredentials, that.excludeCredentials) && Objects.equals(this.authenticatorSelection, that.authenticatorSelection) && Objects.equals(this.attestation, that.attestation) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.rp, this.user, this.challenge, this.pubKeyCredParams, this.timeout, this.excludeCredentials, this.authenticatorSelection, this.attestation, this.extensions);
    }

    public String toString() {
        return "PublicKeyCredentialCreationOptions(rp=" + this.rp + ", user=" + this.user + ", challenge=" + this.challenge + ", pubKeyCredParams=" + this.pubKeyCredParams + ", timeout=" + this.timeout + ", excludeCredentials=" + this.excludeCredentials + ", authenticatorSelection=" + this.authenticatorSelection + ", attestation=" + this.attestation + ", extensions=" + this.extensions + ")";
    }
}

