/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1.parse;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kerby.asn1.Asn1Dumpable;
import org.apache.kerby.asn1.Asn1Dumper;
import org.apache.kerby.asn1.parse.Asn1Header;
import org.apache.kerby.asn1.parse.Asn1ParseResult;

public class Asn1Container
extends Asn1ParseResult
implements Asn1Dumpable {
    private List<Asn1ParseResult> children = new ArrayList<Asn1ParseResult>();

    public Asn1Container(Asn1Header header2, int bodyStart, ByteBuffer buffer) {
        super(header2, bodyStart, buffer);
    }

    public List<Asn1ParseResult> getChildren() {
        return this.children;
    }

    public void addItem(Asn1ParseResult value) {
        this.children.add(value);
    }

    public void clear() {
        this.children.clear();
    }

    @Override
    public void dumpWith(Asn1Dumper dumper, int indents) {
        dumper.indent(indents).append(this.toString());
        if (this.children.size() > 0) {
            dumper.newLine();
        }
        int i2 = this.children.size();
        for (Asn1ParseResult aObj : this.children) {
            dumper.dumpParseResult(indents + 4, aObj);
            if (--i2 <= 0) continue;
            dumper.newLine();
        }
    }

    public String toString() {
        String typeStr = this.tag().typeStr();
        typeStr = typeStr + " [tag=" + this.tag() + ", off=" + this.getOffset() + ", len=" + this.getHeaderLength() + "+" + this.getBodyLength() + (this.isDefinitiveLength() ? "" : "(undefined)") + "]";
        return typeStr;
    }
}

