/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.format;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Format;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public abstract class AbstractRFC3986Format
implements Format {
    private static final Pattern VALID = Pattern.compile("([A-Za-z0-9+-\\.]*:)?//|[A-Za-z0-9+-\\.]+:");

    @Override
    public final boolean matches(ExecutionContext executionContext, String value) {
        try {
            URI uri = new URI(value);
            return this.validate(uri);
        }
        catch (URISyntaxException e) {
            return this.handleException(e);
        }
    }

    protected abstract boolean validate(URI var1);

    protected boolean handleException(URISyntaxException e) {
        return VALID.matcher(e.getInput()).matches();
    }
}

