/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.internal;

import androidx.annotation.MainThread;
import androidx.savedstate.SavedState;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0011\u001a\u00020\fH\u0007J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0087\u0002J)\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0018\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u0002H\u0019H\u0007\u00a2\u0006\u0002\u0010\u001bJ)\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00190\u000e\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u0002H\u0019H\u0007\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001fH\u0007J\u001e\u0010 \u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0016\u001a\u00020\u0004H\u0087\u0002\u00a2\u0006\u0002\u0010!J&\u0010\"\u001a\u00020#\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u0001H\u0019H\u0087\u0002\u00a2\u0006\u0002\u0010%J\u001d\u0010&\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0016\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010!J\u0018\u0010'\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\fH\u0007J\u0010\u0010)\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0004H\u0007R\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006*"}, d2={"Landroidx/lifecycle/internal/SavedStateHandleImpl;", "", "initialState", "", "", "<init>", "(Ljava/util/Map;)V", "regular", "", "getRegular", "()Ljava/util/Map;", "providers", "Landroidx/savedstate/SavedStateRegistry$SavedStateProvider;", "flows", "Lkotlinx/coroutines/flow/MutableStateFlow;", "mutableFlows", "getMutableFlows", "savedStateProvider", "getSavedStateProvider", "()Landroidx/savedstate/SavedStateRegistry$SavedStateProvider;", "contains", "", "key", "getStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "T", "initialValue", "(Ljava/lang/String;Ljava/lang/Object;)Lkotlinx/coroutines/flow/StateFlow;", "getMutableStateFlow", "(Ljava/lang/String;Ljava/lang/Object;)Lkotlinx/coroutines/flow/MutableStateFlow;", "keys", "", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "remove", "setSavedStateProvider", "provider", "clearSavedStateProvider", "lifecycle-viewmodel-savedstate"})
@SourceDebugExtension(value={"SMAP\nSavedStateHandleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SavedStateHandleImpl.kt\nandroidx/lifecycle/internal/SavedStateHandleImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 SavedState.nonAndroid.kt\nandroidx/savedstate/SavedStateKt__SavedState_nonAndroidKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 SavedState.kt\nandroidx/savedstate/SavedStateKt__SavedStateKt\n+ 6 SavedState.nonAndroid.kt\nandroidx/savedstate/SavedStateKt__SavedState_nonAndroidKt$savedState$1\n*L\n1#1,129:1\n381#2,7:130\n381#2,7:137\n30#3:144\n45#3:145\n34#3,2:146\n1#4:148\n106#5:149\n45#6:150\n*S KotlinDebug\n*F\n+ 1 SavedStateHandleImpl.kt\nandroidx/lifecycle/internal/SavedStateHandleImpl\n*L\n60#1:130,7\n76#1:137,7\n47#1:144\n47#1:145\n47#1:146,2\n47#1:148\n47#1:149\n47#1:150\n*E\n"})
public final class SavedStateHandleImpl {
    @NotNull
    private final Map<String, Object> regular;
    @NotNull
    private final Map<String, SavedStateRegistry.SavedStateProvider> providers;
    @NotNull
    private final Map<String, MutableStateFlow<Object>> flows;
    @NotNull
    private final Map<String, MutableStateFlow<Object>> mutableFlows;
    @NotNull
    private final SavedStateRegistry.SavedStateProvider savedStateProvider;

    public SavedStateHandleImpl(@NotNull Map<String, ? extends Object> initialState) {
        Intrinsics.checkNotNullParameter(initialState, (String)"initialState");
        this.regular = MapsKt.toMutableMap(initialState);
        this.providers = new LinkedHashMap();
        this.flows = new LinkedHashMap();
        this.mutableFlows = new LinkedHashMap();
        this.savedStateProvider = () -> SavedStateHandleImpl.savedStateProvider$lambda$0(this);
    }

    public /* synthetic */ SavedStateHandleImpl(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        this(map);
    }

    @NotNull
    public final Map<String, Object> getRegular() {
        return this.regular;
    }

    @NotNull
    public final Map<String, MutableStateFlow<Object>> getMutableFlows() {
        return this.mutableFlows;
    }

    @NotNull
    public final SavedStateRegistry.SavedStateProvider getSavedStateProvider() {
        return this.savedStateProvider;
    }

    @NotNull
    public final SavedStateRegistry.SavedStateProvider savedStateProvider() {
        return this.savedStateProvider;
    }

    @MainThread
    public final boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.regular.containsKey(key);
    }

    @MainThread
    @NotNull
    public final <T> StateFlow<T> getStateFlow(@NotNull String key, T initialValue) {
        MutableStateFlow mutableStateFlow;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, MutableStateFlow<Object>> $this$getOrPut$iv = this.flows;
        boolean $i$f$getOrPut = false;
        MutableStateFlow value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            if (!this.regular.containsKey(key)) {
                this.regular.put(key, initialValue);
            }
            MutableStateFlow answer$iv = StateFlowKt.MutableStateFlow((Object)this.regular.get(key));
            $this$getOrPut$iv.put(key, (MutableStateFlow<Object>)answer$iv);
            mutableStateFlow = answer$iv;
        } else {
            mutableStateFlow = value$iv;
        }
        MutableStateFlow flow = mutableStateFlow;
        StateFlow stateFlow = FlowKt.asStateFlow(flow);
        Intrinsics.checkNotNull((Object)stateFlow, (String)"null cannot be cast to non-null type kotlinx.coroutines.flow.StateFlow<T of androidx.lifecycle.internal.SavedStateHandleImpl.getStateFlow>");
        return stateFlow;
    }

    @MainThread
    @NotNull
    public final <T> MutableStateFlow<T> getMutableStateFlow(@NotNull String key, T initialValue) {
        MutableStateFlow mutableStateFlow;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, MutableStateFlow<Object>> $this$getOrPut$iv = this.mutableFlows;
        boolean $i$f$getOrPut = false;
        MutableStateFlow value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            if (!this.regular.containsKey(key)) {
                this.regular.put(key, initialValue);
            }
            MutableStateFlow answer$iv = StateFlowKt.MutableStateFlow((Object)this.regular.get(key));
            $this$getOrPut$iv.put(key, (MutableStateFlow<Object>)answer$iv);
            mutableStateFlow = answer$iv;
        } else {
            mutableStateFlow = value$iv;
        }
        MutableStateFlow flow = mutableStateFlow;
        Intrinsics.checkNotNull(flow, (String)"null cannot be cast to non-null type kotlinx.coroutines.flow.MutableStateFlow<T of androidx.lifecycle.internal.SavedStateHandleImpl.getMutableStateFlow>");
        return flow;
    }

    @MainThread
    @NotNull
    public final Set<String> keys() {
        return SetsKt.plus(this.regular.keySet(), (Iterable)this.providers.keySet());
    }

    @MainThread
    @Nullable
    public final <T> T get(@NotNull String key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Object object2 = this.mutableFlows.get(key);
            if (object2 == null || (object2 = object2.getValue()) == null) {
                object2 = this.regular.get(key);
            }
            object = object2;
        }
        catch (ClassCastException e) {
            this.remove(key);
            object = null;
        }
        return (T)object;
    }

    @MainThread
    public final <T> void set(@NotNull String key, @Nullable T value) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.regular.put(key, value);
            MutableStateFlow<Object> mutableStateFlow = this.flows.get(key);
            if (mutableStateFlow != null) {
                mutableStateFlow.setValue(value);
            }
            MutableStateFlow<Object> mutableStateFlow2 = this.mutableFlows.get(key);
            if (mutableStateFlow2 == null) break block1;
            mutableStateFlow2.setValue(value);
        }
    }

    @MainThread
    @Nullable
    public final <T> T remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object latestValue = this.regular.remove(key);
        this.flows.remove(key);
        this.mutableFlows.remove(key);
        return (T)latestValue;
    }

    @MainThread
    public final void setSavedStateProvider(@NotNull String key, @NotNull SavedStateRegistry.SavedStateProvider provider) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.providers.put(key, provider);
    }

    @MainThread
    public final void clearSavedStateProvider(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.providers.remove(key);
    }

    private static final SavedState savedStateProvider$lambda$0(SavedStateHandleImpl this$0) {
        SavedState savedState;
        String key;
        for (Map.Entry entry : MapsKt.toMap(this$0.mutableFlows).entrySet()) {
            key = (String)entry.getKey();
            MutableStateFlow mutableFlow = (MutableStateFlow)entry.getValue();
            this$0.set(key, mutableFlow.getValue());
        }
        for (Map.Entry entry : MapsKt.toMap(this$0.providers).entrySet()) {
            key = (String)entry.getKey();
            SavedStateRegistry.SavedStateProvider provider = (SavedStateRegistry.SavedStateProvider)entry.getValue();
            this$0.set(key, provider.saveState());
        }
        Map<String, Object> initialState$iv = this$0.regular;
        boolean $i$f$savedState = false;
        Map copiedState$iv = MapsKt.toMutableMap(initialState$iv);
        SavedState $this$savedState_u24lambda_u240$iv = savedState = new SavedState(copiedState$iv);
        boolean bl = false;
        SavedState $this$write$iv$iv = $this$savedState_u24lambda_u240$iv;
        boolean $i$f$write = false;
        SavedState savedState2 = SavedStateWriter.constructor-impl((SavedState)$this$write$iv$iv);
        boolean bl2 = false;
        SavedState savedState3 = savedState2;
        return savedState;
    }

    public SavedStateHandleImpl() {
        this(null, 1, null);
    }
}

