/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.format;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.DateTimeFormatBuilderKt;
import kotlinx.datetime.format.FormatStringsInDatetimeFormats;
import kotlinx.datetime.format.UnicodeFormat;
import kotlinx.datetime.format.UnknownUnicodeDirective;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\f\u0010\u0011\u001a\u00020\u000e*\u00020\u0012H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u000e*\u00020\u00122\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\u000e*\u00020\u00122\u0006\u0010\u0015\u001a\u00020\nH\u0002\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"byUnicodePattern", "", "Lkotlinx/datetime/format/DateTimeFormatBuilder;", "pattern", "", "unicodeDirective", "Lkotlinx/datetime/format/UnicodeFormat;", "char", "", "formatLength", "", "nonPlainCharacters", "", "unsupportedDirective", "", "fieldName", "recommendation", "unknownLength", "Lkotlinx/datetime/format/UnicodeFormat$Directive;", "localizedDirective", "unsupportedPadding", "digits", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nUnicode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Unicode.kt\nkotlinx/datetime/format/UnicodeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,659:1\n1869#2,2:660\n*S KotlinDebug\n*F\n+ 1 Unicode.kt\nkotlinx/datetime/format/UnicodeKt\n*L\n113#1:660,2\n*E\n"})
public final class UnicodeKt {
    @NotNull
    private static final List<Character> nonPlainCharacters;

    @FormatStringsInDatetimeFormats
    public static final void byUnicodePattern(@NotNull DateTimeFormatBuilder $this$byUnicodePattern, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)$this$byUnicodePattern, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        UnicodeFormat directives = UnicodeFormat.Companion.parse(pattern);
        UnicodeKt.byUnicodePattern$rec($this$byUnicodePattern, directives);
    }

    private static final UnicodeFormat unicodeDirective(char c, int formatLength) {
        UnicodeFormat unicodeFormat;
        switch (c) {
            case 'G': {
                unicodeFormat = new UnicodeFormat.Directive.YearMonthBased.Era(formatLength);
                break;
            }
            case 'y': {
                unicodeFormat = new UnicodeFormat.Directive.YearMonthBased.YearOfEra(formatLength);
                break;
            }
            case 'u': {
                unicodeFormat = new UnicodeFormat.Directive.YearMonthBased.Year(formatLength);
                break;
            }
            case 'U': {
                unicodeFormat = new UnicodeFormat.Directive.YearMonthBased.CyclicYearName(formatLength);
                break;
            }
            case 'r': {
                unicodeFormat = new UnicodeFormat.Directive.YearMonthBased.RelatedGregorianYear(formatLength);
                break;
            }
            case 'Q': {
                unicodeFormat = new UnicodeFormat.Directive.YearMonthBased.QuarterOfYear(formatLength);
                break;
            }
            case 'q': {
                unicodeFormat = new UnicodeFormat.Directive.YearMonthBased.StandaloneQuarterOfYear(formatLength);
                break;
            }
            case 'M': {
                unicodeFormat = new UnicodeFormat.Directive.YearMonthBased.MonthOfYear(formatLength);
                break;
            }
            case 'L': {
                unicodeFormat = new UnicodeFormat.Directive.YearMonthBased.StandaloneMonthOfYear(formatLength);
                break;
            }
            case 'Y': {
                unicodeFormat = new UnicodeFormat.Directive.DateBased.WeekBasedYear(formatLength);
                break;
            }
            case 'w': {
                unicodeFormat = new UnicodeFormat.Directive.DateBased.WeekOfWeekBasedYear(formatLength);
                break;
            }
            case 'W': {
                unicodeFormat = new UnicodeFormat.Directive.DateBased.WeekOfMonth(formatLength);
                break;
            }
            case 'd': {
                unicodeFormat = new UnicodeFormat.Directive.DateBased.DayOfMonth(formatLength);
                break;
            }
            case 'D': {
                unicodeFormat = new UnicodeFormat.Directive.DateBased.DayOfYear(formatLength);
                break;
            }
            case 'F': {
                unicodeFormat = new UnicodeFormat.Directive.DateBased.DayOfWeekInMonth(formatLength);
                break;
            }
            case 'g': {
                unicodeFormat = new UnicodeFormat.Directive.DateBased.ModifiedJulianDay(formatLength);
                break;
            }
            case 'E': {
                unicodeFormat = new UnicodeFormat.Directive.DateBased.DayOfWeek(formatLength);
                break;
            }
            case 'e': {
                unicodeFormat = new UnicodeFormat.Directive.DateBased.LocalizedDayOfWeek(formatLength);
                break;
            }
            case 'c': {
                unicodeFormat = new UnicodeFormat.Directive.DateBased.StandaloneLocalizedDayOfWeek(formatLength);
                break;
            }
            case 'a': {
                unicodeFormat = new UnicodeFormat.Directive.TimeBased.AmPmMarker(formatLength);
                break;
            }
            case 'h': {
                unicodeFormat = new UnicodeFormat.Directive.TimeBased.AmPmHourOfDay(formatLength);
                break;
            }
            case 'H': {
                unicodeFormat = new UnicodeFormat.Directive.TimeBased.HourOfDay(formatLength);
                break;
            }
            case 'm': {
                unicodeFormat = new UnicodeFormat.Directive.TimeBased.MinuteOfHour(formatLength);
                break;
            }
            case 's': {
                unicodeFormat = new UnicodeFormat.Directive.TimeBased.WithSecondPrecision.SecondOfMinute(formatLength);
                break;
            }
            case 'S': {
                unicodeFormat = new UnicodeFormat.Directive.TimeBased.WithSubsecondPrecision.FractionOfSecond(formatLength);
                break;
            }
            case 'A': {
                unicodeFormat = new UnicodeFormat.Directive.TimeBased.WithSubsecondPrecision.MilliOfDay(formatLength);
                break;
            }
            case 'n': {
                unicodeFormat = new UnicodeFormat.Directive.TimeBased.WithSubsecondPrecision.NanoOfSecond(formatLength);
                break;
            }
            case 'N': {
                unicodeFormat = new UnicodeFormat.Directive.TimeBased.WithSubsecondPrecision.NanoOfDay(formatLength);
                break;
            }
            case 'V': {
                unicodeFormat = new UnicodeFormat.Directive.ZoneBased.TimeZoneId(formatLength);
                break;
            }
            case 'v': {
                unicodeFormat = new UnicodeFormat.Directive.ZoneBased.GenericTimeZoneName(formatLength);
                break;
            }
            case 'z': {
                unicodeFormat = new UnicodeFormat.Directive.ZoneBased.TimeZoneName(formatLength);
                break;
            }
            case 'O': {
                unicodeFormat = new UnicodeFormat.Directive.OffsetBased.LocalizedZoneOffset(formatLength);
                break;
            }
            case 'X': {
                unicodeFormat = new UnicodeFormat.Directive.OffsetBased.ZoneOffset1(formatLength);
                break;
            }
            case 'x': {
                unicodeFormat = new UnicodeFormat.Directive.OffsetBased.ZoneOffset2(formatLength);
                break;
            }
            case 'Z': {
                unicodeFormat = new UnicodeFormat.Directive.OffsetBased.ZoneOffset3(formatLength);
                break;
            }
            default: {
                unicodeFormat = new UnknownUnicodeDirective(c, formatLength);
            }
        }
        return unicodeFormat;
    }

    private static final Void unsupportedDirective(String fieldName, String recommendation) {
        throw new UnsupportedOperationException("kotlinx.datetime formatting does not support the " + fieldName + " field. " + (recommendation != null ? recommendation + ' ' : "") + "Please report your use case to https://github.com/Kotlin/kotlinx-datetime/issues");
    }

    static /* synthetic */ Void unsupportedDirective$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return UnicodeKt.unsupportedDirective(string, string2);
    }

    private static final Void unknownLength(UnicodeFormat.Directive $this$unknownLength) {
        throw new IllegalArgumentException("Unknown length " + $this$unknownLength.getFormatLength() + " for the " + $this$unknownLength.getFormatLetter() + " directive");
    }

    private static final Void localizedDirective(UnicodeFormat.Directive $this$localizedDirective, String recommendation) {
        throw new IllegalArgumentException("The directive '" + $this$localizedDirective + "' is locale-dependent, but locales are not supported in Kotlin" + (recommendation != null ? ". " + recommendation : ""));
    }

    static /* synthetic */ Void localizedDirective$default(UnicodeFormat.Directive directive, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return UnicodeKt.localizedDirective(directive, string);
    }

    private static final Void unsupportedPadding(UnicodeFormat.Directive $this$unsupportedPadding, int digits) {
        throw new UnsupportedOperationException("Padding do " + digits + " digits is not supported for the " + $this$unsupportedPadding.getFormatLetter() + " directive");
    }

    private static final Unit byUnicodePattern$rec$lambda$1(DateTimeFormatBuilder $this$alternativeParsing) {
        Intrinsics.checkNotNullParameter((Object)$this$alternativeParsing, (String)"$this$alternativeParsing");
        return Unit.INSTANCE;
    }

    private static final Unit byUnicodePattern$rec$lambda$2(UnicodeFormat $format, DateTimeFormatBuilder $this$alternativeParsing) {
        Intrinsics.checkNotNullParameter((Object)$this$alternativeParsing, (String)"$this$alternativeParsing");
        UnicodeKt.byUnicodePattern$rec($this$alternativeParsing, ((UnicodeFormat.OptionalGroup)$format).getFormat());
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void byUnicodePattern$rec(DateTimeFormatBuilder builder, UnicodeFormat format) {
        UnicodeFormat unicodeFormat = format;
        if (unicodeFormat instanceof UnicodeFormat.StringLiteral) {
            builder.chars(((UnicodeFormat.StringLiteral)format).getLiteral());
            return;
        } else if (unicodeFormat instanceof UnicodeFormat.Sequence) {
            Iterable $this$forEach$iv = ((UnicodeFormat.Sequence)format).getFormats();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UnicodeFormat it = (UnicodeFormat)element$iv;
                boolean bl = false;
                UnicodeKt.byUnicodePattern$rec(builder, it);
            }
            return;
        } else if (unicodeFormat instanceof UnicodeFormat.OptionalGroup) {
            Function1[] function1Array = new Function1[]{UnicodeKt::byUnicodePattern$rec$lambda$1};
            DateTimeFormatBuilderKt.alternativeParsing(builder, function1Array, arg_0 -> UnicodeKt.byUnicodePattern$rec$lambda$2(format, arg_0));
            return;
        } else {
            if (!(unicodeFormat instanceof UnicodeFormat.Directive)) throw new NoWhenBranchMatchedException();
            UnicodeFormat.Directive directive = (UnicodeFormat.Directive)format;
            if (directive instanceof UnicodeFormat.Directive.TimeBased) {
                if (!(builder instanceof DateTimeFormatBuilder.WithTime)) {
                    boolean $i$a$-require-UnicodeKt$byUnicodePattern$rec$92 = false;
                    String $i$a$-require-UnicodeKt$byUnicodePattern$rec$92 = "A time-based directive " + format + " was used in a format builder that doesn't support time components";
                    throw new IllegalArgumentException($i$a$-require-UnicodeKt$byUnicodePattern$rec$92.toString());
                }
                ((UnicodeFormat.Directive.TimeBased)format).addToFormat((DateTimeFormatBuilder.WithTime)builder);
                return;
            } else if (directive instanceof UnicodeFormat.Directive.YearMonthBased) {
                if (!(builder instanceof DateTimeFormatBuilder.WithYearMonth)) {
                    boolean $i$a$-require-UnicodeKt$byUnicodePattern$rec$102 = false;
                    String $i$a$-require-UnicodeKt$byUnicodePattern$rec$102 = "A year-month-based directive " + format + " was used in a format builder that doesn't support year-month components";
                    throw new IllegalArgumentException($i$a$-require-UnicodeKt$byUnicodePattern$rec$102.toString());
                }
                ((UnicodeFormat.Directive.YearMonthBased)format).addToFormat((DateTimeFormatBuilder.WithYearMonth)builder);
                return;
            } else if (directive instanceof UnicodeFormat.Directive.DateBased) {
                if (!(builder instanceof DateTimeFormatBuilder.WithDate)) {
                    boolean $i$a$-require-UnicodeKt$byUnicodePattern$rec$112 = false;
                    String $i$a$-require-UnicodeKt$byUnicodePattern$rec$112 = "A date-based directive " + format + " was used in a format builder that doesn't support date components";
                    throw new IllegalArgumentException($i$a$-require-UnicodeKt$byUnicodePattern$rec$112.toString());
                }
                ((UnicodeFormat.Directive.DateBased)format).addToFormat((DateTimeFormatBuilder.WithDate)builder);
                return;
            } else if (directive instanceof UnicodeFormat.Directive.ZoneBased) {
                if (!(builder instanceof DateTimeFormatBuilder.WithDateTimeComponents)) {
                    boolean $i$a$-require-UnicodeKt$byUnicodePattern$rec$122 = false;
                    String $i$a$-require-UnicodeKt$byUnicodePattern$rec$122 = "A time-zone-based directive " + format + " was used in a format builder that doesn't support time-zone components";
                    throw new IllegalArgumentException($i$a$-require-UnicodeKt$byUnicodePattern$rec$122.toString());
                }
                ((UnicodeFormat.Directive.ZoneBased)format).addToFormat((DateTimeFormatBuilder.WithDateTimeComponents)builder);
                return;
            } else if (directive instanceof UnicodeFormat.Directive.OffsetBased) {
                if (!(builder instanceof DateTimeFormatBuilder.WithUtcOffset)) {
                    boolean bl = false;
                    String string = "A UTC-offset-based directive " + format + " was used in a format builder that doesn't support UTC offset components";
                    throw new IllegalArgumentException(string.toString());
                }
                ((UnicodeFormat.Directive.OffsetBased)format).addToFormat((DateTimeFormatBuilder.WithUtcOffset)builder);
                return;
            } else {
                if (!(directive instanceof UnknownUnicodeDirective)) throw new NoWhenBranchMatchedException();
                throw new IllegalArgumentException("The meaning of the directive '" + format + "' is unknown");
            }
        }
    }

    public static final /* synthetic */ UnicodeFormat access$unicodeDirective(char c, int formatLength) {
        return UnicodeKt.unicodeDirective(c, formatLength);
    }

    public static final /* synthetic */ List access$getNonPlainCharacters$p() {
        return nonPlainCharacters;
    }

    public static final /* synthetic */ Void access$unsupportedPadding(UnicodeFormat.Directive $receiver, int digits) {
        return UnicodeKt.unsupportedPadding($receiver, digits);
    }

    public static final /* synthetic */ Void access$unknownLength(UnicodeFormat.Directive $receiver) {
        return UnicodeKt.unknownLength($receiver);
    }

    public static final /* synthetic */ Void access$unsupportedDirective(String fieldName, String recommendation) {
        return UnicodeKt.unsupportedDirective(fieldName, recommendation);
    }

    public static final /* synthetic */ Void access$localizedDirective(UnicodeFormat.Directive $receiver, String recommendation) {
        return UnicodeKt.localizedDirective($receiver, recommendation);
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('['), Character.valueOf(']'), Character.valueOf('\'')};
        nonPlainCharacters = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }
}

