/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.CacheControl;
import okhttp3.Challenge;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okhttp3.TrailersSource;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001MB\u0083\u0001\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b,J\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b-J\r\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b.J\r\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\b2J\u000f\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\b3J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u0007042\u0006\u00105\u001a\u00020\u0007J\u001e\u00106\u001a\u0004\u0018\u00010\u00072\u0006\u00105\u001a\u00020\u00072\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u0007H\u0007J\r\u0010\f\u001a\u00020\rH\u0007\u00a2\u0006\u0002\b8J\u0006\u00109\u001a\u00020\rJ\b\u0010:\u001a\u0004\u0018\u00010\rJ\u000e\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020\u0014J\r\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\b=J\u0006\u0010>\u001a\u00020?J\u000f\u0010\u0010\u001a\u0004\u0018\u00010\u0000H\u0007\u00a2\u0006\u0002\bAJ\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u0000H\u0007\u00a2\u0006\u0002\bBJ\u000f\u0010\u0012\u001a\u0004\u0018\u00010\u0000H\u0007\u00a2\u0006\u0002\bCJ\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E04J\r\u0010F\u001a\u00020'H\u0007\u00a2\u0006\u0002\bGJ\r\u0010\u0013\u001a\u00020\u0014H\u0007\u00a2\u0006\u0002\bHJ\r\u0010\u0015\u001a\u00020\u0014H\u0007\u00a2\u0006\u0002\bIJ\b\u0010J\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020\u0007H\u0016R\u0013\u0010\u0002\u001a\u00020\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u001cR\u0013\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u001dR\u0013\u0010\u0006\u001a\u00020\u00078G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u001eR\u0013\u0010\b\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u001fR\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010 R\u0013\u0010\f\u001a\u00020\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010!R\u0013\u0010\u000e\u001a\u00020\u000f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\"R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u00008G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010#R\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u00008G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010#R\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u00008G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010#R\u0013\u0010\u0013\u001a\u00020\u00148G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010$R\u0013\u0010\u0015\u001a\u00020\u00148G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010$R\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00178AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010%R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00101R\u0011\u0010@\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u00101R\u0011\u0010F\u001a\u00020'8G\u00a2\u0006\u0006\u001a\u0004\bF\u0010)\u00a8\u0006N"}, d2={"Lokhttp3/Response;", "Ljava/io/Closeable;", "request", "Lokhttp3/Request;", "protocol", "Lokhttp3/Protocol;", "message", "", "code", "", "handshake", "Lokhttp3/Handshake;", "headers", "Lokhttp3/Headers;", "body", "Lokhttp3/ResponseBody;", "networkResponse", "cacheResponse", "priorResponse", "sentRequestAtMillis", "", "receivedResponseAtMillis", "exchange", "Lokhttp3/internal/connection/Exchange;", "trailersSource", "Lokhttp3/TrailersSource;", "<init>", "(Lokhttp3/Request;Lokhttp3/Protocol;Ljava/lang/String;ILokhttp3/Handshake;Lokhttp3/Headers;Lokhttp3/ResponseBody;Lokhttp3/Response;Lokhttp3/Response;Lokhttp3/Response;JJLokhttp3/internal/connection/Exchange;Lokhttp3/TrailersSource;)V", "()Lokhttp3/Request;", "()Lokhttp3/Protocol;", "()Ljava/lang/String;", "()I", "()Lokhttp3/Handshake;", "()Lokhttp3/Headers;", "()Lokhttp3/ResponseBody;", "()Lokhttp3/Response;", "()J", "()Lokhttp3/internal/connection/Exchange;", "lazyCacheControl", "Lokhttp3/CacheControl;", "getLazyCacheControl$okhttp", "()Lokhttp3/CacheControl;", "setLazyCacheControl$okhttp", "(Lokhttp3/CacheControl;)V", "-deprecated_request", "-deprecated_protocol", "-deprecated_code", "isSuccessful", "", "()Z", "-deprecated_message", "-deprecated_handshake", "", "name", "header", "defaultValue", "-deprecated_headers", "trailers", "peekTrailers", "peekBody", "byteCount", "-deprecated_body", "newBuilder", "Lokhttp3/Response$Builder;", "isRedirect", "-deprecated_networkResponse", "-deprecated_cacheResponse", "-deprecated_priorResponse", "challenges", "Lokhttp3/Challenge;", "cacheControl", "-deprecated_cacheControl", "-deprecated_sentRequestAtMillis", "-deprecated_receivedResponseAtMillis", "close", "", "toString", "Builder", "okhttp"})
public final class Response
implements Closeable {
    @NotNull
    private final Request request;
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final String message;
    private final int code;
    @Nullable
    private final Handshake handshake;
    @NotNull
    private final Headers headers;
    @NotNull
    private final ResponseBody body;
    @Nullable
    private final Response networkResponse;
    @Nullable
    private final Response cacheResponse;
    @Nullable
    private final Response priorResponse;
    private final long sentRequestAtMillis;
    private final long receivedResponseAtMillis;
    @Nullable
    private final Exchange exchange;
    @NotNull
    private TrailersSource trailersSource;
    @Nullable
    private CacheControl lazyCacheControl;
    private final boolean isSuccessful;
    private final boolean isRedirect;

    public Response(@NotNull Request request2, @NotNull Protocol protocol, @NotNull String message, int code2, @Nullable Handshake handshake, @NotNull Headers headers2, @NotNull ResponseBody body2, @Nullable Response networkResponse, @Nullable Response cacheResponse2, @Nullable Response priorResponse, long sentRequestAtMillis, long receivedResponseAtMillis, @Nullable Exchange exchange, @NotNull TrailersSource trailersSource) {
        boolean bl;
        Intrinsics.checkNotNullParameter(request2, "request");
        Intrinsics.checkNotNullParameter((Object)protocol, "protocol");
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(headers2, "headers");
        Intrinsics.checkNotNullParameter(body2, "body");
        Intrinsics.checkNotNullParameter(trailersSource, "trailersSource");
        this.request = request2;
        this.protocol = protocol;
        this.message = message;
        this.code = code2;
        this.handshake = handshake;
        this.headers = headers2;
        this.body = body2;
        this.networkResponse = networkResponse;
        this.cacheResponse = cacheResponse2;
        this.priorResponse = priorResponse;
        this.sentRequestAtMillis = sentRequestAtMillis;
        this.receivedResponseAtMillis = receivedResponseAtMillis;
        this.exchange = exchange;
        this.trailersSource = trailersSource;
        int n = this.code;
        this.isSuccessful = 200 <= n ? n < 300 : false;
        switch (this.code) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        this.isRedirect = bl;
    }

    @JvmName(name="request")
    @NotNull
    public final Request request() {
        return this.request;
    }

    @JvmName(name="protocol")
    @NotNull
    public final Protocol protocol() {
        return this.protocol;
    }

    @JvmName(name="message")
    @NotNull
    public final String message() {
        return this.message;
    }

    @JvmName(name="code")
    public final int code() {
        return this.code;
    }

    @JvmName(name="handshake")
    @Nullable
    public final Handshake handshake() {
        return this.handshake;
    }

    @JvmName(name="headers")
    @NotNull
    public final Headers headers() {
        return this.headers;
    }

    @JvmName(name="body")
    @NotNull
    public final ResponseBody body() {
        return this.body;
    }

    @JvmName(name="networkResponse")
    @Nullable
    public final Response networkResponse() {
        return this.networkResponse;
    }

    @JvmName(name="cacheResponse")
    @Nullable
    public final Response cacheResponse() {
        return this.cacheResponse;
    }

    @JvmName(name="priorResponse")
    @Nullable
    public final Response priorResponse() {
        return this.priorResponse;
    }

    @JvmName(name="sentRequestAtMillis")
    public final long sentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    @JvmName(name="receivedResponseAtMillis")
    public final long receivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    @JvmName(name="exchange")
    @Nullable
    public final Exchange exchange() {
        return this.exchange;
    }

    @Nullable
    public final CacheControl getLazyCacheControl$okhttp() {
        return this.lazyCacheControl;
    }

    public final void setLazyCacheControl$okhttp(@Nullable CacheControl cacheControl) {
        this.lazyCacheControl = cacheControl;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="request", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_request")
    @NotNull
    public final Request -deprecated_request() {
        return this.request;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="protocol", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_protocol")
    @NotNull
    public final Protocol -deprecated_protocol() {
        return this.protocol;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="code", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_code")
    public final int -deprecated_code() {
        return this.code;
    }

    public final boolean isSuccessful() {
        return this.isSuccessful;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="message", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_message")
    @NotNull
    public final String -deprecated_message() {
        return this.message;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="handshake", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_handshake")
    @Nullable
    public final Handshake -deprecated_handshake() {
        return this.handshake;
    }

    @NotNull
    public final List<String> headers(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.headers.values(name);
    }

    @JvmOverloads
    @Nullable
    public final String header(@NotNull String name, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string2 = this.headers.get(name);
        if (string2 == null) {
            string2 = defaultValue;
        }
        return string2;
    }

    public static /* synthetic */ String header$default(Response response2, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        return response2.header(string2, string3);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="headers", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_headers")
    @NotNull
    public final Headers -deprecated_headers() {
        return this.headers;
    }

    @NotNull
    public final Headers trailers() throws IOException {
        return this.trailersSource.get();
    }

    @Nullable
    public final Headers peekTrailers() throws IOException {
        return this.trailersSource.peek();
    }

    @NotNull
    public final ResponseBody peekBody(long byteCount) throws IOException {
        BufferedSource peeked = this.body.source().peek();
        Buffer buffer = new Buffer();
        peeked.request(byteCount);
        buffer.write(peeked, Math.min(byteCount, peeked.getBuffer().size()));
        return ResponseBody.Companion.create(buffer, this.body.contentType(), buffer.size());
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="body", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_body")
    @NotNull
    public final ResponseBody -deprecated_body() {
        return this.body;
    }

    @NotNull
    public final Builder newBuilder() {
        return new Builder(this);
    }

    public final boolean isRedirect() {
        return this.isRedirect;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="networkResponse", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_networkResponse")
    @Nullable
    public final Response -deprecated_networkResponse() {
        return this.networkResponse;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="cacheResponse", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_cacheResponse")
    @Nullable
    public final Response -deprecated_cacheResponse() {
        return this.cacheResponse;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="priorResponse", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_priorResponse")
    @Nullable
    public final Response -deprecated_priorResponse() {
        return this.priorResponse;
    }

    @NotNull
    public final List<Challenge> challenges() {
        String string2;
        switch (this.code) {
            case 401: {
                string2 = "WWW-Authenticate";
                break;
            }
            case 407: {
                string2 = "Proxy-Authenticate";
                break;
            }
            default: {
                return CollectionsKt.emptyList();
            }
        }
        return HttpHeaders.parseChallenges(this.headers, string2);
    }

    @JvmName(name="cacheControl")
    @NotNull
    public final CacheControl cacheControl() {
        CacheControl result2 = this.lazyCacheControl;
        if (result2 == null) {
            this.lazyCacheControl = result2 = CacheControl.Companion.parse(this.headers);
        }
        return result2;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="cacheControl", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_cacheControl")
    @NotNull
    public final CacheControl -deprecated_cacheControl() {
        return this.cacheControl();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="sentRequestAtMillis", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_sentRequestAtMillis")
    public final long -deprecated_sentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="receivedResponseAtMillis", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_receivedResponseAtMillis")
    public final long -deprecated_receivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    @Override
    public void close() {
        this.body.close();
    }

    @NotNull
    public String toString() {
        return "Response{protocol=" + (Object)((Object)this.protocol) + ", code=" + this.code + ", message=" + this.message + ", url=" + this.request.url() + '}';
    }

    @JvmOverloads
    @Nullable
    public final String header(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Response.header$default(this, name, null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001f\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0018\u0010P\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u001a2\u0006\u0010R\u001a\u00020\u001aH\u0016J\u0018\u0010S\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u001a2\u0006\u0010R\u001a\u00020\u001aH\u0016J\u0010\u0010T\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u001aH\u0016J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010%\u001a\u00020UH\u0016J\u0010\u0010+\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,H\u0016J\u0012\u00101\u001a\u00020\u00002\b\u00101\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u00105\u001a\u00020\u00002\b\u00105\u001a\u0004\u0018\u00010\u0005H\u0016J\u001a\u0010V\u001a\u00020W2\u0006\u0010Q\u001a\u00020\u001a2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u00108\u001a\u00020\u00002\b\u00108\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010X\u001a\u00020\u00002\u0006\u0010J\u001a\u00020KH\u0016J\u0010\u0010;\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010A\u001a\u00020\u00002\u0006\u0010A\u001a\u00020<H\u0016J\u0015\u0010Y\u001a\u00020W2\u0006\u0010D\u001a\u00020EH\u0000\u00a2\u0006\u0002\bZJ\b\u0010[\u001a\u00020\u0005H\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001c\u00101\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u0010\u0006R\u001c\u00105\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00103\"\u0004\b7\u0010\u0006R\u001c\u00108\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00103\"\u0004\b:\u0010\u0006R\u001a\u0010;\u001a\u00020<X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001a\u0010A\u001a\u00020<X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010>\"\u0004\bC\u0010@R\u001c\u0010D\u001a\u0004\u0018\u00010EX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020KX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010O\u00a8\u0006\\"}, d2={"Lokhttp3/Response$Builder;", "", "<init>", "()V", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)V", "request", "Lokhttp3/Request;", "getRequest$okhttp", "()Lokhttp3/Request;", "setRequest$okhttp", "(Lokhttp3/Request;)V", "protocol", "Lokhttp3/Protocol;", "getProtocol$okhttp", "()Lokhttp3/Protocol;", "setProtocol$okhttp", "(Lokhttp3/Protocol;)V", "code", "", "getCode$okhttp", "()I", "setCode$okhttp", "(I)V", "message", "", "getMessage$okhttp", "()Ljava/lang/String;", "setMessage$okhttp", "(Ljava/lang/String;)V", "handshake", "Lokhttp3/Handshake;", "getHandshake$okhttp", "()Lokhttp3/Handshake;", "setHandshake$okhttp", "(Lokhttp3/Handshake;)V", "headers", "Lokhttp3/Headers$Builder;", "getHeaders$okhttp", "()Lokhttp3/Headers$Builder;", "setHeaders$okhttp", "(Lokhttp3/Headers$Builder;)V", "body", "Lokhttp3/ResponseBody;", "getBody$okhttp", "()Lokhttp3/ResponseBody;", "setBody$okhttp", "(Lokhttp3/ResponseBody;)V", "networkResponse", "getNetworkResponse$okhttp", "()Lokhttp3/Response;", "setNetworkResponse$okhttp", "cacheResponse", "getCacheResponse$okhttp", "setCacheResponse$okhttp", "priorResponse", "getPriorResponse$okhttp", "setPriorResponse$okhttp", "sentRequestAtMillis", "", "getSentRequestAtMillis$okhttp", "()J", "setSentRequestAtMillis$okhttp", "(J)V", "receivedResponseAtMillis", "getReceivedResponseAtMillis$okhttp", "setReceivedResponseAtMillis$okhttp", "exchange", "Lokhttp3/internal/connection/Exchange;", "getExchange$okhttp", "()Lokhttp3/internal/connection/Exchange;", "setExchange$okhttp", "(Lokhttp3/internal/connection/Exchange;)V", "trailersSource", "Lokhttp3/TrailersSource;", "getTrailersSource$okhttp", "()Lokhttp3/TrailersSource;", "setTrailersSource$okhttp", "(Lokhttp3/TrailersSource;)V", "header", "name", "value", "addHeader", "removeHeader", "Lokhttp3/Headers;", "checkSupportResponse", "", "trailers", "initExchange", "initExchange$okhttp", "build", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Response.kt\nokhttp3/Response$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,517:1\n1#2:518\n*E\n"})
    public static class Builder {
        @Nullable
        private Request request;
        @Nullable
        private Protocol protocol;
        private int code;
        @Nullable
        private String message;
        @Nullable
        private Handshake handshake;
        @NotNull
        private Headers.Builder headers;
        @NotNull
        private ResponseBody body;
        @Nullable
        private Response networkResponse;
        @Nullable
        private Response cacheResponse;
        @Nullable
        private Response priorResponse;
        private long sentRequestAtMillis;
        private long receivedResponseAtMillis;
        @Nullable
        private Exchange exchange;
        @NotNull
        private TrailersSource trailersSource;

        @Nullable
        public final Request getRequest$okhttp() {
            return this.request;
        }

        public final void setRequest$okhttp(@Nullable Request request2) {
            this.request = request2;
        }

        @Nullable
        public final Protocol getProtocol$okhttp() {
            return this.protocol;
        }

        public final void setProtocol$okhttp(@Nullable Protocol protocol) {
            this.protocol = protocol;
        }

        public final int getCode$okhttp() {
            return this.code;
        }

        public final void setCode$okhttp(int n) {
            this.code = n;
        }

        @Nullable
        public final String getMessage$okhttp() {
            return this.message;
        }

        public final void setMessage$okhttp(@Nullable String string2) {
            this.message = string2;
        }

        @Nullable
        public final Handshake getHandshake$okhttp() {
            return this.handshake;
        }

        public final void setHandshake$okhttp(@Nullable Handshake handshake) {
            this.handshake = handshake;
        }

        @NotNull
        public final Headers.Builder getHeaders$okhttp() {
            return this.headers;
        }

        public final void setHeaders$okhttp(@NotNull Headers.Builder builder) {
            Intrinsics.checkNotNullParameter(builder, "<set-?>");
            this.headers = builder;
        }

        @NotNull
        public final ResponseBody getBody$okhttp() {
            return this.body;
        }

        public final void setBody$okhttp(@NotNull ResponseBody responseBody) {
            Intrinsics.checkNotNullParameter(responseBody, "<set-?>");
            this.body = responseBody;
        }

        @Nullable
        public final Response getNetworkResponse$okhttp() {
            return this.networkResponse;
        }

        public final void setNetworkResponse$okhttp(@Nullable Response response2) {
            this.networkResponse = response2;
        }

        @Nullable
        public final Response getCacheResponse$okhttp() {
            return this.cacheResponse;
        }

        public final void setCacheResponse$okhttp(@Nullable Response response2) {
            this.cacheResponse = response2;
        }

        @Nullable
        public final Response getPriorResponse$okhttp() {
            return this.priorResponse;
        }

        public final void setPriorResponse$okhttp(@Nullable Response response2) {
            this.priorResponse = response2;
        }

        public final long getSentRequestAtMillis$okhttp() {
            return this.sentRequestAtMillis;
        }

        public final void setSentRequestAtMillis$okhttp(long l) {
            this.sentRequestAtMillis = l;
        }

        public final long getReceivedResponseAtMillis$okhttp() {
            return this.receivedResponseAtMillis;
        }

        public final void setReceivedResponseAtMillis$okhttp(long l) {
            this.receivedResponseAtMillis = l;
        }

        @Nullable
        public final Exchange getExchange$okhttp() {
            return this.exchange;
        }

        public final void setExchange$okhttp(@Nullable Exchange exchange) {
            this.exchange = exchange;
        }

        @NotNull
        public final TrailersSource getTrailersSource$okhttp() {
            return this.trailersSource;
        }

        public final void setTrailersSource$okhttp(@NotNull TrailersSource trailersSource) {
            Intrinsics.checkNotNullParameter(trailersSource, "<set-?>");
            this.trailersSource = trailersSource;
        }

        public Builder() {
            this.code = -1;
            this.body = ResponseBody.EMPTY;
            this.trailersSource = TrailersSource.EMPTY;
            this.headers = new Headers.Builder();
        }

        public Builder(@NotNull Response response2) {
            Intrinsics.checkNotNullParameter(response2, "response");
            this.code = -1;
            this.body = ResponseBody.EMPTY;
            this.trailersSource = TrailersSource.EMPTY;
            this.request = response2.request();
            this.protocol = response2.protocol();
            this.code = response2.code();
            this.message = response2.message();
            this.handshake = response2.handshake();
            this.headers = response2.headers().newBuilder();
            this.body = response2.body();
            this.networkResponse = response2.networkResponse();
            this.cacheResponse = response2.cacheResponse();
            this.priorResponse = response2.priorResponse();
            this.sentRequestAtMillis = response2.sentRequestAtMillis();
            this.receivedResponseAtMillis = response2.receivedResponseAtMillis();
            this.exchange = response2.exchange();
            this.trailersSource = response2.trailersSource;
        }

        @NotNull
        public Builder request(@NotNull Request request2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(request2, "request");
            Builder $this$request_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$request_u24lambda_u240.request = request2;
            return builder;
        }

        @NotNull
        public Builder protocol(@NotNull Protocol protocol) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)protocol, "protocol");
            Builder $this$protocol_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$protocol_u24lambda_u241.protocol = protocol;
            return builder;
        }

        @NotNull
        public Builder code(int code2) {
            Builder builder;
            Builder $this$code_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$code_u24lambda_u242.code = code2;
            return builder;
        }

        @NotNull
        public Builder message(@NotNull String message) {
            Builder builder;
            Intrinsics.checkNotNullParameter(message, "message");
            Builder $this$message_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$message_u24lambda_u243.message = message;
            return builder;
        }

        @NotNull
        public Builder handshake(@Nullable Handshake handshake) {
            Builder builder;
            Builder $this$handshake_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$handshake_u24lambda_u244.handshake = handshake;
            return builder;
        }

        @NotNull
        public Builder header(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$header_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$header_u24lambda_u245.headers.set(name, value);
            return builder;
        }

        @NotNull
        public Builder addHeader(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$addHeader_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$addHeader_u24lambda_u246.headers.add(name, value);
            return builder;
        }

        @NotNull
        public Builder removeHeader(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Builder $this$removeHeader_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$removeHeader_u24lambda_u247.headers.removeAll(name);
            return builder;
        }

        @NotNull
        public Builder headers(@NotNull Headers headers2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers2, "headers");
            Builder $this$headers_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u248.headers = headers2.newBuilder();
            return builder;
        }

        @NotNull
        public Builder body(@NotNull ResponseBody body2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(body2, "body");
            Builder $this$body_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$body_u24lambda_u249.body = body2;
            return builder;
        }

        @NotNull
        public Builder networkResponse(@Nullable Response networkResponse) {
            Builder builder;
            Builder $this$networkResponse_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$networkResponse_u24lambda_u2410.checkSupportResponse("networkResponse", networkResponse);
            $this$networkResponse_u24lambda_u2410.networkResponse = networkResponse;
            return builder;
        }

        @NotNull
        public Builder cacheResponse(@Nullable Response cacheResponse2) {
            Builder builder;
            Builder $this$cacheResponse_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$cacheResponse_u24lambda_u2411.checkSupportResponse("cacheResponse", cacheResponse2);
            $this$cacheResponse_u24lambda_u2411.cacheResponse = cacheResponse2;
            return builder;
        }

        private final void checkSupportResponse(String name, Response response2) {
            Response response3 = response2;
            if (response3 != null) {
                Response response4;
                Response $this$checkSupportResponse_u24lambda_u2415 = response4 = response3;
                boolean bl = false;
                if (!($this$checkSupportResponse_u24lambda_u2415.networkResponse() == null)) {
                    boolean $i$a$-require-Response$Builder$checkSupportResponse$1$42 = false;
                    String $i$a$-require-Response$Builder$checkSupportResponse$1$42 = name + ".networkResponse != null";
                    throw new IllegalArgumentException($i$a$-require-Response$Builder$checkSupportResponse$1$42.toString());
                }
                if (!($this$checkSupportResponse_u24lambda_u2415.cacheResponse() == null)) {
                    boolean $i$a$-require-Response$Builder$checkSupportResponse$1$52 = false;
                    String $i$a$-require-Response$Builder$checkSupportResponse$1$52 = name + ".cacheResponse != null";
                    throw new IllegalArgumentException($i$a$-require-Response$Builder$checkSupportResponse$1$52.toString());
                }
                if (!($this$checkSupportResponse_u24lambda_u2415.priorResponse() == null)) {
                    boolean bl2 = false;
                    String string2 = name + ".priorResponse != null";
                    throw new IllegalArgumentException(string2.toString());
                }
            }
        }

        @NotNull
        public Builder priorResponse(@Nullable Response priorResponse) {
            Builder builder;
            Builder $this$priorResponse_u24lambda_u2416 = builder = this;
            boolean bl = false;
            $this$priorResponse_u24lambda_u2416.priorResponse = priorResponse;
            return builder;
        }

        @NotNull
        public Builder trailers(@NotNull TrailersSource trailersSource) {
            Builder builder;
            Intrinsics.checkNotNullParameter(trailersSource, "trailersSource");
            Builder $this$trailers_u24lambda_u2417 = builder = this;
            boolean bl = false;
            $this$trailers_u24lambda_u2417.trailersSource = trailersSource;
            return builder;
        }

        @NotNull
        public Builder sentRequestAtMillis(long sentRequestAtMillis) {
            Builder builder;
            Builder $this$sentRequestAtMillis_u24lambda_u2418 = builder = this;
            boolean bl = false;
            $this$sentRequestAtMillis_u24lambda_u2418.sentRequestAtMillis = sentRequestAtMillis;
            return builder;
        }

        @NotNull
        public Builder receivedResponseAtMillis(long receivedResponseAtMillis) {
            Builder builder;
            Builder $this$receivedResponseAtMillis_u24lambda_u2419 = builder = this;
            boolean bl = false;
            $this$receivedResponseAtMillis_u24lambda_u2419.receivedResponseAtMillis = receivedResponseAtMillis;
            return builder;
        }

        public final void initExchange$okhttp(@NotNull Exchange exchange) {
            Intrinsics.checkNotNullParameter(exchange, "exchange");
            this.exchange = exchange;
        }

        @NotNull
        public Response build() {
            if (!(this.code >= 0)) {
                boolean $i$a$-check-Response$Builder$build$22 = false;
                String $i$a$-check-Response$Builder$build$22 = "code < 0: " + this.code;
                throw new IllegalStateException($i$a$-check-Response$Builder$build$22.toString());
            }
            Request request2 = this.request;
            if (request2 == null) {
                boolean $i$a$-checkNotNull-Response$Builder$build$52 = false;
                String $i$a$-checkNotNull-Response$Builder$build$52 = "request == null";
                throw new IllegalStateException($i$a$-checkNotNull-Response$Builder$build$52.toString());
            }
            Protocol protocol = this.protocol;
            if (protocol == null) {
                Request request3 = request2;
                boolean $i$a$-checkNotNull-Response$Builder$build$62 = false;
                Request request4 = request3;
                String $i$a$-checkNotNull-Response$Builder$build$62 = "protocol == null";
                throw new IllegalStateException($i$a$-checkNotNull-Response$Builder$build$62.toString());
            }
            String string2 = this.message;
            if (string2 == null) {
                Protocol protocol2 = protocol;
                Request request5 = request2;
                boolean bl = false;
                String string3 = "message == null";
                Request request6 = request5;
                Protocol protocol3 = protocol2;
                String string4 = string3;
                throw new IllegalStateException(string4.toString());
            }
            TrailersSource trailersSource = this.trailersSource;
            Exchange exchange = this.exchange;
            long l = this.receivedResponseAtMillis;
            long l2 = this.sentRequestAtMillis;
            Response response2 = this.priorResponse;
            Response response3 = this.cacheResponse;
            Response response4 = this.networkResponse;
            ResponseBody responseBody = this.body;
            Headers headers2 = this.headers.build();
            Handshake handshake = this.handshake;
            int n = this.code;
            String string5 = string2;
            Protocol protocol4 = protocol;
            Request request7 = request2;
            return new Response(request7, protocol4, string5, n, handshake, headers2, responseBody, response4, response3, response2, l2, l, exchange, trailersSource);
        }
    }
}

