/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.utils;

import com.networknt.schema.AbsoluteIri;
import java.io.UnsupportedEncodingException;
import java.net.IDN;
import java.net.URI;
import java.net.URLEncoder;

public class AbsoluteIris {
    public static String toUri(AbsoluteIri iri) {
        String iriString = iri.toString();
        boolean ascii = AbsoluteIris.isAscii(iriString);
        if (ascii) {
            int index2 = iriString.indexOf(63);
            if (index2 == -1) {
                return iriString;
            }
            String rest = iriString.substring(0, index2 + 1);
            String query = iriString.substring(index2 + 1);
            StringBuilder result2 = new StringBuilder(rest);
            AbsoluteIris.handleQuery(result2, query);
            return result2.toString();
        }
        String[] parts = iriString.split(":");
        if (parts.length == 2) {
            StringBuilder result3 = new StringBuilder(parts[0]);
            result3.append(":");
            String rest = parts[1];
            if (rest.startsWith("//")) {
                rest = rest.substring(2);
                result3.append("//");
            } else if (rest.startsWith("/")) {
                rest = rest.substring(1);
                result3.append("/");
            }
            String[] query = rest.split("\\?");
            String[] restParts = query[0].split("/");
            for (int x2 = 0; x2 < restParts.length; ++x2) {
                String p2 = restParts[x2];
                if (x2 == 0) {
                    if (AbsoluteIris.isAscii(p2)) {
                        result3.append(p2);
                    } else {
                        result3.append(AbsoluteIris.unicodeToASCII(p2));
                    }
                } else {
                    result3.append(p2);
                }
                if (x2 == restParts.length - 1) continue;
                result3.append("/");
            }
            if (query[0].endsWith("/")) {
                result3.append("/");
            }
            if (query.length == 2) {
                result3.append("?");
                AbsoluteIris.handleQuery(result3, query[1]);
            }
            return URI.create(result3.toString()).toASCIIString();
        }
        return iriString;
    }

    static boolean isAscii(String value) {
        return value.codePoints().allMatch(ch -> ch < 127);
    }

    static void handleQuery(StringBuilder result2, String query) {
        String[] queryParts = query.split("&");
        for (int y2 = 0; y2 < queryParts.length; ++y2) {
            String queryPart = queryParts[y2];
            String[] nameValue = queryPart.split("=");
            try {
                result2.append(URLEncoder.encode(nameValue[0], "UTF-8"));
                if (nameValue.length == 2) {
                    result2.append("=");
                    result2.append(URLEncoder.encode(nameValue[1], "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
            if (y2 == queryParts.length - 1) continue;
            result2.append("&");
        }
    }

    static String unicodeToASCII(String input2) {
        try {
            String ascii = IDN.toASCII(input2);
            if (IDNBUGHOLDER.IDN_TOASCII_PRESERVES_TRAILING_DOTS) {
                return ascii;
            }
            int length = input2.length();
            if (length == 0) {
                return input2;
            }
            char lastChar = input2.charAt(length - 1);
            switch (lastChar) {
                case '.': 
                case '\u3002': 
                case '\uff0e': 
                case '\uff61': {
                    return ascii + ".";
                }
            }
            return ascii;
        }
        catch (IllegalArgumentException e) {
            return input2;
        }
    }

    private static class IDNBUGHOLDER {
        private static final boolean IDN_TOASCII_PRESERVES_TRAILING_DOTS = IDNBUGHOLDER.keepsTrailingDot();

        private IDNBUGHOLDER() {
        }

        private static boolean keepsTrailingDot() {
            String input2 = "a.";
            return "a.".equals(IDN.toASCII("a."));
        }
    }
}

