/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.internal;

import androidx.navigation.NavArgument;
import androidx.navigation.NavArgumentKt;
import androidx.navigation.NavDeepLink;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavDestination;
import androidx.navigation.NavUri;
import androidx.navigation.NavUriKt;
import androidx.savedstate.SavedState;
import androidx.savedstate.SavedStateReader;
import androidx.savedstate.SavedStateWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b(J\u0017\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010 \u001a\u00020\tH\u0000\u00a2\u0006\u0002\b+J\u0017\u0010,\u001a\u0004\u0018\u00010*2\u0006\u0010-\u001a\u00020.H\u0000\u00a2\u0006\u0002\b/J.\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00102\b\u00103\u001a\u0004\u0018\u0001042\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001505H\u0002J\u001f\u00106\u001a\u0002012\u0006\u0010 \u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u000107H\u0000\u00a2\u0006\u0002\b8J\u001d\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b<J\u0015\u0010=\u001a\u00020&2\u0006\u0010:\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b>J\u0019\u0010?\u001a\u0004\u0018\u0001072\b\u0010@\u001a\u0004\u0018\u000107H\u0000\u00a2\u0006\u0002\bAR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R&\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00150\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR(\u0010 \u001a\u0004\u0018\u00010\t2\b\u0010 \u001a\u0004\u0018\u00010\t@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000b\"\u0004\b\"\u0010\rR\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Landroidx/navigation/internal/NavDestinationImpl;", "", "destination", "Landroidx/navigation/NavDestination;", "<init>", "(Landroidx/navigation/NavDestination;)V", "getDestination", "()Landroidx/navigation/NavDestination;", "idName", "", "getIdName$navigation_common", "()Ljava/lang/String;", "setIdName$navigation_common", "(Ljava/lang/String;)V", "deepLinks", "", "Landroidx/navigation/NavDeepLink;", "getDeepLinks$navigation_common", "()Ljava/util/List;", "arguments", "", "Landroidx/navigation/NavArgument;", "getArguments$navigation_common", "()Ljava/util/Map;", "setArguments$navigation_common", "(Ljava/util/Map;)V", "id", "", "getId$navigation_common", "()I", "setId$navigation_common", "(I)V", "route", "getRoute$navigation_common", "setRoute$navigation_common", "routeDeepLink", "Lkotlin/Lazy;", "addDeepLink", "", "navDeepLink", "addDeepLink$navigation_common", "matchRoute", "Landroidx/navigation/NavDestination$DeepLinkMatch;", "matchRoute$navigation_common", "matchDeepLink", "navDeepLinkRequest", "Landroidx/navigation/NavDeepLinkRequest;", "matchDeepLink$navigation_common", "hasRequiredArguments", "", "deepLink", "uri", "Landroidx/navigation/NavUri;", "", "hasRoute", "Landroidx/savedstate/SavedState;", "hasRoute$navigation_common", "addArgument", "argumentName", "argument", "addArgument$navigation_common", "removeArgument", "removeArgument$navigation_common", "addInDefaultArgs", "args", "addInDefaultArgs$navigation_common", "navigation-common"})
@SourceDebugExtension(value={"SMAP\nNavDestinationImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavDestinationImpl.kt\nandroidx/navigation/internal/NavDestinationImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SavedState.nonAndroid.kt\nandroidx/savedstate/SavedStateKt__SavedState_nonAndroidKt\n+ 4 SavedState.kt\nandroidx/savedstate/SavedStateKt__SavedStateKt\n+ 5 SavedState.nonAndroid.kt\nandroidx/savedstate/SavedStateKt__SavedState_nonAndroidKt$savedState$1\n*L\n1#1,213:1\n1#2:214\n1#2:219\n30#3:215\n45#3:216\n34#3,2:217\n106#4:220\n106#4:222\n90#4:223\n45#5:221\n*S KotlinDebug\n*F\n+ 1 NavDestinationImpl.kt\nandroidx/navigation/internal/NavDestinationImpl\n*L\n193#1:219\n193#1:215\n193#1:216\n193#1:217,2\n193#1:220\n198#1:222\n161#1:223\n193#1:221\n*E\n"})
public final class NavDestinationImpl {
    @NotNull
    private final NavDestination destination;
    @Nullable
    private String idName;
    @NotNull
    private final List<NavDeepLink> deepLinks;
    @NotNull
    private Map<String, NavArgument> arguments;
    private int id;
    @Nullable
    private String route;
    @Nullable
    private Lazy<NavDeepLink> routeDeepLink;

    public NavDestinationImpl(@NotNull NavDestination destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        this.destination = destination;
        this.deepLinks = new ArrayList();
        this.arguments = new LinkedHashMap();
    }

    @NotNull
    public final NavDestination getDestination() {
        return this.destination;
    }

    @Nullable
    public final String getIdName$navigation_common() {
        return this.idName;
    }

    public final void setIdName$navigation_common(@Nullable String string2) {
        this.idName = string2;
    }

    @NotNull
    public final List<NavDeepLink> getDeepLinks$navigation_common() {
        return this.deepLinks;
    }

    @NotNull
    public final Map<String, NavArgument> getArguments$navigation_common() {
        return this.arguments;
    }

    public final void setArguments$navigation_common(@NotNull Map<String, NavArgument> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.arguments = map2;
    }

    public final int getId$navigation_common() {
        return this.id;
    }

    public final void setId$navigation_common(int id) {
        this.id = id;
        this.idName = null;
    }

    @Nullable
    public final String getRoute$navigation_common() {
        return this.route;
    }

    public final void setRoute$navigation_common(@Nullable String route) {
        if (route == null) {
            this.setId$navigation_common(0);
        } else {
            if (!(!StringsKt.isBlank(route))) {
                boolean $i$a$-require-NavDestinationImpl$route$32 = false;
                String $i$a$-require-NavDestinationImpl$route$32 = "Cannot have an empty route";
                throw new IllegalArgumentException($i$a$-require-NavDestinationImpl$route$32.toString());
            }
            String tempRoute = NavDestination.Companion.createRoute(route);
            NavDeepLink tempDeepLink = new NavDeepLink.Builder().setUriPattern(tempRoute).build();
            List<String> missingRequiredArguments = NavArgumentKt.missingRequiredArguments(this.arguments, arg_0 -> NavDestinationImpl._set_route_$lambda$1(tempDeepLink, arg_0));
            if (!missingRequiredArguments.isEmpty()) {
                boolean bl = false;
                String string2 = "Cannot set route \"" + route + "\" for destination " + this.destination + ". Following required arguments are missing: " + missingRequiredArguments;
                throw new IllegalArgumentException(string2.toString());
            }
            this.routeDeepLink = LazyKt.lazy(() -> NavDestinationImpl._set_route_$lambda$3(tempRoute));
            this.setId$navigation_common(tempRoute.hashCode());
        }
        this.route = route;
    }

    public final void addDeepLink$navigation_common(@NotNull NavDeepLink navDeepLink2) {
        Intrinsics.checkNotNullParameter(navDeepLink2, "navDeepLink");
        List<String> missingRequiredArguments = NavArgumentKt.missingRequiredArguments(this.arguments, arg_0 -> NavDestinationImpl.addDeepLink$lambda$4(navDeepLink2, arg_0));
        if (!missingRequiredArguments.isEmpty()) {
            boolean bl = false;
            String string2 = "Deep link " + navDeepLink2.getUriPattern() + " can't be used to open destination " + this.destination + ".\nFollowing required arguments are missing: " + missingRequiredArguments;
            throw new IllegalArgumentException(string2.toString());
        }
        this.deepLinks.add(navDeepLink2);
    }

    @Nullable
    public final NavDestination.DeepLinkMatch matchRoute$navigation_common(@NotNull String route) {
        Intrinsics.checkNotNullParameter(route, "route");
        Lazy<NavDeepLink> lazy = this.routeDeepLink;
        if (lazy == null || (lazy = lazy.getValue()) == null) {
            return null;
        }
        Lazy<NavDeepLink> routeDeepLink = lazy;
        NavUri uri = NavUriKt.NavUri(NavDestination.Companion.createRoute(route));
        SavedState savedState2 = ((NavDeepLink)((Object)routeDeepLink)).getMatchingArguments(uri, this.arguments);
        if (savedState2 == null) {
            return null;
        }
        SavedState matchingArguments = savedState2;
        int matchingPathSegments = ((NavDeepLink)((Object)routeDeepLink)).calculateMatchingPathSegments$navigation_common(uri);
        return new NavDestination.DeepLinkMatch(this.destination, matchingArguments, ((NavDeepLink)((Object)routeDeepLink)).isExactDeepLink(), matchingPathSegments, false, -1);
    }

    @Nullable
    public final NavDestination.DeepLinkMatch matchDeepLink$navigation_common(@NotNull NavDeepLinkRequest navDeepLinkRequest) {
        Intrinsics.checkNotNullParameter(navDeepLinkRequest, "navDeepLinkRequest");
        if (this.deepLinks.isEmpty()) {
            return null;
        }
        NavDestination.DeepLinkMatch bestMatch = null;
        for (NavDeepLink deepLink2 : this.deepLinks) {
            int mimeTypeMatchLevel;
            String mimeType;
            NavUri uri = navDeepLinkRequest.getUri();
            if (!deepLink2.matches$navigation_common(navDeepLinkRequest)) continue;
            NavUri navUri = uri;
            SavedState matchingArguments = navUri != null ? deepLink2.getMatchingArguments(navUri, this.arguments) : null;
            int matchingPathSegments = deepLink2.calculateMatchingPathSegments$navigation_common(uri);
            String requestAction = navDeepLinkRequest.getAction();
            boolean matchingAction = requestAction != null && Intrinsics.areEqual(requestAction, deepLink2.getAction());
            String string2 = mimeType = navDeepLinkRequest.getMimeType();
            int n = mimeTypeMatchLevel = string2 != null ? deepLink2.getMimeTypeMatchRating(string2) : -1;
            if (matchingArguments == null && (!matchingAction && mimeTypeMatchLevel <= -1 || !this.hasRequiredArguments(deepLink2, uri, this.arguments))) continue;
            NavDestination.DeepLinkMatch newMatch = new NavDestination.DeepLinkMatch(this.destination, matchingArguments, deepLink2.isExactDeepLink(), matchingPathSegments, matchingAction, mimeTypeMatchLevel);
            if (bestMatch != null && newMatch.compareTo(bestMatch) <= 0) continue;
            bestMatch = newMatch;
        }
        return bestMatch;
    }

    private final boolean hasRequiredArguments(NavDeepLink deepLink2, NavUri uri, Map<String, NavArgument> arguments) {
        SavedState matchingArgs = deepLink2.getMatchingPathAndQueryArgs$navigation_common(uri, arguments);
        List<String> missingRequiredArguments = NavArgumentKt.missingRequiredArguments(arguments, arg_0 -> NavDestinationImpl.hasRequiredArguments$lambda$7(matchingArgs, arg_0));
        return missingRequiredArguments.isEmpty();
    }

    public final boolean hasRoute$navigation_common(@NotNull String route, @Nullable SavedState arguments) {
        NavDestination.DeepLinkMatch matchingDeepLink;
        Intrinsics.checkNotNullParameter(route, "route");
        if (Intrinsics.areEqual(this.route, route)) {
            return true;
        }
        NavDestination.DeepLinkMatch deepLinkMatch = matchingDeepLink = this.matchRoute$navigation_common(route);
        if (!Intrinsics.areEqual(this.destination, deepLinkMatch != null ? deepLinkMatch.getDestination() : null)) {
            return false;
        }
        return matchingDeepLink.hasMatchingArgs(arguments);
    }

    public final void addArgument$navigation_common(@NotNull String argumentName, @NotNull NavArgument argument) {
        Intrinsics.checkNotNullParameter(argumentName, "argumentName");
        Intrinsics.checkNotNullParameter(argument, "argument");
        this.arguments.put(argumentName, argument);
    }

    public final void removeArgument$navigation_common(@NotNull String argumentName) {
        Intrinsics.checkNotNullParameter(argumentName, "argumentName");
        this.arguments.remove(argumentName);
    }

    @Nullable
    public final SavedState addInDefaultArgs$navigation_common(@Nullable SavedState args) {
        SavedState savedState2;
        if (args == null && this.arguments.isEmpty()) {
            return null;
        }
        Map initialState$iv = MapsKt.emptyMap();
        boolean $i$f$savedState = false;
        Map<String, Object> copiedState$iv = MapsKt.toMutableMap(initialState$iv);
        SavedState $this$savedState_u24lambda_u240$iv = savedState2 = new SavedState(copiedState$iv);
        boolean bl = false;
        SavedState $this$write$iv$iv = $this$savedState_u24lambda_u240$iv;
        boolean $i$f$write = false;
        SavedState savedState3 = SavedStateWriter.constructor-impl($this$write$iv$iv);
        boolean bl2 = false;
        SavedState savedState4 = savedState3;
        SavedState defaultArgs = savedState2;
        for (Map.Entry entry : this.arguments.entrySet()) {
            String key = (String)entry.getKey();
            NavArgument value = (NavArgument)entry.getValue();
            value.putDefaultValue(key, defaultArgs);
        }
        if (args != null) {
            SavedState $this$write$iv = defaultArgs;
            boolean bl3 = false;
            SavedState $this$addInDefaultArgs_u24lambda_u248 = SavedStateWriter.constructor-impl($this$write$iv);
            boolean bl32 = false;
            SavedStateWriter.putAll-impl($this$addInDefaultArgs_u24lambda_u248, args);
            for (Map.Entry<String, NavArgument> entry : this.arguments.entrySet()) {
                String key = entry.getKey();
                NavArgument value = entry.getValue();
                if (value.isDefaultValueUnknown$navigation_common() || value.verify(key, defaultArgs)) continue;
                boolean bl4 = false;
                String string2 = "Wrong argument type for '" + key + "' in argument savedState. " + value.getType().getName() + " expected.";
                throw new IllegalArgumentException(string2.toString());
            }
        }
        return defaultArgs;
    }

    private static final boolean _set_route_$lambda$1(NavDeepLink $tempDeepLink, String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return !$tempDeepLink.getArgumentsNames$navigation_common().contains(key);
    }

    private static final NavDeepLink _set_route_$lambda$3(String $tempRoute) {
        return new NavDeepLink.Builder().setUriPattern($tempRoute).build();
    }

    private static final boolean addDeepLink$lambda$4(NavDeepLink $navDeepLink, String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return !$navDeepLink.getArgumentsNames$navigation_common().contains(key);
    }

    private static final boolean hasRequiredArguments$lambda$7(SavedState $matchingArgs, String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        SavedState $this$read$iv = $matchingArgs;
        boolean $i$f$read = false;
        SavedState $this$hasRequiredArguments_u24lambda_u247_u24lambda_u246 = SavedStateReader.constructor-impl($this$read$iv);
        boolean bl = false;
        return !SavedStateReader.contains-impl($this$hasRequiredArguments_u24lambda_u247_u24lambda_u246, key);
    }
}

