/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.webauthn4j.converter.AttestedCredentialDataConverter;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.jackson.deserializer.cbor.AuthenticationExtensionsAuthenticatorOutputsEnvelope;
import com.webauthn4j.converter.jackson.deserializer.cbor.COSEKeyEnvelope;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticatorDataConverter {
    private static final int RPID_HASH_LENGTH = 32;
    private static final int FLAGS_LENGTH = 1;
    private static final int COUNTER_LENGTH = 4;
    private static final int AAGUID_LENGTH = 16;
    private static final int L_LENGTH = 2;
    private static final int COUNTER_INDEX = 33;
    private static final int ATTESTED_CREDENTIAL_DATA_INDEX = 37;
    private static final int L_INDEX = 53;
    private static final int CREDENTIAL_ID_INDEX = 55;
    private final CborConverter cborConverter;
    private final AttestedCredentialDataConverter attestedCredentialDataConverter;

    public AuthenticatorDataConverter(@NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull(objectConverter, "objectConverter must not be null");
        this.cborConverter = objectConverter.getCborConverter();
        this.attestedCredentialDataConverter = new AttestedCredentialDataConverter(objectConverter);
    }

    @NotNull
    public <T extends ExtensionAuthenticatorOutput> byte[] convert(@NotNull AuthenticatorData<T> source2) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] rpIdHash = source2.getRpIdHash();
            byteArrayOutputStream.write(rpIdHash);
            byteArrayOutputStream.write(new byte[]{source2.getFlags()});
            byteArrayOutputStream.write(UnsignedNumberUtil.toBytes(source2.getSignCount()));
            if (source2.getAttestedCredentialData() != null) {
                byteArrayOutputStream.write(this.attestedCredentialDataConverter.convert(source2.getAttestedCredentialData()));
            }
            byteArrayOutputStream.write(this.convert(source2.getExtensions()));
            return byteArrayOutputStream.toByteArray();
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public <T extends ExtensionAuthenticatorOutput> AuthenticatorData<T> convert(@NotNull byte[] source2) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(source2);
            byte[] rpIdHash = new byte[32];
            byteBuffer.get(rpIdHash, 0, 32);
            byte flags = byteBuffer.get();
            long counter = UnsignedNumberUtil.getUnsignedInt(byteBuffer);
            AttestedCredentialData attestedCredentialData = AuthenticatorData.checkFlagAT(flags) ? (byteBuffer.hasRemaining() ? this.attestedCredentialDataConverter.convert(byteBuffer) : null) : null;
            AuthenticationExtensionsAuthenticatorOutputs<T> extensions = AuthenticatorData.checkFlagED(flags) ? this.convertToExtensions(byteBuffer) : new AuthenticationExtensionsAuthenticatorOutputs();
            if (byteBuffer.hasRemaining()) {
                throw new DataConversionException("provided data does not have proper byte layout");
            }
            return new AuthenticatorData<T>(rpIdHash, flags, counter, attestedCredentialData, extensions);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
        catch (BufferUnderflowException e) {
            throw new DataConversionException("provided data does not have proper byte layout", e);
        }
    }

    @NotNull
    public byte[] extractAttestedCredentialData(@NotNull byte[] authenticatorData) {
        byte[] lengthBytes = Arrays.copyOfRange(authenticatorData, 53, 55);
        int credentialIdLength = UnsignedNumberUtil.getUnsignedShort(lengthBytes);
        int credentialPublicKeyIndex = 55 + credentialIdLength;
        byte[] attestedCredentialDataBytes = Arrays.copyOfRange(authenticatorData, credentialPublicKeyIndex, authenticatorData.length);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(attestedCredentialDataBytes);
        COSEKeyEnvelope coseKeyEnvelope = this.attestedCredentialDataConverter.convertToCredentialPublicKey(byteArrayInputStream);
        int credentialPublicKeyLength = coseKeyEnvelope.getLength();
        int attestedCredentialDataLength = 18 + credentialIdLength + credentialPublicKeyLength;
        return Arrays.copyOfRange(authenticatorData, 37, 37 + attestedCredentialDataLength);
    }

    public long extractSignCount(@NotNull byte[] authenticatorData) {
        byte[] counterBytes = Arrays.copyOfRange(authenticatorData, 33, 37);
        return UnsignedNumberUtil.getUnsignedInt(counterBytes);
    }

    @NotNull
    <T extends ExtensionAuthenticatorOutput> byte[] convert(@Nullable AuthenticationExtensionsAuthenticatorOutputs<T> extensions) {
        if (extensions == null || extensions.getKeys().isEmpty()) {
            return new byte[0];
        }
        return this.cborConverter.writeValueAsBytes(extensions);
    }

    @Nullable
    <T extends ExtensionAuthenticatorOutput> AuthenticationExtensionsAuthenticatorOutputs<T> convertToExtensions(@NotNull ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() == 0) {
            return new AuthenticationExtensionsAuthenticatorOutputs();
        }
        byte[] remaining = new byte[byteBuffer.remaining()];
        byteBuffer.get(remaining);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(remaining);
        AuthenticationExtensionsAuthenticatorOutputsEnvelope envelope = (AuthenticationExtensionsAuthenticatorOutputsEnvelope)this.cborConverter.readValue((InputStream)byteArrayInputStream, new TypeReference<AuthenticationExtensionsAuthenticatorOutputsEnvelope<T>>(){});
        if (envelope == null) {
            return null;
        }
        int leftoverLength = remaining.length - envelope.getLength();
        ((Buffer)byteBuffer).position(byteBuffer.position() - leftoverLength);
        return envelope.getAuthenticationExtensionsAuthenticatorOutputs();
    }
}

