/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1.type;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.apache.kerby.asn1.Asn1Binder;
import org.apache.kerby.asn1.UniversalTag;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.type.Asn1Collection;
import org.apache.kerby.asn1.type.Asn1Type;

public abstract class Asn1CollectionOf<T extends Asn1Type>
extends Asn1Collection {
    public Asn1CollectionOf(UniversalTag universalTag) {
        super(universalTag);
    }

    @Override
    protected void decodeElements() throws IOException {
        for (Asn1ParseResult parsingItem : this.getContainer().getChildren()) {
            if (parsingItem.isEOC()) continue;
            T tmpValue = this.createElement();
            Asn1Binder.bind(parsingItem, tmpValue);
            this.addItem((Asn1Type)tmpValue);
        }
    }

    public List<T> getElements() {
        return (List)this.getValue();
    }

    public void setElements(List<T> elements) {
        super.clear();
        for (Asn1Type ele : elements) {
            this.addElement(ele);
        }
    }

    public void addElements(T ... elements) {
        for (T ele : elements) {
            this.addElement(ele);
        }
    }

    public void addElement(T element) {
        super.addItem((Asn1Type)element);
    }

    private Class<T> getElementType() {
        Class elementType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return elementType;
    }

    protected T createElement() throws IOException {
        Class<T> eleType = this.getElementType();
        try {
            Asn1Type result2 = (Asn1Type)eleType.newInstance();
            return (T)result2;
        }
        catch (Exception e) {
            throw new IOException("Failed to create element type, no default constructor? " + eleType.getName(), e);
        }
    }
}

