/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.attestation.statement.androidkey;

import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.statement.AndroidKeyAttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.AttestationType;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.SignatureUtil;
import com.webauthn4j.verifier.CoreRegistrationObject;
import com.webauthn4j.verifier.attestation.statement.AbstractStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.androidkey.KeyDescriptionVerifier;
import com.webauthn4j.verifier.exception.BadAttestationStatementException;
import com.webauthn4j.verifier.exception.BadSignatureException;
import com.webauthn4j.verifier.exception.PublicKeyMismatchException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;

public class AndroidKeyAttestationStatementVerifier
extends AbstractStatementVerifier<AndroidKeyAttestationStatement> {
    private final KeyDescriptionVerifier keyDescriptionVerifier = new KeyDescriptionVerifier();
    private boolean teeEnforcedOnly = true;

    @Override
    @NotNull
    public AttestationType verify(@NotNull CoreRegistrationObject registrationObject) {
        AssertUtil.notNull(registrationObject, "registrationObject must not be null");
        if (!this.supports(registrationObject)) {
            throw new IllegalArgumentException(String.format("Specified format '%s' is not supported by %s.", registrationObject.getAttestationObject().getFormat(), this.getClass().getName()));
        }
        AndroidKeyAttestationStatement attestationStatement = (AndroidKeyAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        this.verifyAttestationStatementNotNull(attestationStatement);
        if (attestationStatement.getX5c().isEmpty()) {
            throw new BadAttestationStatementException("No attestation certificate is found in android key attestation statement.");
        }
        this.verifySignature(registrationObject);
        PublicKey publicKeyInEndEntityCert = attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate().getPublicKey();
        AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData = registrationObject.getAttestationObject().getAuthenticatorData();
        PublicKey publicKeyInCredentialData = authenticatorData.getAttestedCredentialData().getCOSEKey().getPublicKey();
        if (!publicKeyInEndEntityCert.equals(publicKeyInCredentialData)) {
            throw new PublicKeyMismatchException("The public key in the first certificate in x5c doesn't matches the credentialPublicKey in the attestedCredentialData in authenticatorData.");
        }
        byte[] clientDataHash = registrationObject.getClientDataHash();
        this.keyDescriptionVerifier.verify(attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate(), clientDataHash, this.teeEnforcedOnly);
        return AttestationType.BASIC;
    }

    void verifyAttestationStatementNotNull(AndroidKeyAttestationStatement attestationStatement) {
        if (attestationStatement == null) {
            throw new BadAttestationStatementException("attestation statement is not found.");
        }
    }

    private void verifySignature(@NotNull CoreRegistrationObject registrationObject) {
        AndroidKeyAttestationStatement attestationStatement = (AndroidKeyAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        byte[] signedData = this.getSignedData(registrationObject);
        byte[] signature = attestationStatement.getSig();
        PublicKey publicKey = this.getPublicKey(attestationStatement);
        try {
            String jcaName = this.getJcaName(attestationStatement.getAlg());
            Signature verifier2 = SignatureUtil.createSignature(jcaName);
            verifier2.initVerify(publicKey);
            verifier2.update(signedData);
            if (verifier2.verify(signature)) {
                return;
            }
            throw new BadSignatureException("`sig` in attestation statement is not valid signature over the concatenation of authenticatorData and clientDataHash.");
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new BadSignatureException("`sig` in attestation statement is not valid signature over the concatenation of authenticatorData and clientDataHash.", e);
        }
    }

    @NotNull
    private byte[] getSignedData(@NotNull CoreRegistrationObject registrationObject) {
        byte[] authenticatorData = registrationObject.getAuthenticatorDataBytes();
        byte[] clientDataHash = registrationObject.getClientDataHash();
        return ByteBuffer.allocate(authenticatorData.length + clientDataHash.length).put(authenticatorData).put(clientDataHash).array();
    }

    @NotNull
    private PublicKey getPublicKey(@NotNull AndroidKeyAttestationStatement attestationStatement) {
        AttestationCertificatePath x5c = attestationStatement.getX5c();
        X509Certificate cert = x5c.getEndEntityAttestationCertificate().getCertificate();
        return cert.getPublicKey();
    }

    public boolean isTeeEnforcedOnly() {
        return this.teeEnforcedOnly;
    }

    public void setTeeEnforcedOnly(boolean teeEnforcedOnly) {
        this.teeEnforcedOnly = teeEnforcedOnly;
    }
}

