/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.serialization.node;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.fasterxml.jackson.databind.util.RawValue;
import com.networknt.schema.serialization.node.JsonLocationAwareArrayNode;
import com.networknt.schema.serialization.node.JsonLocationAwareBigIntegerNode;
import com.networknt.schema.serialization.node.JsonLocationAwareBinaryNode;
import com.networknt.schema.serialization.node.JsonLocationAwareBooleanNode;
import com.networknt.schema.serialization.node.JsonLocationAwareDecimalNode;
import com.networknt.schema.serialization.node.JsonLocationAwareDoubleNode;
import com.networknt.schema.serialization.node.JsonLocationAwareFloatNode;
import com.networknt.schema.serialization.node.JsonLocationAwareIntNode;
import com.networknt.schema.serialization.node.JsonLocationAwareLongNode;
import com.networknt.schema.serialization.node.JsonLocationAwareNullNode;
import com.networknt.schema.serialization.node.JsonLocationAwareObjectNode;
import com.networknt.schema.serialization.node.JsonLocationAwarePOJONode;
import com.networknt.schema.serialization.node.JsonLocationAwareShortNode;
import com.networknt.schema.serialization.node.JsonLocationAwareTextNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public class LocationJsonNodeFactory
extends JsonNodeFactory {
    private static final long serialVersionUID = 1L;
    private final JsonParser jsonParser;

    public LocationJsonNodeFactory(JsonParser jsonParser) {
        this.jsonParser = jsonParser;
    }

    public BooleanNode booleanNode(boolean v) {
        return new JsonLocationAwareBooleanNode(v, this.jsonParser.currentTokenLocation());
    }

    public NullNode nullNode() {
        return new JsonLocationAwareNullNode(this.jsonParser.currentTokenLocation());
    }

    public JsonNode missingNode() {
        return super.missingNode();
    }

    public NumericNode numberNode(byte v) {
        return new JsonLocationAwareIntNode(v, this.jsonParser.currentTokenLocation());
    }

    public ValueNode numberNode(Byte v) {
        return v == null ? this.nullNode() : this.numberNode(v.intValue());
    }

    public NumericNode numberNode(short v) {
        return new JsonLocationAwareShortNode(v, this.jsonParser.currentTokenLocation());
    }

    public ValueNode numberNode(Short value) {
        return value == null ? this.nullNode() : this.numberNode((short)value);
    }

    public NumericNode numberNode(int v) {
        return new JsonLocationAwareIntNode(v, this.jsonParser.currentTokenLocation());
    }

    public ValueNode numberNode(Integer v) {
        return v == null ? this.nullNode() : this.numberNode((int)v);
    }

    public NumericNode numberNode(long v) {
        return new JsonLocationAwareLongNode(v, this.jsonParser.currentTokenLocation());
    }

    public ValueNode numberNode(Long v) {
        return v == null ? this.nullNode() : this.numberNode((long)v);
    }

    public ValueNode numberNode(BigInteger v) {
        return v == null ? this.nullNode() : new JsonLocationAwareBigIntegerNode(v, this.jsonParser.currentTokenLocation());
    }

    public NumericNode numberNode(float v) {
        return new JsonLocationAwareFloatNode(v, this.jsonParser.currentTokenLocation());
    }

    public ValueNode numberNode(Float v) {
        return v == null ? this.nullNode() : this.numberNode(v.floatValue());
    }

    public NumericNode numberNode(double v) {
        return new JsonLocationAwareDoubleNode(v, this.jsonParser.currentTokenLocation());
    }

    public ValueNode numberNode(Double v) {
        return v == null ? this.nullNode() : this.numberNode((double)v);
    }

    public ValueNode numberNode(BigDecimal v) {
        return v == null ? this.nullNode() : new JsonLocationAwareDecimalNode(v, this.jsonParser.currentTokenLocation());
    }

    public TextNode textNode(String text) {
        return new JsonLocationAwareTextNode(text, this.jsonParser.currentTokenLocation());
    }

    public BinaryNode binaryNode(byte[] data) {
        return new JsonLocationAwareBinaryNode(data, this.jsonParser.currentTokenLocation());
    }

    public BinaryNode binaryNode(byte[] data, int offset, int length) {
        return new JsonLocationAwareBinaryNode(data, offset, length, this.jsonParser.currentTokenLocation());
    }

    public ArrayNode arrayNode() {
        return new JsonLocationAwareArrayNode(this, this.jsonParser.currentTokenLocation());
    }

    public ArrayNode arrayNode(int capacity) {
        return new JsonLocationAwareArrayNode((JsonNodeFactory)this, capacity, this.jsonParser.currentTokenLocation());
    }

    public ObjectNode objectNode() {
        return new JsonLocationAwareObjectNode(this, this.jsonParser.currentTokenLocation());
    }

    public ValueNode pojoNode(Object pojo) {
        return new JsonLocationAwarePOJONode(pojo, this.jsonParser.currentTokenLocation());
    }

    public ValueNode rawValueNode(RawValue value) {
        return new JsonLocationAwarePOJONode(value, this.jsonParser.currentTokenLocation());
    }
}

