/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import java.lang.ref.Reference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.JvmContextHandler;
import org.jetbrains.skiko.redrawer.Direct3DRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\u0019\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0082 J\b\u0010\u0017\u001a\u00020\u0012H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/jetbrains/skiko/context/Direct3DContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "bufferCount", "", "currentHeight", "currentWidth", "directXRedrawer", "Lorg/jetbrains/skiko/redrawer/Direct3DRedrawer;", "getDirectXRedrawer", "()Lorg/jetbrains/skiko/redrawer/Direct3DRedrawer;", "surfaces", "", "Lorg/jetbrains/skia/Surface;", "[Lorg/jetbrains/skia/Surface;", "disposeCanvas", "", "flush", "context", "", "surface", "initCanvas", "initContext", "", "isSizeChanged", "width", "height", "isSurfacesNull", "rendererInfo", "", "skiko"})
@SourceDebugExtension(value={"SMAP\nDirect3DContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Direct3DContextHandler.kt\norg/jetbrains/skiko/context/Direct3DContextHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,108:1\n12271#2,2:109\n124#3,4:111\n159#3,4:115\n*S KotlinDebug\n*F\n+ 1 Direct3DContextHandler.kt\norg/jetbrains/skiko/context/Direct3DContextHandler\n*L\n14#1:109,2\n24#1:111,4\n28#1:115,4\n*E\n"})
public final class Direct3DContextHandler
extends JvmContextHandler {
    private final int bufferCount;
    @NotNull
    private Surface[] surfaces;
    private int currentWidth;
    private int currentHeight;

    public Direct3DContextHandler(@NotNull SkiaLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super(layer);
        this.bufferCount = 2;
        this.surfaces = new Surface[this.bufferCount];
    }

    private final boolean isSurfacesNull() {
        boolean bl;
        block1: {
            Surface[] $this$all$iv = this.surfaces;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                Surface element$iv;
                Surface it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (it == null) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private final Direct3DRedrawer getDirectXRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (Direct3DRedrawer)redrawer;
    }

    @Override
    protected boolean initContext() {
        try {
            if (this.getContext() == null) {
                this.setContext(this.getDirectXRedrawer().makeContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true")) {
                    Logger this_$iv = Logger.INSTANCE;
                    boolean $i$f$info = false;
                    if (this_$iv.getLoggerImpl().isInfoEnabled()) {
                        SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                        boolean bl = false;
                        skikoLoggerInterface.info("Renderer info:\n " + this.rendererInfo());
                    }
                }
            }
        }
        catch (Exception e) {
            Logger this_$iv = Logger.INSTANCE;
            boolean $i$f$warn = false;
            if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                Throwable throwable = e;
                SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                boolean bl = false;
                String string = "Failed to create Skia Direct3D context!";
                skikoLoggerInterface.warn(throwable, string);
            }
            return false;
        }
        return true;
    }

    private final boolean isSizeChanged(int width2, int height2) {
        if (width2 != this.currentWidth || height2 != this.currentHeight) {
            this.currentWidth = width2;
            this.currentHeight = height2;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initCanvas() {
        int height2;
        DirectContext directContext = this.getContext();
        if (directContext == null) {
            return;
        }
        DirectContext context = directContext;
        float scale = this.getLayer().getContentScale();
        int width2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)1);
        if (this.isSizeChanged(width2, height2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)1)) || this.isSurfacesNull()) {
            this.disposeCanvas();
            context.flush();
            boolean justInitialized = this.getDirectXRedrawer().changeSize(width2, height2);
            try {
                SurfaceProps surfaceProps = new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null);
                int n = this.bufferCount;
                for (int bufferIndex = 0; bufferIndex < n; ++bufferIndex) {
                    this.surfaces[bufferIndex] = this.getDirectXRedrawer().makeSurface(NativeKt.getPtr(context), width2, height2, surfaceProps, bufferIndex);
                }
            }
            finally {
                Reference.reachabilityFence(context);
            }
            if (justInitialized) {
                this.getDirectXRedrawer().initFence();
            }
        }
        this.setSurface(this.surfaces[this.getDirectXRedrawer().getBufferIndex()]);
        Surface surface = this.getSurface();
        Intrinsics.checkNotNull((Object)surface);
        this.setCanvas(surface.getCanvas());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flush() {
        DirectContext directContext = this.getContext();
        if (directContext == null) {
            return;
        }
        DirectContext context = directContext;
        Surface surface = this.getSurface();
        if (surface == null) {
            return;
        }
        Surface surface2 = surface;
        try {
            this.flush(NativeKt.getPtr(context), NativeKt.getPtr(surface2));
        }
        finally {
            Reference.reachabilityFence(context);
            Reference.reachabilityFence(surface2);
        }
    }

    @Override
    protected void disposeCanvas() {
        int n = this.bufferCount;
        for (int bufferIndex = 0; bufferIndex < n; ++bufferIndex) {
            Surface surface = this.surfaces[bufferIndex];
            if (surface == null) continue;
            surface.close();
        }
    }

    @Override
    @NotNull
    public String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.getDirectXRedrawer().getAdapterName() + "\nTotal VRAM: " + this.getDirectXRedrawer().getAdapterMemorySize() / (long)1024 / (long)1024 + " MB\n";
    }

    private final native void flush(long var1, long var3);
}

