/*
 * Decompiled with CFR 0.152.
 */
package world.respect.datalayer.db.school.daos;

import androidx.paging.PagingSource;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomRawQuery;
import androidx.room.coroutines.FlowUtil;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.time.Instant;
import kotlinx.coroutines.flow.Flow;
import kotlinx.datetime.LocalDate;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.db.school.SchoolTypeConverters;
import world.respect.datalayer.db.school.daos.EnrollmentEntityDao;
import world.respect.datalayer.db.school.daos.EnrollmentEntityDao_Impl;
import world.respect.datalayer.db.school.entities.EnrollmentEntity;
import world.respect.datalayer.db.shared.SharedConverters;
import world.respect.datalayer.school.model.EnrollmentRoleEnum;
import world.respect.datalayer.school.model.StatusEnum;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J<\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\"\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u00102\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0096@\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lworld/respect/datalayer/db/school/daos/EnrollmentEntityDao_Impl;", "Lworld/respect/datalayer/db/school/daos/EnrollmentEntityDao;", "__db", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "__insertAdapterOfEnrollmentEntity", "Landroidx/room/EntityInsertAdapter;", "Lworld/respect/datalayer/db/school/entities/EnrollmentEntity;", "__schoolTypeConverters", "Lworld/respect/datalayer/db/school/SchoolTypeConverters;", "__sharedConverters", "Lworld/respect/datalayer/db/shared/SharedConverters;", "upsert", "", "enrolments", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByGuid", "uidNum", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByGuidAsFlow", "Lkotlinx/coroutines/flow/Flow;", "listAsPagingSource", "Landroidx/paging/PagingSource;", "", "since", "classUidNum", "classUidRoleFlag", "personUidNum", "getLastModifiedByUidNum", "findByUidNumList", "uidNums", "deleteEnrollment", "uid", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "respect-datalayer-db_release"})
public final class EnrollmentEntityDao_Impl
implements EnrollmentEntityDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<EnrollmentEntity> __insertAdapterOfEnrollmentEntity;
    @NotNull
    private final SchoolTypeConverters __schoolTypeConverters;
    @NotNull
    private final SharedConverters __sharedConverters;

    public EnrollmentEntityDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__schoolTypeConverters = new SchoolTypeConverters();
        this.__sharedConverters = new SharedConverters();
        this.__db = __db;
        this.__insertAdapterOfEnrollmentEntity = (EntityInsertAdapter)new EntityInsertAdapter<EnrollmentEntity>(){

            protected String createQuery() {
                return "INSERT OR REPLACE INTO `EnrollmentEntity` (`eUid`,`eUidNum`,`eStatus`,`eLastModified`,`eStored`,`eMetadata`,`eClassUid`,`eClassUidNum`,`ePersonUid`,`ePersonUidNum`,`eRole`,`eBeginDate`,`eEndDate`,`eInviteCode`,`eApprovedByPersonUidNum`,`eApprovedByPersonUid`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, EnrollmentEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindText(1, entity.getEUid());
                statement.bindLong(2, entity.getEUidNum());
                int _tmp = __schoolTypeConverters.fromStatusEnum(entity.getEStatus());
                statement.bindLong(3, (long)_tmp);
                Long _tmp_1 = __sharedConverters.fromInstant(entity.getELastModified());
                if (_tmp_1 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindLong(4, _tmp_1.longValue());
                }
                Long _tmp_2 = __sharedConverters.fromInstant(entity.getEStored());
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindLong(5, _tmp_2.longValue());
                }
                JsonObject _tmpEMetadata = entity.getEMetadata();
                String _tmp_3 = __schoolTypeConverters.fromJsonObject(_tmpEMetadata);
                if (_tmp_3 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_3);
                }
                statement.bindText(7, entity.getEClassUid());
                statement.bindLong(8, entity.getEClassUidNum());
                statement.bindText(9, entity.getEPersonUid());
                statement.bindLong(10, entity.getEPersonUidNum());
                int _tmp_4 = __schoolTypeConverters.fromEnrollmentRoleEnum(entity.getERole());
                statement.bindLong(11, (long)_tmp_4);
                LocalDate _tmpEBeginDate = entity.getEBeginDate();
                Long _tmp_5 = __schoolTypeConverters.fromLocalDate(_tmpEBeginDate);
                if (_tmp_5 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindLong(12, _tmp_5.longValue());
                }
                LocalDate _tmpEEndDate = entity.getEEndDate();
                Long _tmp_6 = __schoolTypeConverters.fromLocalDate(_tmpEEndDate);
                if (_tmp_6 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindLong(13, _tmp_6.longValue());
                }
                String _tmpEInviteCode = entity.getEInviteCode();
                if (_tmpEInviteCode == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, _tmpEInviteCode);
                }
                statement.bindLong(15, entity.getEApprovedByPersonUidNum());
                String _tmpEApprovedByPersonUid = entity.getEApprovedByPersonUid();
                if (_tmpEApprovedByPersonUid == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, _tmpEApprovedByPersonUid);
                }
            }
        };
    }

    @Override
    @Nullable
    public Object upsert(@NotNull List<EnrollmentEntity> enrolments, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> EnrollmentEntityDao_Impl.upsert$lambda$0(this, enrolments, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object findByGuid(long uidNum, @NotNull Continuation<? super EnrollmentEntity> $completion) {
        String _sql = "\n        SELECT EnrollmentEntity.*\n          FROM EnrollmentEntity\n         WHERE EnrollmentEntity.eUidNum = ?\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> EnrollmentEntityDao_Impl.findByGuid$lambda$0(_sql, uidNum, this, arg_0), $completion);
    }

    @Override
    @NotNull
    public Flow<EnrollmentEntity> findByGuidAsFlow(long uidNum) {
        String _sql = "\n        SELECT EnrollmentEntity.*\n          FROM EnrollmentEntity\n         WHERE EnrollmentEntity.eUidNum = ?\n    ";
        String[] stringArray = new String[]{"EnrollmentEntity"};
        return FlowUtil.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, arg_0 -> EnrollmentEntityDao_Impl.findByGuidAsFlow$lambda$0(_sql, uidNum, this, arg_0));
    }

    @Override
    @NotNull
    public PagingSource<Integer, EnrollmentEntity> listAsPagingSource(long since, long uidNum, long classUidNum, int classUidRoleFlag, long personUidNum) {
        String _sql = "\n        SELECT EnrollmentEntity.*\n          FROM EnrollmentEntity\n         WHERE (? <= 0 OR EnrollmentEntity.eStored > ?)\n           AND (? = 0 OR EnrollmentEntity.eUidNum = ?)\n           AND (? = 0 OR EnrollmentEntity.eClassUidNum = ?)\n           AND (? = 0 OR EnrollmentEntity.eRole = ?)\n           AND (? = 0 OR EnrollmentEntity.ePersonUidNum = ?)\n    ";
        RoomRawQuery _rawQuery = new RoomRawQuery(_sql, arg_0 -> EnrollmentEntityDao_Impl.listAsPagingSource$lambda$0(since, uidNum, classUidNum, classUidRoleFlag, personUidNum, arg_0));
        RoomDatabase roomDatabase = this.__db;
        String[] stringArray = new String[]{"EnrollmentEntity"};
        String[] stringArray2 = stringArray;
        return (PagingSource)new LimitOffsetPagingSource<EnrollmentEntity>(_rawQuery, this, roomDatabase, stringArray2){
            final /* synthetic */ EnrollmentEntityDao_Impl this$0;
            {
                this.this$0 = $receiver;
                super($_rawQuery, $super_call_param$1, $super_call_param$2);
            }

            protected Object convertRows(RoomRawQuery limitOffsetQuery, int itemCount, Continuation<? super List<EnrollmentEntity>> $completion) {
                return DBUtil.performSuspending((RoomDatabase)EnrollmentEntityDao_Impl.access$get__db$p(this.this$0), (boolean)true, (boolean)false, arg_0 -> listAsPagingSource.1.convertRows$lambda$0(limitOffsetQuery, this.this$0, arg_0), $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final List convertRows$lambda$0(RoomRawQuery $limitOffsetQuery, EnrollmentEntityDao_Impl this$0, SQLiteConnection _connection) {
                List list2;
                Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
                SQLiteStatement _stmt = _connection.prepare($limitOffsetQuery.getSql());
                $limitOffsetQuery.getBindingFunction().invoke((Object)_stmt);
                try {
                    int _columnIndexOfEUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eUid");
                    int _columnIndexOfEUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eUidNum");
                    int _columnIndexOfEStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eStatus");
                    int _columnIndexOfELastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eLastModified");
                    int _columnIndexOfEStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eStored");
                    int _columnIndexOfEMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eMetadata");
                    int _columnIndexOfEClassUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eClassUid");
                    int _columnIndexOfEClassUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eClassUidNum");
                    int _columnIndexOfEPersonUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"ePersonUid");
                    int _columnIndexOfEPersonUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"ePersonUidNum");
                    int _columnIndexOfERole = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eRole");
                    int _columnIndexOfEBeginDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eBeginDate");
                    int _columnIndexOfEEndDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eEndDate");
                    int _columnIndexOfEInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eInviteCode");
                    int _columnIndexOfEApprovedByPersonUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eApprovedByPersonUidNum");
                    int _columnIndexOfEApprovedByPersonUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eApprovedByPersonUid");
                    List _result = new ArrayList<E>();
                    while (_stmt.step()) {
                        EnrollmentEntity _item = null;
                        String _tmpEUid = null;
                        _tmpEUid = _stmt.getText(_columnIndexOfEUid);
                        long _tmpEUidNum = 0L;
                        _tmpEUidNum = _stmt.getLong(_columnIndexOfEUidNum);
                        StatusEnum _tmpEStatus = null;
                        int _tmp = 0;
                        _tmp = (int)_stmt.getLong(_columnIndexOfEStatus);
                        _tmpEStatus = EnrollmentEntityDao_Impl.access$get__schoolTypeConverters$p(this$0).toStatusEnum(_tmp);
                        Instant _tmpELastModified = null;
                        Long _tmp_1 = null;
                        _tmp_1 = _stmt.isNull(_columnIndexOfELastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfELastModified));
                        Instant _tmp_2 = EnrollmentEntityDao_Impl.access$get__sharedConverters$p(this$0).toInstant(_tmp_1);
                        if (_tmp_2 == null) {
                            throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                        }
                        _tmpELastModified = _tmp_2;
                        Instant _tmpEStored = null;
                        Long _tmp_3 = null;
                        _tmp_3 = _stmt.isNull(_columnIndexOfEStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfEStored));
                        Instant _tmp_4 = EnrollmentEntityDao_Impl.access$get__sharedConverters$p(this$0).toInstant(_tmp_3);
                        if (_tmp_4 == null) {
                            throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                        }
                        _tmpEStored = _tmp_4;
                        JsonObject _tmpEMetadata = null;
                        String _tmp_5 = null;
                        _tmp_5 = _stmt.isNull(_columnIndexOfEMetadata) ? null : _stmt.getText(_columnIndexOfEMetadata);
                        _tmpEMetadata = EnrollmentEntityDao_Impl.access$get__schoolTypeConverters$p(this$0).toJsonObject(_tmp_5);
                        String _tmpEClassUid = null;
                        _tmpEClassUid = _stmt.getText(_columnIndexOfEClassUid);
                        long _tmpEClassUidNum = 0L;
                        _tmpEClassUidNum = _stmt.getLong(_columnIndexOfEClassUidNum);
                        String _tmpEPersonUid = null;
                        _tmpEPersonUid = _stmt.getText(_columnIndexOfEPersonUid);
                        long _tmpEPersonUidNum = 0L;
                        _tmpEPersonUidNum = _stmt.getLong(_columnIndexOfEPersonUidNum);
                        EnrollmentRoleEnum _tmpERole = null;
                        int _tmp_6 = 0;
                        _tmp_6 = (int)_stmt.getLong(_columnIndexOfERole);
                        _tmpERole = EnrollmentEntityDao_Impl.access$get__schoolTypeConverters$p(this$0).toEnrollmentRoleEnum(_tmp_6);
                        LocalDate _tmpEBeginDate = null;
                        Long _tmp_7 = null;
                        _tmp_7 = _stmt.isNull(_columnIndexOfEBeginDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfEBeginDate));
                        _tmpEBeginDate = EnrollmentEntityDao_Impl.access$get__schoolTypeConverters$p(this$0).toLocalDate(_tmp_7);
                        LocalDate _tmpEEndDate = null;
                        Long _tmp_8 = null;
                        _tmp_8 = _stmt.isNull(_columnIndexOfEEndDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfEEndDate));
                        _tmpEEndDate = EnrollmentEntityDao_Impl.access$get__schoolTypeConverters$p(this$0).toLocalDate(_tmp_8);
                        String _tmpEInviteCode = null;
                        _tmpEInviteCode = _stmt.isNull(_columnIndexOfEInviteCode) ? null : _stmt.getText(_columnIndexOfEInviteCode);
                        long _tmpEApprovedByPersonUidNum = 0L;
                        _tmpEApprovedByPersonUidNum = _stmt.getLong(_columnIndexOfEApprovedByPersonUidNum);
                        String _tmpEApprovedByPersonUid = null;
                        _tmpEApprovedByPersonUid = _stmt.isNull(_columnIndexOfEApprovedByPersonUid) ? null : _stmt.getText(_columnIndexOfEApprovedByPersonUid);
                        _item = new EnrollmentEntity(_tmpEUid, _tmpEUidNum, _tmpEStatus, _tmpELastModified, _tmpEStored, _tmpEMetadata, _tmpEClassUid, _tmpEClassUidNum, _tmpEPersonUid, _tmpEPersonUidNum, _tmpERole, _tmpEBeginDate, _tmpEEndDate, _tmpEInviteCode, _tmpEApprovedByPersonUidNum, _tmpEApprovedByPersonUid);
                        _result.add(_item);
                    }
                    list2 = _result;
                }
                finally {
                    _stmt.close();
                }
                return list2;
            }
        };
    }

    @Override
    @Nullable
    public Object getLastModifiedByUidNum(long uidNum, @NotNull Continuation<? super Long> $completion) {
        String _sql = "\n        SELECT EnrollmentEntity.eLastModified\n          FROM EnrollmentEntity\n         WHERE EnrollmentEntity.eUidNum = ? \n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> EnrollmentEntityDao_Impl.getLastModifiedByUidNum$lambda$0(_sql, uidNum, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findByUidNumList(@NotNull List<Long> uidNums, @NotNull Continuation<? super List<EnrollmentEntity>> $completion) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT EnrollmentEntity.*");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM EnrollmentEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE EnrollmentEntity.eUidNum IN (");
        int _inputSize = uidNums.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String string = _stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String _sql = string;
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> EnrollmentEntityDao_Impl.findByUidNumList$lambda$0(_sql, uidNums, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object deleteEnrollment(@NotNull String uid, @NotNull Continuation<? super Unit> $completion) {
        String _sql = "\n        DELETE FROM EnrollmentEntity \n        WHERE eUid = ?\n    ";
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> EnrollmentEntityDao_Impl.deleteEnrollment$lambda$0(_sql, uid, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit upsert$lambda$0(EnrollmentEntityDao_Impl this$0, List $enrolments, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__insertAdapterOfEnrollmentEntity.insert(_connection, (Iterable)$enrolments);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final EnrollmentEntity findByGuid$lambda$0(String $_sql, long $uidNum, EnrollmentEntityDao_Impl this$0, SQLiteConnection _connection) {
        EnrollmentEntity enrollmentEntity;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $uidNum);
            int _columnIndexOfEUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eUid");
            int _columnIndexOfEUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eUidNum");
            int _columnIndexOfEStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eStatus");
            int _columnIndexOfELastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eLastModified");
            int _columnIndexOfEStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eStored");
            int _columnIndexOfEMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eMetadata");
            int _columnIndexOfEClassUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eClassUid");
            int _columnIndexOfEClassUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eClassUidNum");
            int _columnIndexOfEPersonUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"ePersonUid");
            int _columnIndexOfEPersonUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"ePersonUidNum");
            int _columnIndexOfERole = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eRole");
            int _columnIndexOfEBeginDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eBeginDate");
            int _columnIndexOfEEndDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eEndDate");
            int _columnIndexOfEInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eInviteCode");
            int _columnIndexOfEApprovedByPersonUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eApprovedByPersonUidNum");
            int _columnIndexOfEApprovedByPersonUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eApprovedByPersonUid");
            EnrollmentEntity _result = null;
            if (_stmt.step()) {
                String _tmpEUid = null;
                _tmpEUid = _stmt.getText(_columnIndexOfEUid);
                long _tmpEUidNum = 0L;
                _tmpEUidNum = _stmt.getLong(_columnIndexOfEUidNum);
                StatusEnum _tmpEStatus = null;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfEStatus);
                _tmpEStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp);
                Instant _tmpELastModified = null;
                Long _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfELastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfELastModified));
                Instant _tmp_2 = this$0.__sharedConverters.toInstant(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpELastModified = _tmp_2;
                Instant _tmpEStored = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfEStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfEStored));
                Instant _tmp_4 = this$0.__sharedConverters.toInstant(_tmp_3);
                if (_tmp_4 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpEStored = _tmp_4;
                JsonObject _tmpEMetadata = null;
                String _tmp_5 = null;
                _tmp_5 = _stmt.isNull(_columnIndexOfEMetadata) ? null : _stmt.getText(_columnIndexOfEMetadata);
                _tmpEMetadata = this$0.__schoolTypeConverters.toJsonObject(_tmp_5);
                String _tmpEClassUid = null;
                _tmpEClassUid = _stmt.getText(_columnIndexOfEClassUid);
                long _tmpEClassUidNum = 0L;
                _tmpEClassUidNum = _stmt.getLong(_columnIndexOfEClassUidNum);
                String _tmpEPersonUid = null;
                _tmpEPersonUid = _stmt.getText(_columnIndexOfEPersonUid);
                long _tmpEPersonUidNum = 0L;
                _tmpEPersonUidNum = _stmt.getLong(_columnIndexOfEPersonUidNum);
                EnrollmentRoleEnum _tmpERole = null;
                int _tmp_6 = 0;
                _tmp_6 = (int)_stmt.getLong(_columnIndexOfERole);
                _tmpERole = this$0.__schoolTypeConverters.toEnrollmentRoleEnum(_tmp_6);
                LocalDate _tmpEBeginDate = null;
                Long _tmp_7 = null;
                _tmp_7 = _stmt.isNull(_columnIndexOfEBeginDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfEBeginDate));
                _tmpEBeginDate = this$0.__schoolTypeConverters.toLocalDate(_tmp_7);
                LocalDate _tmpEEndDate = null;
                Long _tmp_8 = null;
                _tmp_8 = _stmt.isNull(_columnIndexOfEEndDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfEEndDate));
                _tmpEEndDate = this$0.__schoolTypeConverters.toLocalDate(_tmp_8);
                String _tmpEInviteCode = null;
                _tmpEInviteCode = _stmt.isNull(_columnIndexOfEInviteCode) ? null : _stmt.getText(_columnIndexOfEInviteCode);
                long _tmpEApprovedByPersonUidNum = 0L;
                _tmpEApprovedByPersonUidNum = _stmt.getLong(_columnIndexOfEApprovedByPersonUidNum);
                String _tmpEApprovedByPersonUid = null;
                _tmpEApprovedByPersonUid = _stmt.isNull(_columnIndexOfEApprovedByPersonUid) ? null : _stmt.getText(_columnIndexOfEApprovedByPersonUid);
                _result = new EnrollmentEntity(_tmpEUid, _tmpEUidNum, _tmpEStatus, _tmpELastModified, _tmpEStored, _tmpEMetadata, _tmpEClassUid, _tmpEClassUidNum, _tmpEPersonUid, _tmpEPersonUidNum, _tmpERole, _tmpEBeginDate, _tmpEEndDate, _tmpEInviteCode, _tmpEApprovedByPersonUidNum, _tmpEApprovedByPersonUid);
            } else {
                _result = null;
            }
            enrollmentEntity = _result;
        }
        return enrollmentEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final EnrollmentEntity findByGuidAsFlow$lambda$0(String $_sql, long $uidNum, EnrollmentEntityDao_Impl this$0, SQLiteConnection _connection) {
        EnrollmentEntity enrollmentEntity;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $uidNum);
            int _columnIndexOfEUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eUid");
            int _columnIndexOfEUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eUidNum");
            int _columnIndexOfEStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eStatus");
            int _columnIndexOfELastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eLastModified");
            int _columnIndexOfEStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eStored");
            int _columnIndexOfEMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eMetadata");
            int _columnIndexOfEClassUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eClassUid");
            int _columnIndexOfEClassUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eClassUidNum");
            int _columnIndexOfEPersonUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"ePersonUid");
            int _columnIndexOfEPersonUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"ePersonUidNum");
            int _columnIndexOfERole = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eRole");
            int _columnIndexOfEBeginDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eBeginDate");
            int _columnIndexOfEEndDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eEndDate");
            int _columnIndexOfEInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eInviteCode");
            int _columnIndexOfEApprovedByPersonUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eApprovedByPersonUidNum");
            int _columnIndexOfEApprovedByPersonUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eApprovedByPersonUid");
            EnrollmentEntity _result = null;
            if (_stmt.step()) {
                String _tmpEUid = null;
                _tmpEUid = _stmt.getText(_columnIndexOfEUid);
                long _tmpEUidNum = 0L;
                _tmpEUidNum = _stmt.getLong(_columnIndexOfEUidNum);
                StatusEnum _tmpEStatus = null;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfEStatus);
                _tmpEStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp);
                Instant _tmpELastModified = null;
                Long _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfELastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfELastModified));
                Instant _tmp_2 = this$0.__sharedConverters.toInstant(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpELastModified = _tmp_2;
                Instant _tmpEStored = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfEStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfEStored));
                Instant _tmp_4 = this$0.__sharedConverters.toInstant(_tmp_3);
                if (_tmp_4 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpEStored = _tmp_4;
                JsonObject _tmpEMetadata = null;
                String _tmp_5 = null;
                _tmp_5 = _stmt.isNull(_columnIndexOfEMetadata) ? null : _stmt.getText(_columnIndexOfEMetadata);
                _tmpEMetadata = this$0.__schoolTypeConverters.toJsonObject(_tmp_5);
                String _tmpEClassUid = null;
                _tmpEClassUid = _stmt.getText(_columnIndexOfEClassUid);
                long _tmpEClassUidNum = 0L;
                _tmpEClassUidNum = _stmt.getLong(_columnIndexOfEClassUidNum);
                String _tmpEPersonUid = null;
                _tmpEPersonUid = _stmt.getText(_columnIndexOfEPersonUid);
                long _tmpEPersonUidNum = 0L;
                _tmpEPersonUidNum = _stmt.getLong(_columnIndexOfEPersonUidNum);
                EnrollmentRoleEnum _tmpERole = null;
                int _tmp_6 = 0;
                _tmp_6 = (int)_stmt.getLong(_columnIndexOfERole);
                _tmpERole = this$0.__schoolTypeConverters.toEnrollmentRoleEnum(_tmp_6);
                LocalDate _tmpEBeginDate = null;
                Long _tmp_7 = null;
                _tmp_7 = _stmt.isNull(_columnIndexOfEBeginDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfEBeginDate));
                _tmpEBeginDate = this$0.__schoolTypeConverters.toLocalDate(_tmp_7);
                LocalDate _tmpEEndDate = null;
                Long _tmp_8 = null;
                _tmp_8 = _stmt.isNull(_columnIndexOfEEndDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfEEndDate));
                _tmpEEndDate = this$0.__schoolTypeConverters.toLocalDate(_tmp_8);
                String _tmpEInviteCode = null;
                _tmpEInviteCode = _stmt.isNull(_columnIndexOfEInviteCode) ? null : _stmt.getText(_columnIndexOfEInviteCode);
                long _tmpEApprovedByPersonUidNum = 0L;
                _tmpEApprovedByPersonUidNum = _stmt.getLong(_columnIndexOfEApprovedByPersonUidNum);
                String _tmpEApprovedByPersonUid = null;
                _tmpEApprovedByPersonUid = _stmt.isNull(_columnIndexOfEApprovedByPersonUid) ? null : _stmt.getText(_columnIndexOfEApprovedByPersonUid);
                _result = new EnrollmentEntity(_tmpEUid, _tmpEUidNum, _tmpEStatus, _tmpELastModified, _tmpEStored, _tmpEMetadata, _tmpEClassUid, _tmpEClassUidNum, _tmpEPersonUid, _tmpEPersonUidNum, _tmpERole, _tmpEBeginDate, _tmpEEndDate, _tmpEInviteCode, _tmpEApprovedByPersonUidNum, _tmpEApprovedByPersonUid);
            } else {
                _result = null;
            }
            enrollmentEntity = _result;
        }
        return enrollmentEntity;
    }

    private static final Unit listAsPagingSource$lambda$0(long $since, long $uidNum, long $classUidNum, int $classUidRoleFlag, long $personUidNum, SQLiteStatement _stmt) {
        Intrinsics.checkNotNullParameter((Object)_stmt, (String)"_stmt");
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, $since);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, $since);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, $uidNum);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, $uidNum);
        _argIndex = 5;
        _stmt.bindLong(_argIndex, $classUidNum);
        _argIndex = 6;
        _stmt.bindLong(_argIndex, $classUidNum);
        _argIndex = 7;
        _stmt.bindLong(_argIndex, (long)$classUidRoleFlag);
        _argIndex = 8;
        _stmt.bindLong(_argIndex, (long)$classUidRoleFlag);
        _argIndex = 9;
        _stmt.bindLong(_argIndex, $personUidNum);
        _argIndex = 10;
        _stmt.bindLong(_argIndex, $personUidNum);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Long getLastModifiedByUidNum$lambda$0(String $_sql, long $uidNum, SQLiteConnection _connection) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $uidNum);
            Long _result = null;
            _result = _stmt.step() ? (_stmt.isNull(0) ? null : Long.valueOf(_stmt.getLong(0))) : null;
            l = _result;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findByUidNumList$lambda$0(String $_sql, List $uidNums, EnrollmentEntityDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            Iterator iterator = $uidNums.iterator();
            while (iterator.hasNext()) {
                long _item = ((Number)iterator.next()).longValue();
                _stmt.bindLong(_argIndex, _item);
                ++_argIndex;
            }
            int _columnIndexOfEUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eUid");
            int _columnIndexOfEUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eUidNum");
            int _columnIndexOfEStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eStatus");
            int _columnIndexOfELastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eLastModified");
            int _columnIndexOfEStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eStored");
            int _columnIndexOfEMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eMetadata");
            int _columnIndexOfEClassUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eClassUid");
            int _columnIndexOfEClassUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eClassUidNum");
            int _columnIndexOfEPersonUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"ePersonUid");
            int _columnIndexOfEPersonUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"ePersonUidNum");
            int _columnIndexOfERole = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eRole");
            int _columnIndexOfEBeginDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eBeginDate");
            int _columnIndexOfEEndDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eEndDate");
            int _columnIndexOfEInviteCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eInviteCode");
            int _columnIndexOfEApprovedByPersonUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eApprovedByPersonUidNum");
            int _columnIndexOfEApprovedByPersonUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eApprovedByPersonUid");
            List _result = new ArrayList();
            while (_stmt.step()) {
                EnrollmentEntity _item_1 = null;
                String _tmpEUid = null;
                _tmpEUid = _stmt.getText(_columnIndexOfEUid);
                long _tmpEUidNum = 0L;
                _tmpEUidNum = _stmt.getLong(_columnIndexOfEUidNum);
                StatusEnum _tmpEStatus = null;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfEStatus);
                _tmpEStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp);
                Instant _tmpELastModified = null;
                Long _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfELastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfELastModified));
                Instant _tmp_2 = this$0.__sharedConverters.toInstant(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpELastModified = _tmp_2;
                Instant _tmpEStored = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfEStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfEStored));
                Instant _tmp_4 = this$0.__sharedConverters.toInstant(_tmp_3);
                if (_tmp_4 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpEStored = _tmp_4;
                JsonObject _tmpEMetadata = null;
                String _tmp_5 = null;
                _tmp_5 = _stmt.isNull(_columnIndexOfEMetadata) ? null : _stmt.getText(_columnIndexOfEMetadata);
                _tmpEMetadata = this$0.__schoolTypeConverters.toJsonObject(_tmp_5);
                String _tmpEClassUid = null;
                _tmpEClassUid = _stmt.getText(_columnIndexOfEClassUid);
                long _tmpEClassUidNum = 0L;
                _tmpEClassUidNum = _stmt.getLong(_columnIndexOfEClassUidNum);
                String _tmpEPersonUid = null;
                _tmpEPersonUid = _stmt.getText(_columnIndexOfEPersonUid);
                long _tmpEPersonUidNum = 0L;
                _tmpEPersonUidNum = _stmt.getLong(_columnIndexOfEPersonUidNum);
                EnrollmentRoleEnum _tmpERole = null;
                int _tmp_6 = 0;
                _tmp_6 = (int)_stmt.getLong(_columnIndexOfERole);
                _tmpERole = this$0.__schoolTypeConverters.toEnrollmentRoleEnum(_tmp_6);
                LocalDate _tmpEBeginDate = null;
                Long _tmp_7 = null;
                _tmp_7 = _stmt.isNull(_columnIndexOfEBeginDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfEBeginDate));
                _tmpEBeginDate = this$0.__schoolTypeConverters.toLocalDate(_tmp_7);
                LocalDate _tmpEEndDate = null;
                Long _tmp_8 = null;
                _tmp_8 = _stmt.isNull(_columnIndexOfEEndDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfEEndDate));
                _tmpEEndDate = this$0.__schoolTypeConverters.toLocalDate(_tmp_8);
                String _tmpEInviteCode = null;
                _tmpEInviteCode = _stmt.isNull(_columnIndexOfEInviteCode) ? null : _stmt.getText(_columnIndexOfEInviteCode);
                long _tmpEApprovedByPersonUidNum = 0L;
                _tmpEApprovedByPersonUidNum = _stmt.getLong(_columnIndexOfEApprovedByPersonUidNum);
                String _tmpEApprovedByPersonUid = null;
                _tmpEApprovedByPersonUid = _stmt.isNull(_columnIndexOfEApprovedByPersonUid) ? null : _stmt.getText(_columnIndexOfEApprovedByPersonUid);
                _item_1 = new EnrollmentEntity(_tmpEUid, _tmpEUidNum, _tmpEStatus, _tmpELastModified, _tmpEStored, _tmpEMetadata, _tmpEClassUid, _tmpEClassUidNum, _tmpEPersonUid, _tmpEPersonUidNum, _tmpERole, _tmpEBeginDate, _tmpEEndDate, _tmpEInviteCode, _tmpEApprovedByPersonUidNum, _tmpEApprovedByPersonUid);
                _result.add(_item_1);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit deleteEnrollment$lambda$0(String $_sql, String $uid, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $uid);
            _stmt.step();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ RoomDatabase access$get__db$p(EnrollmentEntityDao_Impl $this) {
        return $this.__db;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lworld/respect/datalayer/db/school/daos/EnrollmentEntityDao_Impl$Companion;", "", "<init>", "()V", "getRequiredConverters", "", "Lkotlin/reflect/KClass;", "respect-datalayer-db_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

