package world.respect.datalayer.db.school.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import world.respect.datalayer.db.school.SchoolTypeConverters
import world.respect.datalayer.db.school.entities.ClassPermissionEntity
import world.respect.datalayer.school.model.EnrollmentRoleEnum

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class ClassPermissionEntityDao_Impl(
  __db: RoomDatabase,
) : ClassPermissionEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfClassPermissionEntity: EntityInsertAdapter<ClassPermissionEntity>

  private val __schoolTypeConverters: SchoolTypeConverters = SchoolTypeConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfClassPermissionEntity = object : EntityInsertAdapter<ClassPermissionEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `ClassPermissionEntity` (`cpeId`,`cpeClassUidNum`,`cpeToEnrollmentRole`,`cpePermissions`) VALUES (nullif(?, 0),?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: ClassPermissionEntity) {
        statement.bindLong(1, entity.cpeId)
        statement.bindLong(2, entity.cpeClassUidNum)
        val _tmpCpeToEnrollmentRole: EnrollmentRoleEnum? = entity.cpeToEnrollmentRole
        val _tmp: Int?
        if (_tmpCpeToEnrollmentRole == null) {
          _tmp = null
        } else {
          _tmp = __schoolTypeConverters.fromEnrollmentRoleEnum(_tmpCpeToEnrollmentRole)
        }
        if (_tmp == null) {
          statement.bindNull(3)
        } else {
          statement.bindLong(3, _tmp.toLong())
        }
        statement.bindLong(4, entity.cpePermissions)
      }
    }
  }

  public override suspend fun upsertList(permissionsList: List<ClassPermissionEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfClassPermissionEntity.insert(_connection, permissionsList)
  }

  public override suspend fun deleteByClassUidNum(classUidNum: Long) {
    val _sql: String = """
        |
        |        DELETE FROM ClassPermissionEntity
        |         WHERE ClassPermissionEntity.cpeClassUidNum = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, classUidNum)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
