/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.response;

import com.ustadmobile.ihttp.headers.IHeadersBuilder;
import com.ustadmobile.ihttp.headers.IHeadersBuilderKt;
import com.ustadmobile.ihttp.headers.IHttpHeaders;
import com.ustadmobile.ihttp.request.IHttpRequest;
import com.ustadmobile.ihttp.response.IHttpResponse;
import com.ustadmobile.libcache.headers.HeadersBuilderExtKt;
import com.ustadmobile.libcache.headers.HttpHeadersExtKt;
import com.ustadmobile.libcache.integrity.Sha256IntegrityKt;
import com.ustadmobile.libcache.io.FileSystemExtKt;
import com.ustadmobile.libcache.io.SourceExtKt;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Clock;
import kotlinx.atomicfu.AtomicBoolean;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSource;
import kotlinx.io.Source;
import kotlinx.io.files.FileMetadata;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/ustadmobile/libcache/response/HttpPathResponse;", "Lcom/ustadmobile/ihttp/response/IHttpResponse;", "path", "Lkotlinx/io/files/Path;", "fileSystem", "Lkotlinx/io/files/FileSystem;", "mimeType", "", "request", "Lcom/ustadmobile/ihttp/request/IHttpRequest;", "integrity", "extraHeaders", "Lcom/ustadmobile/ihttp/headers/IHttpHeaders;", "<init>", "(Lkotlinx/io/files/Path;Lkotlinx/io/files/FileSystem;Ljava/lang/String;Lcom/ustadmobile/ihttp/request/IHttpRequest;Ljava/lang/String;Lcom/ustadmobile/ihttp/headers/IHttpHeaders;)V", "getRequest", "()Lcom/ustadmobile/ihttp/request/IHttpRequest;", "bodyRead", "Lkotlinx/atomicfu/AtomicBoolean;", "headers", "getHeaders", "()Lcom/ustadmobile/ihttp/headers/IHttpHeaders;", "responseCode", "", "getResponseCode", "()I", "bodyAsSource", "Lkotlinx/io/Source;", "respect-lib-cache_debug"})
@SourceDebugExtension(value={"SMAP\nHttpPathResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpPathResponse.kt\ncom/ustadmobile/libcache/response/HttpPathResponse\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class HttpPathResponse
implements IHttpResponse {
    @NotNull
    private final Path path;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final IHttpRequest request;
    @NotNull
    private final AtomicBoolean bodyRead;
    @NotNull
    private final IHttpHeaders headers;

    public HttpPathResponse(@NotNull Path path, @NotNull FileSystem fileSystem, @NotNull String mimeType, @NotNull IHttpRequest request, @Nullable String integrity, @Nullable IHttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.path = path;
        this.fileSystem = fileSystem;
        this.request = request;
        this.bodyRead = AtomicFU.atomic((boolean)false);
        FileMetadata fileMetadata = this.fileSystem.metadataOrNull(this.path);
        if (fileMetadata == null) {
            throw new IOException("Cannot read from path");
        }
        FileMetadata metadata = fileMetadata;
        this.headers = IHeadersBuilderKt.iHeadersBuilder(arg_0 -> HttpPathResponse._init_$lambda$1(metadata, mimeType, extraHeaders, this, integrity, arg_0));
    }

    public /* synthetic */ HttpPathResponse(Path path, FileSystem fileSystem, String string, IHttpRequest iHttpRequest, String string2, IHttpHeaders iHttpHeaders, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            iHttpHeaders = null;
        }
        this(path, fileSystem, string, iHttpRequest, string2, iHttpHeaders);
    }

    @NotNull
    public IHttpRequest getRequest() {
        return this.request;
    }

    @NotNull
    public IHttpHeaders getHeaders() {
        return this.headers;
    }

    public int getResponseCode() {
        return 200;
    }

    @NotNull
    public Source bodyAsSource() {
        if (!this.bodyRead.getAndSet(true)) {
            return CoreKt.buffered((RawSource)this.fileSystem.source(this.path));
        }
        throw new IllegalStateException("Body has already been read");
    }

    private static final Unit _init_$lambda$1(FileMetadata $metadata, String $mimeType, IHttpHeaders $extraHeaders, HttpPathResponse this$0, String $integrity, IHeadersBuilder $this$iHeadersBuilder) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$iHeadersBuilder, (String)"$this$iHeadersBuilder");
        $this$iHeadersBuilder.header("Content-Length", String.valueOf($metadata.getSize()));
        $this$iHeadersBuilder.header("Content-Type", $mimeType);
        $this$iHeadersBuilder.header("Accept-Ranges", "bytes");
        IHttpHeaders iHttpHeaders = $extraHeaders;
        if (!(iHttpHeaders != null ? HttpHeadersExtKt.containsHeader(iHttpHeaders, "age") : false)) {
            $this$iHeadersBuilder.header("Age", String.valueOf(Clock.System.INSTANCE.now().toEpochMilliseconds() - FileSystemExtKt.lastModified(this$0.fileSystem, this$0.path)));
        }
        if ((string = $integrity) == null) {
            IHttpHeaders iHttpHeaders2 = $extraHeaders;
            string = iHttpHeaders2 != null ? HttpHeadersExtKt.integrity(iHttpHeaders2) : null;
            if (string == null) {
                string = Sha256IntegrityKt.sha256Integrity(SourceExtKt.useAndReadSha256(CoreKt.buffered((RawSource)this$0.fileSystem.source(this$0.path))));
            }
        }
        String effectiveIntegrity = string;
        IHttpHeaders iHttpHeaders3 = $extraHeaders;
        if (iHttpHeaders3 != null) {
            IHttpHeaders iHttpHeaders4;
            IHttpHeaders it = iHttpHeaders4 = iHttpHeaders3;
            boolean bl = false;
            $this$iHeadersBuilder.takeFrom(it);
        }
        HeadersBuilderExtKt.addIntegrity($this$iHeadersBuilder, $extraHeaders, effectiveIntegrity);
        return Unit.INSTANCE;
    }
}

