/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.distributed;

import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.TransactionScope;
import androidx.room.Transactor;
import com.ustadmobile.ihttp.request.IHttpRequest;
import com.ustadmobile.ihttp.request.RequestBuilder;
import com.ustadmobile.ihttp.request.RequestBuilderKt;
import com.ustadmobile.libcache.db.UstadCacheDb;
import com.ustadmobile.libcache.db.composites.NeighborCacheEntryAndNeighborCache;
import com.ustadmobile.libcache.db.dao.NeighborCacheDao;
import com.ustadmobile.libcache.db.entities.NeighborCache;
import com.ustadmobile.libcache.db.entities.NeighborCacheEntry;
import com.ustadmobile.libcache.db.entities.NewCacheEntry;
import com.ustadmobile.libcache.distributed.XXStringHasherExtKt;
import com.ustadmobile.libcache.distributed.model.DistributedCachePacket;
import com.ustadmobile.libcache.distributed.model.DistributedCachePing;
import com.ustadmobile.libcache.distributed.model.DistributedCachePong;
import com.ustadmobile.libcache.distributed.model.DistributedHashCacheEntry;
import com.ustadmobile.libcache.distributed.model.DistributedHashEntries;
import com.ustadmobile.libcache.logging.UstadCacheLogger;
import com.ustadmobile.libcache.util.ConcurrentSafeMapOfKt;
import com.ustadmobile.libcache.util.DatabaseExtKt;
import java.io.Closeable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Clock;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.libxxhash.XXStringHasher;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 72\u00020\u0001:\u0006234567BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J,\u0010'\u001a\u00020(*\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100*2\u0006\u0010+\u001a\u00020\u001f2\b\b\u0002\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020/J\b\u00101\u001a\u00020(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;", "Ljava/io/Closeable;", "cacheDb", "Lcom/ustadmobile/libcache/db/UstadCacheDb;", "httpPort", "", "logger", "Lcom/ustadmobile/libcache/logging/UstadCacheLogger;", "xxStringHasher", "Lworld/respect/libxxhash/XXStringHasher;", "mtu", "pingInterval", "", "neighborLostThreshold", "deviceName", "Lkotlin/Function0;", "", "<init>", "(Lcom/ustadmobile/libcache/db/UstadCacheDb;ILcom/ustadmobile/libcache/logging/UstadCacheLogger;Lworld/respect/libxxhash/XXStringHasher;IJJLkotlin/jvm/functions/Function0;)V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "datagramSocket", "Ljava/net/DatagramSocket;", "port", "getPort", "()I", "discoveredNeighbors", "", "Lcom/ustadmobile/libcache/db/entities/NeighborCache;", "logPrefix", "pendingPings", "Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$PendingPing;", "pingIdAtomic", "Lkotlinx/atomicfu/AtomicInt;", "sendLock", "Ljava/util/concurrent/locks/ReentrantLock;", "sendDistributedHashEntries", "", "urls", "", "neighborCache", "neighborAddress", "Ljava/net/InetAddress;", "localRequestFor", "Lcom/ustadmobile/ihttp/request/IHttpRequest;", "request", "close", "PendingPing", "SendNeighborHashesRunnable", "ReceivePacketsRunnable", "SendNewCacheEntriesRunnable", "SendPingsRunnable", "Companion", "respect-lib-cache_debug"})
@SourceDebugExtension(value={"SMAP\nDistributedCacheHashtable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistributedCacheHashtable.kt\ncom/ustadmobile/libcache/distributed/DistributedCacheHashtable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,429:1\n1869#2:430\n1563#2:431\n1634#2,3:432\n1870#2:435\n1869#2:436\n1869#2,2:437\n1870#2:439\n*S KotlinDebug\n*F\n+ 1 DistributedCacheHashtable.kt\ncom/ustadmobile/libcache/distributed/DistributedCacheHashtable\n*L\n104#1:430\n107#1:431\n107#1:432,3\n104#1:435\n404#1:436\n405#1:437,2\n404#1:439\n*E\n"})
public final class DistributedCacheHashtable
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UstadCacheDb cacheDb;
    private final int httpPort;
    @NotNull
    private final UstadCacheLogger logger;
    @NotNull
    private final XXStringHasher xxStringHasher;
    private final int mtu;
    private final long neighborLostThreshold;
    @NotNull
    private final Function0<String> deviceName;
    @NotNull
    private final CoroutineScope scope;
    private final ScheduledExecutorService executorService;
    @NotNull
    private final DatagramSocket datagramSocket;
    @NotNull
    private final Map<Long, NeighborCache> discoveredNeighbors;
    @NotNull
    private final String logPrefix;
    @NotNull
    private final Map<Integer, PendingPing> pendingPings;
    @NotNull
    private final AtomicInt pingIdAtomic;
    @NotNull
    private final ReentrantLock sendLock;
    public static final int DEFAULT_MTU = 1500;
    public static final int DATABASE_CHUNK_SIZE = 1000;
    public static final long DEFAULT_PING_INTERVAL = 3000L;
    public static final long DEFAULT_NEIGHBOR_LOST_THRESHOLD = 10000L;

    public DistributedCacheHashtable(@NotNull UstadCacheDb cacheDb, int httpPort, @NotNull UstadCacheLogger logger, @NotNull XXStringHasher xxStringHasher, int mtu, long pingInterval, long neighborLostThreshold, @NotNull Function0<String> deviceName) {
        Intrinsics.checkNotNullParameter((Object)((Object)cacheDb), (String)"cacheDb");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)xxStringHasher, (String)"xxStringHasher");
        Intrinsics.checkNotNullParameter(deviceName, (String)"deviceName");
        this.cacheDb = cacheDb;
        this.httpPort = httpPort;
        this.logger = logger;
        this.xxStringHasher = xxStringHasher;
        this.mtu = mtu;
        this.neighborLostThreshold = neighborLostThreshold;
        this.deviceName = deviceName;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)JobKt.Job$default(null, (int)1, null)));
        this.executorService = Executors.newScheduledThreadPool(2);
        this.datagramSocket = new DatagramSocket();
        this.discoveredNeighbors = ConcurrentSafeMapOfKt.concurrentSafeMapOf(new Pair[0]);
        this.logPrefix = "DistributedCacheHashtable(" + this.getPort() + " " + this.deviceName.invoke() + ")";
        this.pendingPings = ConcurrentSafeMapOfKt.concurrentSafeMapOf(new Pair[0]);
        this.pingIdAtomic = AtomicFU.atomic((int)0);
        this.sendLock = new ReentrantLock();
        if (this.httpPort == 0) {
            throw new IllegalArgumentException("DistributedCacheHashtable: httpPort cannot be 0");
        }
        UstadCacheLogger.i$default(this.logger, "DistCache", this.logPrefix + " initialized on udp port " + this.getPort(), null, 4, null);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DistributedCacheHashtable this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.cacheDb.getNeighborCacheDao().allNeighborsAsFlow().collect(new FlowCollector(){

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(List<NeighborCache> neighborList, Continuation<? super Unit> $completion) {
                                void $this$forEach$iv;
                                void $this$filterTo$iv$iv;
                                Iterable $this$filter$iv;
                                Iterable iterable = neighborList;
                                DistributedCacheHashtable distributedCacheHashtable = this$0;
                                boolean $i$f$filter = false;
                                Iterator iterator = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList();
                                boolean $i$f$filterTo = false;
                                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                    NeighborCache it = (NeighborCache)element$iv$iv;
                                    boolean bl = false;
                                    if (!(!distributedCacheHashtable.discoveredNeighbors.containsKey(Boxing.boxLong((long)it.getNeighborUid())))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                List newNeighbors = (List)destination$iv$iv;
                                $this$filter$iv = newNeighbors;
                                distributedCacheHashtable = this$0;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    NeighborCache it = (NeighborCache)element$iv;
                                    boolean bl = false;
                                    UstadCacheLogger.d$default(distributedCacheHashtable.logger, "DistCache", distributedCacheHashtable.logPrefix + " new neighbor " + it.getNeighborIp() + ":" + it.getNeighborUdpPort(), null, 4, null);
                                    distributedCacheHashtable.discoveredNeighbors.put(Boxing.boxLong((long)it.getNeighborUid()), it);
                                    distributedCacheHashtable.executorService.submit(distributedCacheHashtable.new SendNeighborHashesRunnable(it));
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DistributedCacheHashtable this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String[] stringArray = new String[]{"NewCacheEntry"};
                        this.label = 1;
                        Object object2 = InvalidationTracker.createFlow$default((InvalidationTracker)this.this$0.cacheDb.getInvalidationTracker(), (String[])stringArray, (boolean)false, (int)2, null).collect(new FlowCollector(){

                            public final Object emit(Set<String> it, Continuation<? super Unit> $completion) {
                                this$0.executorService.submit(new SendNewCacheEntriesRunnable());
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.executorService.submit(new ReceivePacketsRunnable());
        this.executorService.scheduleWithFixedDelay(new SendPingsRunnable(), pingInterval, pingInterval, TimeUnit.MILLISECONDS);
    }

    public /* synthetic */ DistributedCacheHashtable(UstadCacheDb ustadCacheDb, int n, UstadCacheLogger ustadCacheLogger, XXStringHasher xXStringHasher, int n2, long l, long l2, Function0 function0, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            n2 = 1500;
        }
        if ((n3 & 0x20) != 0) {
            l = 3000L;
        }
        if ((n3 & 0x40) != 0) {
            l2 = 10000L;
        }
        this(ustadCacheDb, n, ustadCacheLogger, xXStringHasher, n2, l, l2, (Function0<String>)function0);
    }

    public final int getPort() {
        return this.datagramSocket.getLocalPort();
    }

    /*
     * WARNING - void declaration
     */
    private final void sendDistributedHashEntries(DatagramSocket $this$sendDistributedHashEntries, List<String> urls, NeighborCache neighborCache, InetAddress neighborAddress) {
        UstadCacheLogger.d$default(this.logger, "DistCache", this.logPrefix + " Sending " + urls.size() + " url hash(es) to " + neighborCache.getNeighborIp() + ":" + neighborCache.getNeighborUdpPort(), null, 4, null);
        int entriesPerPacket = DistributedHashEntries.Companion.numEntriesFor(this.mtu);
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)urls, (int)entriesPerPacket);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<DistributedHashCacheEntry> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List urlList = (List)element$iv;
            boolean bl = false;
            Iterable iterable = urlList;
            int n = this.httpPort;
            byte by = 0;
            boolean $i$f$map = false;
            void var16_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new DistributedHashCacheEntry(this.xxStringHasher.hash((String)it), 0L, 0L));
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 1;
            List list = collection;
            int n3 = n;
            byte by2 = by;
            DistributedHashEntries hashEntries = new DistributedHashEntries(by2, n3, list, n2, defaultConstructorMarker);
            byte[] hashEntryBytes = hashEntries.toBytes();
            DatagramPacket packet = new DatagramPacket(hashEntryBytes, hashEntryBytes.length, neighborAddress, neighborCache.getNeighborUdpPort());
            $this$sendDistributedHashEntries.send(packet);
        }
    }

    static /* synthetic */ void sendDistributedHashEntries$default(DistributedCacheHashtable distributedCacheHashtable, DatagramSocket datagramSocket, List list, NeighborCache neighborCache, InetAddress inetAddress, int n, Object object) {
        if ((n & 4) != 0) {
            InetAddress inetAddress2 = InetAddress.getByName(neighborCache.getNeighborIp());
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"getByName(...)");
            inetAddress = inetAddress2;
        }
        distributedCacheHashtable.sendDistributedHashEntries(datagramSocket, list, neighborCache, inetAddress);
    }

    @Nullable
    public final IHttpRequest localRequestFor(@NotNull IHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.getMethod() != IHttpRequest.Companion.Method.GET) {
            return null;
        }
        long urlHash = this.xxStringHasher.hash(request.getUrl());
        List localResults2 = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends NeighborCacheEntryAndNeighborCache>>, Object>(this, urlHash, null){
            int label;
            final /* synthetic */ DistributedCacheHashtable this$0;
            final /* synthetic */ long $urlHash;
            {
                this.this$0 = $receiver;
                this.$urlHash = $urlHash;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheEntryDao().findAvailableNeighborsByUrlHash(this.$urlHash, (Continuation<? super List<NeighborCacheEntryAndNeighborCache>>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<NeighborCacheEntryAndNeighborCache>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (localResults2.isEmpty()) {
            return null;
        }
        NeighborCacheEntryAndNeighborCache selectedNeighbor = (NeighborCacheEntryAndNeighborCache)CollectionsKt.first((List)localResults2);
        return RequestBuilderKt.iRequestBuilder((String)("http://" + selectedNeighbor.getNeighborCache().getNeighborIp() + ":" + selectedNeighbor.getNeighborCache().getNeighborHttpPort() + "/dcache?url=" + URLEncoder.encode(request.getUrl(), "UTF-8")), arg_0 -> DistributedCacheHashtable.localRequestFor$lambda$4(request, arg_0));
    }

    @Override
    public void close() {
        this.executorService.shutdown();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
        this.datagramSocket.close();
    }

    private static final Unit localRequestFor$lambda$4(IHttpRequest $request, RequestBuilder $this$iRequestBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$iRequestBuilder, (String)"$this$iRequestBuilder");
        Iterable $this$forEach$iv = $request.getHeaders().names();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String headerName = (String)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = $request.getHeaders().getAllByName(headerName);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String headerVal = (String)element$iv2;
                boolean bl2 = false;
                $this$iRequestBuilder.header(headerName, headerVal);
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ long access$getNeighborLostThreshold$p(DistributedCacheHashtable $this) {
        return $this.neighborLostThreshold;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$Companion;", "", "<init>", "()V", "DEFAULT_MTU", "", "DATABASE_CHUNK_SIZE", "DEFAULT_PING_INTERVAL", "", "DEFAULT_NEIGHBOR_LOST_THRESHOLD", "respect-lib-cache_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$PendingPing;", "", "id", "", "timeSent", "", "remoteAddress", "Ljava/net/InetAddress;", "<init>", "(IJLjava/net/InetAddress;)V", "getId", "()I", "getTimeSent", "()J", "getRemoteAddress", "()Ljava/net/InetAddress;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "respect-lib-cache_debug"})
    public static final class PendingPing {
        private final int id;
        private final long timeSent;
        @NotNull
        private final InetAddress remoteAddress;

        public PendingPing(int id, long timeSent, @NotNull InetAddress remoteAddress) {
            Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
            this.id = id;
            this.timeSent = timeSent;
            this.remoteAddress = remoteAddress;
        }

        public final int getId() {
            return this.id;
        }

        public final long getTimeSent() {
            return this.timeSent;
        }

        @NotNull
        public final InetAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        public final int component1() {
            return this.id;
        }

        public final long component2() {
            return this.timeSent;
        }

        @NotNull
        public final InetAddress component3() {
            return this.remoteAddress;
        }

        @NotNull
        public final PendingPing copy(int id, long timeSent, @NotNull InetAddress remoteAddress) {
            Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
            return new PendingPing(id, timeSent, remoteAddress);
        }

        public static /* synthetic */ PendingPing copy$default(PendingPing pendingPing, int n, long l, InetAddress inetAddress, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = pendingPing.id;
            }
            if ((n2 & 2) != 0) {
                l = pendingPing.timeSent;
            }
            if ((n2 & 4) != 0) {
                inetAddress = pendingPing.remoteAddress;
            }
            return pendingPing.copy(n, l, inetAddress);
        }

        @NotNull
        public String toString() {
            return "PendingPing(id=" + this.id + ", timeSent=" + this.timeSent + ", remoteAddress=" + this.remoteAddress + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.id);
            result = result * 31 + Long.hashCode(this.timeSent);
            result = result * 31 + this.remoteAddress.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PendingPing)) {
                return false;
            }
            PendingPing pendingPing = (PendingPing)other;
            if (this.id != pendingPing.id) {
                return false;
            }
            if (this.timeSent != pendingPing.timeSent) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.remoteAddress, (Object)pendingPing.remoteAddress);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$ReceivePacketsRunnable;", "Ljava/lang/Runnable;", "<init>", "(Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;)V", "run", "", "respect-lib-cache_debug"})
    public final class ReceivePacketsRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UstadCacheLogger.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " waiting to receive hashes from neighbors", null, 4, null);
            DatagramPacket packet = new DatagramPacket(new byte[DistributedCacheHashtable.this.mtu], DistributedCacheHashtable.this.mtu);
            while (!Thread.interrupted()) {
                try {
                    DistributedCachePacket dCachePacket;
                    DistributedCacheHashtable.this.datagramSocket.receive(packet);
                    UstadCacheLogger.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " received hashes from " + packet.getSocketAddress(), null, 4, null);
                    XXStringHasher xXStringHasher = DistributedCacheHashtable.this.xxStringHasher;
                    InetAddress inetAddress = packet.getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getAddress(...)");
                    long neighborUid = XXStringHasherExtKt.neighborUid(xXStringHasher, inetAddress, packet.getPort());
                    byte[] byArray = packet.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
                    DistributedCachePacket distributedCachePacket = dCachePacket = DistributedCachePacket.Companion.fromBytes(byArray, packet.getOffset(), packet.getLength());
                    if (distributedCachePacket instanceof DistributedHashEntries) {
                        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(DistributedCacheHashtable.this, dCachePacket, neighborUid, packet, null){
                            int label;
                            final /* synthetic */ DistributedCacheHashtable this$0;
                            final /* synthetic */ DistributedCachePacket $dCachePacket;
                            final /* synthetic */ long $neighborUid;
                            final /* synthetic */ DatagramPacket $packet;
                            {
                                this.this$0 = $receiver;
                                this.$dCachePacket = $dCachePacket;
                                this.$neighborUid = $neighborUid;
                                this.$packet = $packet;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = DatabaseExtKt.withWriterTransaction$default(DistributedCacheHashtable.access$getCacheDb$p(this.this$0), null, (Function2)new Function2<TransactionScope<Unit>, Continuation<? super Unit>, Object>(this.this$0, this.$dCachePacket, this.$neighborUid, this.$packet, null){
                                            int label;
                                            final /* synthetic */ DistributedCacheHashtable this$0;
                                            final /* synthetic */ DistributedCachePacket $dCachePacket;
                                            final /* synthetic */ long $neighborUid;
                                            final /* synthetic */ DatagramPacket $packet;
                                            {
                                                this.this$0 = $receiver;
                                                this.$dCachePacket = $dCachePacket;
                                                this.$neighborUid = $neighborUid;
                                                this.$packet = $packet;
                                                super(2, $completion);
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.label = 1;
                                                        v0 = ReceivePacketsRunnable.access$run$insertNeighborIfNeeded(this.this$0, this.$neighborUid, this.$packet, this.$dCachePacket, (Continuation)this);
                                                        if (v0 == var15_2) {
                                                            return var15_2;
                                                        }
                                                        ** GOTO lbl13
                                                    }
                                                    case 1: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v0 = $result;
lbl13:
                                                        // 2 sources

                                                        var2_3 = ((DistributedHashEntries)this.$dCachePacket).getEntries();
                                                        var3_4 = this.$neighborUid;
                                                        var13_5 = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheEntryDao();
                                                        $i$f$map = false;
                                                        var6_7 = $this$map$iv;
                                                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                        $i$f$mapTo = false;
                                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                            var11_12 = (DistributedHashCacheEntry)item$iv$iv;
                                                            var14_14 = destination$iv$iv;
                                                            $i$a$-map-DistributedCacheHashtable$ReceivePacketsRunnable$run$1$1$1 = false;
                                                            var14_14.add(new NeighborCacheEntry(var3_4, it.getUrlHash()));
                                                        }
                                                        this.label = 2;
                                                        v1 = var13_5.upsertList((List)destination$iv$iv, (Continuation<? super Unit>)((Continuation)this));
                                                        if (v1 == var15_2) {
                                                            return var15_2;
                                                        }
                                                        ** GOTO lbl36
                                                    }
                                                    case 2: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v1 = $result;
lbl36:
                                                        // 2 sources

                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(TransactionScope<Unit> p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, (Continuation)this, 1, null);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        UstadCacheLogger.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " saved hashes from " + packet.getSocketAddress() + " to database", null, 4, null);
                        continue;
                    }
                    if (distributedCachePacket instanceof DistributedCachePing) {
                        DistributedCachePong pongReply = new DistributedCachePong(((DistributedCachePing)dCachePacket).getId(), ((DistributedCachePing)dCachePacket).getHttpPort(), ((DistributedCachePing)dCachePacket).getPayload());
                        byte[] replyBytes = pongReply.toBytes();
                        DatagramPacket replyPacket = new DatagramPacket(replyBytes, replyBytes.length, packet.getAddress(), packet.getPort());
                        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(DistributedCacheHashtable.this, neighborUid, dCachePacket, packet, null){
                            int label;
                            final /* synthetic */ DistributedCacheHashtable this$0;
                            final /* synthetic */ long $neighborUid;
                            final /* synthetic */ DistributedCachePacket $dCachePacket;
                            final /* synthetic */ DatagramPacket $packet;
                            {
                                this.this$0 = $receiver;
                                this.$neighborUid = $neighborUid;
                                this.$dCachePacket = $dCachePacket;
                                this.$packet = $packet;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = DatabaseExtKt.withWriterTransaction$default(DistributedCacheHashtable.access$getCacheDb$p(this.this$0), null, (Function2)new Function2<TransactionScope<Unit>, Continuation<? super Unit>, Object>(this.this$0, this.$neighborUid, this.$dCachePacket, this.$packet, null){
                                            int label;
                                            final /* synthetic */ DistributedCacheHashtable this$0;
                                            final /* synthetic */ long $neighborUid;
                                            final /* synthetic */ DistributedCachePacket $dCachePacket;
                                            final /* synthetic */ DatagramPacket $packet;
                                            {
                                                this.this$0 = $receiver;
                                                this.$neighborUid = $neighborUid;
                                                this.$dCachePacket = $dCachePacket;
                                                this.$packet = $packet;
                                                super(2, $completion);
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.label = 1;
                                                        v0 = ReceivePacketsRunnable.access$run$insertNeighborIfNeeded(this.this$0, this.$neighborUid, this.$packet, this.$dCachePacket, (Continuation)this);
                                                        if (v0 == var2_2) {
                                                            return var2_2;
                                                        }
                                                        ** GOTO lbl13
                                                    }
                                                    case 1: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v0 = $result;
lbl13:
                                                        // 2 sources

                                                        this.label = 2;
                                                        v1 = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheDao().updateDeviceName(this.$neighborUid, ((DistributedCachePing)this.$dCachePacket).getDeviceName(), (Continuation<? super Unit>)((Continuation)this));
                                                        if (v1 == var2_2) {
                                                            return var2_2;
                                                        }
                                                        ** GOTO lbl21
                                                    }
                                                    case 2: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v1 = $result;
lbl21:
                                                        // 2 sources

                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(TransactionScope<Unit> p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, (Continuation)this, 1, null);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        Lock lock = DistributedCacheHashtable.this.sendLock;
                        DistributedCacheHashtable distributedCacheHashtable = DistributedCacheHashtable.this;
                        lock.lock();
                        try {
                            boolean bl = false;
                            distributedCacheHashtable.datagramSocket.send(replyPacket);
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            lock.unlock();
                        }
                        UstadCacheLogger.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " sent pong reply to " + packet.getSocketAddress(), null, 4, null);
                        continue;
                    }
                    if (distributedCachePacket instanceof DistributedCachePong) {
                        PendingPing pendingPing = (PendingPing)DistributedCacheHashtable.this.pendingPings.remove(((DistributedCachePong)dCachePacket).getId());
                        if (pendingPing != null) {
                            long pingTime = Math.max(Clock.System.INSTANCE.now().toEpochMilliseconds() - pendingPing.getTimeSent(), 1L);
                            int updates2 = ((Number)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(DistributedCacheHashtable.this, packet, pingTime, null){
                                int label;
                                final /* synthetic */ DistributedCacheHashtable this$0;
                                final /* synthetic */ DatagramPacket $packet;
                                final /* synthetic */ long $pingTime;
                                {
                                    this.this$0 = $receiver;
                                    this.$packet = $packet;
                                    this.$pingTime = $pingTime;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            NeighborCacheDao neighborCacheDao = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheDao();
                                            XXStringHasher xXStringHasher = DistributedCacheHashtable.access$getXxStringHasher$p(this.this$0);
                                            InetAddress inetAddress = this.$packet.getAddress();
                                            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getAddress(...)");
                                            this.label = 1;
                                            Object object2 = neighborCacheDao.updatePingTime(XXStringHasherExtKt.neighborUid(xXStringHasher, inetAddress, this.$packet.getPort()), (int)this.$pingTime, Clock.System.INSTANCE.now().toEpochMilliseconds(), (Continuation<? super Integer>)((Continuation)this));
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)1, null)).intValue();
                            UstadCacheLogger.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " ping time to " + packet.getSocketAddress() + " is " + pingTime + "ms updates=" + updates2, null, 4, null);
                            continue;
                        }
                        UstadCacheLogger.d$default(DistributedCacheHashtable.this.logger, "DistCache", "Could not find pending ping for id " + ((DistributedCachePong)dCachePacket).getId(), null, 4, null);
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                catch (Exception e) {
                    DistributedCacheHashtable.this.logger.e("DistCache", DistributedCacheHashtable.this.logPrefix + " exception reading incoming packet", e);
                }
            }
        }

        private static final Object run$insertNeighborIfNeeded(DistributedCacheHashtable this$0, long neighborUid, DatagramPacket packet, DistributedCachePacket dCachePacket, Continuation<? super Unit> $completion) {
            Object object = RoomDatabaseKt.useWriterConnection((RoomDatabase)this$0.cacheDb, (Function2)((Function2)new Function2<Transactor, Continuation<? super Unit>, Object>(this$0, neighborUid, packet, dCachePacket, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ DistributedCacheHashtable this$0;
                final /* synthetic */ long $neighborUid;
                final /* synthetic */ DatagramPacket $packet;
                final /* synthetic */ DistributedCachePacket $dCachePacket;
                {
                    this.this$0 = $receiver;
                    this.$neighborUid = $neighborUid;
                    this.$packet = $packet;
                    this.$dCachePacket = $dCachePacket;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Transactor transactor = (Transactor)this.L$0;
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void con;
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)con);
                            this.label = 1;
                            Object object2 = con.withTransaction(Transactor.SQLiteTransactionType.IMMEDIATE, (Function2)new Function2<TransactionScope<Unit>, Continuation<? super Unit>, Object>(this.this$0, this.$neighborUid, this.$packet, this.$dCachePacket, null){
                                int label;
                                final /* synthetic */ DistributedCacheHashtable this$0;
                                final /* synthetic */ long $neighborUid;
                                final /* synthetic */ DatagramPacket $packet;
                                final /* synthetic */ DistributedCachePacket $dCachePacket;
                                {
                                    this.this$0 = $receiver;
                                    this.$neighborUid = $neighborUid;
                                    this.$packet = $packet;
                                    this.$dCachePacket = $dCachePacket;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheDao();
                                            v1 = this.$packet.getAddress().getHostAddress();
                                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getHostAddress(...)");
                                            this.label = 1;
                                            v2 = v0.insertOrIgnore(new NeighborCache(this.$neighborUid, null, v1, this.$packet.getPort(), this.$dCachePacket.getHttpPort(), 0L, 0, 0L, 0, 482, null), (Continuation<? super Unit>)((Continuation)this));
                                            if (v2 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl16
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v2 = $result;
lbl16:
                                            // 2 sources

                                            this.label = 2;
                                            v3 = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheDao().updateHttpPort(this.$neighborUid, this.$dCachePacket.getHttpPort(), (Continuation<? super Unit>)((Continuation)this));
                                            if (v3 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl24
                                        }
                                        case 2: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v3 = $result;
lbl24:
                                            // 2 sources

                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(TransactionScope<Unit> p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(Transactor p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Object access$run$insertNeighborIfNeeded(DistributedCacheHashtable this$0, long neighborUid, DatagramPacket packet, DistributedCachePacket dCachePacket, Continuation $completion) {
            return ReceivePacketsRunnable.run$insertNeighborIfNeeded(this$0, neighborUid, packet, dCachePacket, (Continuation<? super Unit>)$completion);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendNeighborHashesRunnable;", "Ljava/lang/Runnable;", "neighborCache", "Lcom/ustadmobile/libcache/db/entities/NeighborCache;", "<init>", "(Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;Lcom/ustadmobile/libcache/db/entities/NeighborCache;)V", "run", "", "respect-lib-cache_debug"})
    public final class SendNeighborHashesRunnable
    implements Runnable {
        @NotNull
        private final NeighborCache neighborCache;

        public SendNeighborHashesRunnable(NeighborCache neighborCache) {
            Intrinsics.checkNotNullParameter((Object)neighborCache, (String)"neighborCache");
            this.neighborCache = neighborCache;
        }

        @Override
        public void run() {
            UstadCacheLogger.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " starting new neighbor run for " + this.neighborCache.getNeighborIp() + ":" + this.neighborCache.getNeighborUdpPort(), null, 4, null);
            Ref.ObjectRef urls = new Ref.ObjectRef();
            Ref.IntRef offset = new Ref.IntRef();
            InetAddress neighborAddress = InetAddress.getByName(this.neighborCache.getNeighborIp());
            while (((Boolean)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(DistributedCacheHashtable.this, offset, (Ref.ObjectRef<List<String>>)urls, null){
                int label;
                final /* synthetic */ DistributedCacheHashtable this$0;
                final /* synthetic */ Ref.IntRef $offset;
                final /* synthetic */ Ref.ObjectRef<List<String>> $urls;
                {
                    this.this$0 = $receiver;
                    this.$offset = $offset;
                    this.$urls = $urls;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getCacheEntryDao().getEntryUrlsInOrder(this.$offset.element, 1000, (Continuation<? super List<String>>)((Continuation)this));
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            var2_3 = v0;
                            var3_4 = this.$urls;
                            it = (List)var2_3;
                            $i$a$-also-DistributedCacheHashtable$SendNeighborHashesRunnable$run$1$1 = false;
                            var3_4.element = it;
                            return Boxing.boxBoolean((boolean)(((Collection)var2_3).isEmpty() == false));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null)).booleanValue()) {
                DatagramSocket datagramSocket = DistributedCacheHashtable.this.datagramSocket;
                List list = (List)urls.element;
                Intrinsics.checkNotNull((Object)neighborAddress);
                DistributedCacheHashtable.this.sendDistributedHashEntries(datagramSocket, list, this.neighborCache, neighborAddress);
                offset.element += 1000;
            }
            UstadCacheLogger.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " finished new neighbor run for " + this.neighborCache.getNeighborIp() + ":" + this.neighborCache.getNeighborUdpPort(), null, 4, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendNewCacheEntriesRunnable;", "Ljava/lang/Runnable;", "<init>", "(Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;)V", "run", "", "respect-lib-cache_debug"})
    @SourceDebugExtension(value={"SMAP\nDistributedCacheHashtable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistributedCacheHashtable.kt\ncom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendNewCacheEntriesRunnable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,429:1\n1869#2:430\n1563#2:431\n1634#2,3:432\n1870#2:435\n*S KotlinDebug\n*F\n+ 1 DistributedCacheHashtable.kt\ncom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendNewCacheEntriesRunnable\n*L\n295#1:430\n297#1:431\n297#1:432,3\n295#1:435\n*E\n"})
    public final class SendNewCacheEntriesRunnable
    implements Runnable {
        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void $this$forEach$iv;
            UstadCacheLogger.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " SendNewCacheEntriesRunnable: Looking for new cache entries to send out", null, 4, null);
            Pair pair = (Pair)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends List<? extends NewCacheEntry>, ? extends List<? extends NeighborCache>>>, Object>(DistributedCacheHashtable.this, null){
                int label;
                final /* synthetic */ DistributedCacheHashtable this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = DatabaseExtKt.withWriterTransaction$default(DistributedCacheHashtable.access$getCacheDb$p(this.this$0), null, (Function2)new Function2<TransactionScope<Pair<? extends List<? extends NewCacheEntry>, ? extends List<? extends NeighborCache>>>, Continuation<? super Pair<? extends List<? extends NewCacheEntry>, ? extends List<? extends NeighborCache>>>, Object>(this.this$0, null){
                                Object L$0;
                                Object L$1;
                                int label;
                                final /* synthetic */ DistributedCacheHashtable this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            v0 = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNewCacheEntryDao().findAllNewEntries((Continuation<? super List<NewCacheEntry>>)((Continuation)this));
                                            if (v0 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            entries = (List)v0;
                                            this.L$0 = entries;
                                            this.label = 2;
                                            v1 = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheDao().allNeighbors((Continuation<? super List<NeighborCache>>)((Continuation)this));
                                            if (v1 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl24
                                        }
                                        case 2: {
                                            entries = (List)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl24:
                                            // 2 sources

                                            nodes = (List)v1;
                                            this.L$0 = entries;
                                            this.L$1 = nodes;
                                            this.label = 3;
                                            v2 = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNewCacheEntryDao().clearAll((Continuation<? super Unit>)((Continuation)this));
                                            if (v2 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl37
                                        }
                                        case 3: {
                                            nodes = (List)this.L$1;
                                            entries = (List)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v2 = $result;
lbl37:
                                            // 2 sources

                                            return new Pair((Object)entries, (Object)nodes);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(TransactionScope<Pair<List<NewCacheEntry>, List<NeighborCache>>> p1, Continuation<? super Pair<? extends List<NewCacheEntry>, ? extends List<NeighborCache>>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this, 1, null);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Pair<? extends List<NewCacheEntry>, ? extends List<NeighborCache>>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            List newEntries = (List)pair.component1();
            List allNodes2 = (List)pair.component2();
            UstadCacheLogger.d$default(DistributedCacheHashtable.this.logger, "DistCache", "SendNewCacheEntriesRunnable: sending " + newEntries.size() + " new entry hashes to " + allNodes2.size() + " nodes ", null, 4, null);
            Iterable iterable = allNodes2;
            DistributedCacheHashtable distributedCacheHashtable = DistributedCacheHashtable.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                NeighborCache neighbor = (NeighborCache)element$iv;
                boolean bl = false;
                Iterable iterable2 = newEntries;
                DatagramSocket datagramSocket = distributedCacheHashtable.datagramSocket;
                DistributedCacheHashtable distributedCacheHashtable2 = distributedCacheHashtable;
                boolean $i$f$map = false;
                void var15_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    NewCacheEntry newCacheEntry = (NewCacheEntry)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getNceUrl());
                }
                collection = (List)destination$iv$iv;
                DistributedCacheHashtable.sendDistributedHashEntries$default(distributedCacheHashtable2, datagramSocket, (List)collection, neighbor, null, 4, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendPingsRunnable;", "Ljava/lang/Runnable;", "<init>", "(Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;)V", "run", "", "respect-lib-cache_debug"})
    @SourceDebugExtension(value={"SMAP\nDistributedCacheHashtable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistributedCacheHashtable.kt\ncom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendPingsRunnable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,429:1\n1869#2,2:430\n*S KotlinDebug\n*F\n+ 1 DistributedCacheHashtable.kt\ncom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendPingsRunnable\n*L\n310#1:430,2\n*E\n"})
    public final class SendPingsRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void $this$forEach$iv;
            List allNodes2 = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends NeighborCache>>, Object>(DistributedCacheHashtable.this, null){
                int label;
                final /* synthetic */ DistributedCacheHashtable this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheDao().allNeighbors((Continuation<? super List<NeighborCache>>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super List<NeighborCache>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            UstadCacheLogger.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + ": sending pings to " + allNodes2.size() + " nodes", null, 4, null);
            String deviceNameVal = (String)DistributedCacheHashtable.this.deviceName.invoke();
            Iterable iterable = allNodes2;
            DistributedCacheHashtable distributedCacheHashtable = DistributedCacheHashtable.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NeighborCache neighbor = (NeighborCache)element$iv;
                boolean bl = false;
                try {
                    InetAddress address = InetAddress.getByName(neighbor.getNeighborIp());
                    int n = distributedCacheHashtable.pingIdAtomic.incrementAndGet();
                    int n2 = distributedCacheHashtable.httpPort;
                    Object object = new byte[]{};
                    DistributedCachePing ping = new DistributedCachePing(n, n2, deviceNameVal, (byte[])object);
                    Map map = distributedCacheHashtable.pendingPings;
                    Integer n3 = ping.getId();
                    int n4 = ping.getId();
                    long l = Clock.System.INSTANCE.now().toEpochMilliseconds();
                    Intrinsics.checkNotNull((Object)address);
                    map.put(n3, new PendingPing(n4, l, address));
                    byte[] pingPacketBytes = ping.toBytes();
                    Lock lock = distributedCacheHashtable.sendLock;
                    lock.lock();
                    try {
                        boolean bl2 = false;
                        distributedCacheHashtable.datagramSocket.send(new DatagramPacket(pingPacketBytes, pingPacketBytes.length, address, neighbor.getNeighborUdpPort()));
                        object = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                    UstadCacheLogger.d$default(distributedCacheHashtable.logger, "DistCache", distributedCacheHashtable.logPrefix + ": send ping to " + address.getHostAddress() + ":" + neighbor.getNeighborUdpPort(), null, 4, null);
                }
                catch (Throwable e) {
                    distributedCacheHashtable.logger.e("DistCache", distributedCacheHashtable.logPrefix + " exception sending ping to " + neighbor, e);
                }
            }
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(DistributedCacheHashtable.this, null){
                int label;
                final /* synthetic */ DistributedCacheHashtable this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheDao().updateStatuses(Clock.System.INSTANCE.now().toEpochMilliseconds(), DistributedCacheHashtable.access$getNeighborLostThreshold$p(this.this$0), (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
    }
}

