/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.AssertUtil;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;

public class Base64UrlUtil {
    private static final Base64.Decoder decoder = Base64.getUrlDecoder();
    private static final Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();

    private Base64UrlUtil() {
    }

    @NotNull
    public static byte[] decode(@NotNull String source) {
        AssertUtil.notNull(source, "source must not be null");
        return decoder.decode(source);
    }

    @NotNull
    public static byte[] decode(@NotNull byte[] source) {
        AssertUtil.notNull(source, "source must not be null");
        return decoder.decode(source);
    }

    @NotNull
    public static byte[] encode(@NotNull byte[] source) {
        AssertUtil.notNull(source, "source must not be null");
        return encoder.encode(source);
    }

    @NotNull
    public static String encodeToString(@NotNull byte[] source) {
        AssertUtil.notNull(source, "source must not be null");
        return encoder.encodeToString(source);
    }
}

