/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.util;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0006\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0011\u0010\u0006\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0019\u0010\n\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0011\u0010\f\u001a\u00020\b*\u00020\u0000\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ljava/nio/ByteBuffer;", "", "string", "", "writeShortString", "(Ljava/nio/ByteBuffer;Ljava/lang/String;)V", "readShortString", "(Ljava/nio/ByteBuffer;)Ljava/lang/String;", "", "payload", "writePayload", "(Ljava/nio/ByteBuffer;[B)V", "readPayload", "(Ljava/nio/ByteBuffer;)[B", "respect-lib-cache"})
public final class ByteBufferExtKt {
    public static final void writeShortString(@NotNull ByteBuffer $this$writeShortString, @NotNull String string2) {
        Intrinsics.checkNotNullParameter($this$writeShortString, "<this>");
        Intrinsics.checkNotNullParameter(string2, "string");
        String string3 = string2;
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] stringAsBytes = byArray;
        if (stringAsBytes.length > 127) {
            throw new IllegalArgumentException("Write short string: must not exceed 127 bytes");
        }
        $this$writeShortString.put((byte)stringAsBytes.length);
        $this$writeShortString.put(stringAsBytes);
    }

    @NotNull
    public static final String readShortString(@NotNull ByteBuffer $this$readShortString) {
        Intrinsics.checkNotNullParameter($this$readShortString, "<this>");
        byte stringByteSize = $this$readShortString.get();
        if (stringByteSize < 0) {
            throw new IllegalArgumentException("Doesn't look like size in bytes: " + stringByteSize);
        }
        if (stringByteSize == 0) {
            return "";
        }
        byte[] byteArray = new byte[stringByteSize];
        $this$readShortString.get(byteArray);
        return StringsKt.decodeToString(byteArray);
    }

    public static final void writePayload(@NotNull ByteBuffer $this$writePayload, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter($this$writePayload, "<this>");
        Intrinsics.checkNotNullParameter(payload, "payload");
        if (payload.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("writePayload: max byte array size of 32767 exceeded");
        }
        $this$writePayload.putShort((short)payload.length);
        if (!(payload.length == 0)) {
            $this$writePayload.put(payload);
        }
    }

    @NotNull
    public static final byte[] readPayload(@NotNull ByteBuffer $this$readPayload) {
        Intrinsics.checkNotNullParameter($this$readPayload, "<this>");
        short payloadSize = $this$readPayload.getShort();
        if (payloadSize < 0) {
            throw new IllegalStateException("Payload size cannot be negative");
        }
        byte[] payload = new byte[payloadSize];
        if (payloadSize > 0) {
            $this$readPayload.get(payload);
        }
        return payload;
    }
}

