/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.account.username.validateusername;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import world.respect.shared.domain.account.username.validateusername.ValidationResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002\u00a8\u0006\t"}, d2={"Lworld/respect/shared/domain/account/username/validateusername/ValidateUsernameUseCase;", "", "<init>", "()V", "invoke", "Lworld/respect/shared/domain/account/username/validateusername/ValidationResult;", "username", "", "Companion", "respect-lib-shared"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nValidateUsernameUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidateUsernameUseCase.kt\nworld/respect/shared/domain/account/username/validateusername/ValidateUsernameUseCase\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,49:1\n1069#2,2:50\n*S KotlinDebug\n*F\n+ 1 ValidateUsernameUseCase.kt\nworld/respect/shared/domain/account/username/validateusername/ValidateUsernameUseCase\n*L\n32#1:50,2\n*E\n"})
public final class ValidateUsernameUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    private static final int MIN_LENGTH = 3;
    private static final int MAX_LENGTH = 30;
    @NotNull
    private static final Set<Character> ALLOWED_SPECIAL;

    @NotNull
    public final ValidationResult invoke(@NotNull String username) {
        ValidationResult validationResult;
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        if (username.length() < 3) {
            validationResult = ValidationResult.Companion.getTooShort();
        } else if (username.length() > 30) {
            validationResult = ValidationResult.Companion.getTooLong();
        } else {
            Character c = StringsKt.firstOrNull((CharSequence)username);
            boolean bl = c != null ? Character.isDigit(c.charValue()) : false;
            if (bl) {
                validationResult = ValidationResult.Companion.getStartsWithNumber();
            } else {
                boolean bl2;
                block7: {
                    CharSequence $this$all$iv = username;
                    boolean $i$f$all = false;
                    for (int i = 0; i < $this$all$iv.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$all$iv.charAt(i);
                        boolean bl3 = false;
                        if (Companion.isValidUsernameChar(it)) continue;
                        bl2 = false;
                        break block7;
                    }
                    bl2 = true;
                }
                validationResult = !bl2 ? ValidationResult.Companion.getInvalidCharacters() : ValidationResult.Companion.getValid();
            }
        }
        return validationResult;
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf('_')};
        ALLOWED_SPECIAL = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lworld/respect/shared/domain/account/username/validateusername/ValidateUsernameUseCase$Companion;", "", "<init>", "()V", "MIN_LENGTH", "", "MAX_LENGTH", "ALLOWED_SPECIAL", "", "", "getALLOWED_SPECIAL", "()Ljava/util/Set;", "isValidUsernameChar", "", "character", "respect-lib-shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Character> getALLOWED_SPECIAL() {
            return ALLOWED_SPECIAL;
        }

        public final boolean isValidUsernameChar(char character) {
            return Character.isLetter(character) ? true : (Character.isDigit(character) ? true : this.getALLOWED_SPECIAL().contains(Character.valueOf(character)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

