/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.options;

import androidx.compose.runtime.Immutable;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.BrushKt;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ShaderKt;
import androidx.compose.ui.graphics.TileMode;
import androidx.compose.ui.graphics.painter.Painter;
import io.github.alexzhirkevich.qrose.ConvertersKt;
import io.github.alexzhirkevich.qrose.options.Neighbors;
import io.github.alexzhirkevich.qrose.options.QrBrush;
import io.github.alexzhirkevich.qrose.options.QrBrushMode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Shader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/github/alexzhirkevich/qrose/options/Image;", "Lio/github/alexzhirkevich/qrose/options/QrBrush;", "painter", "Landroidx/compose/ui/graphics/painter/Painter;", "alpha", "", "colorFilter", "Landroidx/compose/ui/graphics/ColorFilter;", "(Landroidx/compose/ui/graphics/painter/Painter;FLandroidx/compose/ui/graphics/ColorFilter;)V", "cachedBrush", "Landroidx/compose/ui/graphics/Brush;", "cachedSize", "", "mode", "Lio/github/alexzhirkevich/qrose/options/QrBrushMode;", "getMode", "()Lio/github/alexzhirkevich/qrose/options/QrBrushMode;", "brush", "size", "neighbors", "Lio/github/alexzhirkevich/qrose/options/Neighbors;", "qrose"})
@Immutable
final class Image
implements QrBrush {
    @NotNull
    private final Painter painter;
    private final float alpha;
    @Nullable
    private final ColorFilter colorFilter;
    @Nullable
    private Brush cachedBrush;
    private int cachedSize;

    public Image(@NotNull Painter painter, float alpha, @Nullable ColorFilter colorFilter) {
        Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
        this.painter = painter;
        this.alpha = alpha;
        this.colorFilter = colorFilter;
        this.cachedSize = -1;
    }

    public /* synthetic */ Image(Painter painter, float f, ColorFilter colorFilter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        if ((n & 4) != 0) {
            colorFilter = null;
        }
        this(painter, f, colorFilter);
    }

    @Override
    @NotNull
    public QrBrushMode getMode() {
        return QrBrushMode.Join;
    }

    @Override
    @NotNull
    public Brush brush(float size, @NotNull Neighbors neighbors) {
        Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
        int intSize = (int)size;
        if (this.cachedBrush != null && this.cachedSize == intSize) {
            Brush brush2 = this.cachedBrush;
            Intrinsics.checkNotNull((Object)brush2);
            return brush2;
        }
        ImageBitmap bmp = ConvertersKt.toImageBitmap((Painter)this.painter, (int)intSize, (int)intSize, (float)this.alpha, (ColorFilter)this.colorFilter);
        this.cachedBrush = (Brush)BrushKt.ShaderBrush((Shader)ShaderKt.ImageShader-F49vj9s((ImageBitmap)bmp, (int)TileMode.Companion.getDecal-3opZhB0(), (int)TileMode.Companion.getDecal-3opZhB0()));
        this.cachedSize = intSize;
        Brush brush3 = this.cachedBrush;
        Intrinsics.checkNotNull((Object)brush3);
        return brush3;
    }
}

