/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1.parse;

import java.nio.ByteBuffer;
import org.apache.kerby.asn1.Tag;
import org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.kerby.asn1.parse.Asn1Item;
import org.apache.kerby.asn1.parse.Asn1ParseResult;

public class Asn1DerivedItem
extends Asn1Item {
    private final Asn1Container container;
    private final Tag newTag;
    private int newBodyLength;
    private ByteBuffer newBodyBuffer;

    public Asn1DerivedItem(Tag newTag, Asn1Container container2) {
        super(container2.getHeader(), container2.getBodyStart(), container2.getBuffer());
        this.newTag = newTag;
        this.container = container2;
        this.newBodyLength = -1;
    }

    @Override
    public Tag tag() {
        return this.newTag;
    }

    private int computeBodyLength() {
        int totalLen = 0;
        for (Asn1ParseResult parseItem : this.container.getChildren()) {
            totalLen += parseItem.getBodyLength();
        }
        return totalLen;
    }

    private ByteBuffer makeBodyBuffer() {
        ByteBuffer tmpBuffer = ByteBuffer.allocate(this.getBodyLength());
        for (Asn1ParseResult parseItem : this.container.getChildren()) {
            tmpBuffer.put(parseItem.getBodyBuffer());
        }
        tmpBuffer.flip();
        return tmpBuffer;
    }

    @Override
    public ByteBuffer getBodyBuffer() {
        if (this.newBodyBuffer == null) {
            this.newBodyBuffer = this.makeBodyBuffer();
        }
        return this.newBodyBuffer;
    }

    @Override
    public int getBodyLength() {
        if (this.newBodyLength == -1) {
            this.newBodyLength = this.computeBodyLength();
        }
        return this.newBodyLength;
    }
}

