/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.client;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import com.webauthn4j.data.extension.ExtensionInput;
import com.webauthn4j.data.extension.HMACGetSecretInput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.CredentialPropertiesExtensionClientInput;
import com.webauthn4j.data.extension.client.CredentialProtectionExtensionClientInput;
import com.webauthn4j.data.extension.client.ExtensionClientInput;
import com.webauthn4j.data.extension.client.FIDOAppIDExclusionExtensionClientInput;
import com.webauthn4j.data.extension.client.FIDOAppIDExtensionClientInput;
import com.webauthn4j.data.extension.client.HMACSecretAuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.HMACSecretRegistrationExtensionClientInput;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.data.extension.client.UserVerificationMethodExtensionClientInput;
import com.webauthn4j.util.AssertUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticationExtensionsClientInputs<T extends ExtensionClientInput> {
    @JsonIgnore
    private final Map<String, Object> unknowns = new HashMap<String, Object>();
    @JsonProperty
    private String appid;
    @JsonProperty
    private String appidExclude;
    @JsonProperty
    private Boolean uvm;
    @JsonProperty
    private Boolean credProps;
    @JsonProperty
    private CredentialProtectionPolicy credentialProtectionPolicy;
    @JsonProperty
    private Boolean enforceCredentialProtectionPolicy;
    @JsonProperty
    private Boolean hmacCreateSecret;
    @JsonProperty
    private HMACGetSecretInput hmacGetSecret;
    @JsonIgnore
    private Map<Class<? extends T>, T> extensions;

    @JsonAnyGetter
    @NotNull
    private Map<String, Object> getUnknowns() {
        return Collections.unmodifiableMap(this.unknowns);
    }

    @JsonAnySetter
    private void setUnknowns(@NotNull String name, @Nullable Object value) {
        this.unknowns.put(name, value);
    }

    @JsonIgnore
    @NotNull
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (this.appid != null) {
            keys.add("appid");
        }
        if (this.appidExclude != null) {
            keys.add("appidExclude");
        }
        if (this.uvm != null) {
            keys.add("uvm");
        }
        if (this.credProps != null) {
            keys.add("credProps");
        }
        if (this.credentialProtectionPolicy != null) {
            keys.add("credentialProtectionPolicy");
        }
        if (this.enforceCredentialProtectionPolicy != null) {
            keys.add("enforceCredentialProtectionPolicy");
        }
        if (this.hmacCreateSecret != null) {
            keys.add("hmacCreateSecret");
        }
        if (this.hmacGetSecret != null) {
            keys.add("hmacGetSecret");
        }
        keys.addAll(this.getUnknownKeys());
        return keys;
    }

    @JsonIgnore
    @NotNull
    public Set<String> getUnknownKeys() {
        return this.unknowns.keySet();
    }

    @JsonIgnore
    @Nullable
    public Object getValue(@NotNull String key) {
        switch (key) {
            case "appid": {
                return this.appid;
            }
            case "appidExclude": {
                return this.appidExclude;
            }
            case "uvm": {
                return this.uvm;
            }
            case "credProps": {
                return this.credProps;
            }
            case "credentialProtectionPolicy": {
                return this.credentialProtectionPolicy;
            }
            case "enforceCredentialProtectionPolicy": {
                return this.enforceCredentialProtectionPolicy;
            }
            case "hmacCreateSecret": {
                return this.hmacCreateSecret;
            }
            case "hmacGetSecret": {
                return this.hmacGetSecret;
            }
        }
        return this.unknowns.get(key);
    }

    @JsonIgnore
    @Nullable
    public String getAppid() {
        return this.appid;
    }

    @JsonIgnore
    @Nullable
    public String getAppidExclude() {
        return this.appidExclude;
    }

    @JsonIgnore
    @Nullable
    public Boolean getUvm() {
        return this.uvm;
    }

    @JsonIgnore
    @Nullable
    public Boolean getCredProps() {
        return this.credProps;
    }

    @JsonIgnore
    @Nullable
    public CredentialProtectionPolicy getCredentialProtectionPolicy() {
        return this.credentialProtectionPolicy;
    }

    @JsonIgnore
    @Nullable
    public Boolean getEnforceCredentialProtectionPolicy() {
        return this.enforceCredentialProtectionPolicy;
    }

    @JsonIgnore
    @Nullable
    public Boolean getHMACCreateSecret() {
        return this.hmacCreateSecret;
    }

    @JsonIgnore
    @Nullable
    public HMACGetSecretInput getHMACGetSecret() {
        return this.hmacGetSecret;
    }

    @Nullable
    public <E extends T> E getExtension(Class<E> tClass) {
        return (E)((ExtensionClientInput)this.getExtensions().get(tClass));
    }

    @JsonIgnore
    @NotNull
    public Map<Class<? extends T>, T> getExtensions() {
        if (this.extensions == null) {
            HashMap<Class<HMACSecretAuthenticationExtensionClientInput>, ExtensionInput> map = new HashMap<Class<HMACSecretAuthenticationExtensionClientInput>, ExtensionInput>();
            if (this.appid != null) {
                map.put(FIDOAppIDExtensionClientInput.class, new FIDOAppIDExtensionClientInput(this.appid));
            }
            if (this.appidExclude != null) {
                map.put(FIDOAppIDExclusionExtensionClientInput.class, new FIDOAppIDExclusionExtensionClientInput(this.appidExclude));
            }
            if (this.uvm != null) {
                map.put(UserVerificationMethodExtensionClientInput.class, new UserVerificationMethodExtensionClientInput(this.uvm));
            }
            if (this.credProps != null) {
                map.put(CredentialPropertiesExtensionClientInput.class, new CredentialPropertiesExtensionClientInput(this.credProps));
            }
            if (this.credentialProtectionPolicy != null) {
                map.put(CredentialProtectionExtensionClientInput.class, new CredentialProtectionExtensionClientInput(this.credentialProtectionPolicy, this.enforceCredentialProtectionPolicy));
            }
            if (this.hmacCreateSecret != null) {
                map.put(HMACSecretRegistrationExtensionClientInput.class, new HMACSecretRegistrationExtensionClientInput(this.hmacCreateSecret));
            }
            if (this.hmacGetSecret != null) {
                map.put(HMACSecretAuthenticationExtensionClientInput.class, new HMACSecretAuthenticationExtensionClientInput(this.hmacGetSecret));
            }
            this.extensions = Collections.unmodifiableMap(map);
        }
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationExtensionsClientInputs that = (AuthenticationExtensionsClientInputs)o;
        return Objects.equals(this.unknowns, that.unknowns) && Objects.equals(this.appid, that.appid) && Objects.equals(this.appidExclude, that.appidExclude) && Objects.equals(this.uvm, that.uvm) && Objects.equals(this.credProps, that.credProps) && this.credentialProtectionPolicy == that.credentialProtectionPolicy && Objects.equals(this.enforceCredentialProtectionPolicy, that.enforceCredentialProtectionPolicy) && Objects.equals(this.hmacCreateSecret, that.hmacCreateSecret) && Objects.equals(this.hmacGetSecret, that.hmacGetSecret) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unknowns, this.appid, this.appidExclude, this.uvm, this.credProps, this.credentialProtectionPolicy, this.enforceCredentialProtectionPolicy, this.hmacCreateSecret, this.hmacGetSecret, this.extensions});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthenticationExtensionsAuthenticatorInputs(");
        String entries = this.getExtensions().values().stream().map(t -> String.format("%s=%s", t.getIdentifier(), t)).collect(Collectors.joining(", "));
        builder.append(entries);
        String unknownsStr = this.getUnknowns().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        if (!unknownsStr.isEmpty()) {
            builder.append(", ");
            builder.append(unknownsStr);
        }
        builder.append(")");
        return builder.toString();
    }

    public static class BuilderForAuthentication {
        private final Map<String, Object> unknowns = new HashMap<String, Object>();
        private String appid;
        private String appidExclude;
        private Boolean uvm;
        private HMACGetSecretInput hmacGetSecret;

        @NotNull
        public AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> build() {
            AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> instance = new AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput>();
            instance.appid = this.appid;
            instance.appidExclude = this.appidExclude;
            instance.uvm = this.uvm;
            instance.hmacGetSecret = this.hmacGetSecret;
            instance.unknowns.putAll(this.unknowns);
            return instance;
        }

        @NotNull
        public BuilderForAuthentication setAppid(@NotNull String appid) {
            this.appid = appid;
            return this;
        }

        @NotNull
        public BuilderForAuthentication setAppidExclude(@NotNull String appidExclude) {
            this.appidExclude = appidExclude;
            return this;
        }

        @NotNull
        public BuilderForAuthentication setUvm(@NotNull Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        @NotNull
        public BuilderForAuthentication setHMACGetSecret(@Nullable HMACGetSecretInput hmacGetSecret) {
            this.hmacGetSecret = hmacGetSecret;
            return this;
        }

        @NotNull
        public BuilderForAuthentication set(@NotNull String key, @Nullable Object value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }

    public static class BuilderForRegistration {
        private final Map<String, Object> unknowns = new HashMap<String, Object>();
        private Boolean uvm;
        private Boolean credProps;
        private CredentialProtectionPolicy credentialProtectionPolicy;
        private Boolean enforceCredentialProtectionPolicy;
        private Boolean hmacCreateSecret;

        @NotNull
        public AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> build() {
            AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> instance = new AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput>();
            instance.uvm = this.uvm;
            instance.credProps = this.credProps;
            instance.credentialProtectionPolicy = this.credentialProtectionPolicy;
            instance.enforceCredentialProtectionPolicy = this.enforceCredentialProtectionPolicy;
            instance.hmacCreateSecret = this.hmacCreateSecret;
            instance.unknowns.putAll(this.unknowns);
            return instance;
        }

        @NotNull
        public BuilderForRegistration setUvm(@Nullable Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        @NotNull
        public BuilderForRegistration setCredProps(@Nullable Boolean credProps) {
            this.credProps = credProps;
            return this;
        }

        @NotNull
        public BuilderForRegistration setCredentialProtectionPolicy(@Nullable CredentialProtectionPolicy credentialProtectionPolicy) {
            this.credentialProtectionPolicy = credentialProtectionPolicy;
            return this;
        }

        @NotNull
        public BuilderForRegistration setEnforceCredentialProtectionPolicy(@Nullable Boolean enforceCredentialProtectionPolicy) {
            this.enforceCredentialProtectionPolicy = enforceCredentialProtectionPolicy;
            return this;
        }

        @NotNull
        public BuilderForRegistration setHMACCreateSecret(@Nullable Boolean hmacCreateSecret) {
            this.hmacCreateSecret = hmacCreateSecret;
            return this;
        }

        @NotNull
        public BuilderForRegistration set(@NotNull String key, @Nullable Object value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }
}

