/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.PriorityQueue;
import okio.Segment;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\nH\u0016J\u0015\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\nH\u0014J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015J%\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0001J\u0012\u0010\u001e\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006!"}, d2={"Lokio/AsyncTimeout;", "Lokio/Timeout;", "<init>", "()V", "state", "", "index", "timeoutAt", "", "enter", "", "exit", "", "cancel", "remainingNanos", "now", "remainingNanos$okio", "timedOut", "sink", "Lokio/Sink;", "source", "Lokio/Source;", "withTimeout", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "access$newTimeoutException", "Ljava/io/IOException;", "cause", "newTimeoutException", "Watchdog", "Companion", "okio"})
@SourceDebugExtension(value={"SMAP\nAsyncTimeout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncTimeout.kt\nokio/AsyncTimeout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,504:1\n1#2:505\n*E\n"})
public class AsyncTimeout
extends Timeout {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private int state;
    @JvmField
    public int index = -1;
    private long timeoutAt;
    @NotNull
    private static final PriorityQueue queue = new PriorityQueue();
    @Nullable
    private static AsyncTimeout idleSentinel;
    @NotNull
    private static final ReentrantLock lock;
    @NotNull
    private static final Condition condition;
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    private static final long IDLE_TIMEOUT_MILLIS;
    private static final long IDLE_TIMEOUT_NANOS;
    private static final int STATE_IDLE = 0;
    private static final int STATE_IN_QUEUE = 1;
    private static final int STATE_TIMED_OUT = 2;
    private static final int STATE_CANCELED = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enter() {
        long timeoutNanos = this.timeoutNanos();
        boolean hasDeadline = this.hasDeadline();
        if (timeoutNanos == 0L && !hasDeadline) {
            return;
        }
        Lock lock = AsyncTimeout.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (!(this.state == 0)) {
                boolean bl2 = false;
                String string = "Unbalanced enter/exit";
                throw new IllegalStateException(string.toString());
            }
            this.state = 1;
            AsyncTimeout.Companion.insertIntoQueue(this, timeoutNanos, hasDeadline);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean exit() {
        Lock lock = AsyncTimeout.lock;
        lock.lock();
        try {
            boolean bl = false;
            int oldState = this.state;
            this.state = 0;
            if (oldState == 1) {
                queue.remove(this);
                boolean bl2 = false;
                return bl2;
            }
            boolean bl3 = oldState == 2;
            return bl3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        super.cancel();
        Lock lock = AsyncTimeout.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.state == 1) {
                queue.remove(this);
                this.state = 3;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final long remainingNanos$okio(long now) {
        return this.timeoutAt - now;
    }

    protected void timedOut() {
    }

    @NotNull
    public final Sink sink(@NotNull Sink sink2) {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        return new Sink(this, sink2){
            final /* synthetic */ AsyncTimeout this$0;
            final /* synthetic */ Sink $sink;
            {
                this.this$0 = $receiver;
                this.$sink = $sink;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void write(Buffer source2, long byteCount) {
                long toWrite;
                Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
                -SegmentedByteString.checkOffsetAndCount(source2.size(), 0L, byteCount);
                for (long remaining = byteCount; remaining > 0L; remaining -= toWrite) {
                    boolean timedOut$iv;
                    void this_$iv;
                    toWrite = 0L;
                    Intrinsics.checkNotNull((Object)source2.head);
                    while (toWrite < 65536L) {
                        Segment s;
                        int segmentSize = s.limit - s.pos;
                        if ((toWrite += (long)segmentSize) >= remaining) {
                            toWrite = remaining;
                            break;
                        }
                        Intrinsics.checkNotNull((Object)s.next);
                    }
                    AsyncTimeout segmentSize = this.this$0;
                    Sink sink2 = this.$sink;
                    boolean $i$f$withTimeout = false;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        boolean bl = false;
                        sink2.write(source2, toWrite);
                        Unit result$iv = Unit.INSTANCE;
                        throwOnTimeout$iv = true;
                        Unit unit = result$iv;
                        timedOut$iv = this_$iv.exit();
                        if (!timedOut$iv) continue;
                    }
                    catch (IOException e$iv) {
                        try {
                            throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException(e$iv);
                        }
                        catch (Throwable throwable) {
                            timedOut$iv = this_$iv.exit();
                            if (timedOut$iv && throwOnTimeout$iv) {
                                throw this_$iv.access$newTimeoutException(null);
                            }
                            throw throwable;
                        }
                    }
                    throw this_$iv.access$newTimeoutException(null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void flush() {
                void this_$iv;
                AsyncTimeout asyncTimeout = this.this$0;
                Sink sink2 = this.$sink;
                boolean $i$f$withTimeout = false;
                boolean throwOnTimeout$iv = false;
                this_$iv.enter();
                try {
                    boolean bl = false;
                    sink2.flush();
                    Unit result$iv = Unit.INSTANCE;
                    throwOnTimeout$iv = true;
                    Unit unit = result$iv;
                    boolean timedOut$iv = this_$iv.exit();
                    if (!timedOut$iv) return;
                }
                catch (IOException e$iv) {
                    try {
                        throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException(e$iv);
                    }
                    catch (Throwable throwable) {
                        boolean timedOut$iv = this_$iv.exit();
                        if (!timedOut$iv || !throwOnTimeout$iv) throw throwable;
                        throw this_$iv.access$newTimeoutException(null);
                    }
                }
                throw this_$iv.access$newTimeoutException(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void close() {
                void this_$iv;
                AsyncTimeout asyncTimeout = this.this$0;
                Sink sink2 = this.$sink;
                boolean $i$f$withTimeout = false;
                boolean throwOnTimeout$iv = false;
                this_$iv.enter();
                try {
                    boolean bl = false;
                    sink2.close();
                    Unit result$iv = Unit.INSTANCE;
                    throwOnTimeout$iv = true;
                    Unit unit = result$iv;
                    boolean timedOut$iv = this_$iv.exit();
                    if (!timedOut$iv) return;
                }
                catch (IOException e$iv) {
                    try {
                        throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException(e$iv);
                    }
                    catch (Throwable throwable) {
                        boolean timedOut$iv = this_$iv.exit();
                        if (!timedOut$iv || !throwOnTimeout$iv) throw throwable;
                        throw this_$iv.access$newTimeoutException(null);
                    }
                }
                throw this_$iv.access$newTimeoutException(null);
            }

            public AsyncTimeout timeout() {
                return this.this$0;
            }

            public String toString() {
                return "AsyncTimeout.sink(" + this.$sink + ')';
            }
        };
    }

    @NotNull
    public final Source source(@NotNull Source source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        return new Source(this, source2){
            final /* synthetic */ AsyncTimeout this$0;
            final /* synthetic */ Source $source;
            {
                this.this$0 = $receiver;
                this.$source = $source;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public long read(Buffer sink2, long byteCount) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
                AsyncTimeout asyncTimeout = this.this$0;
                Source source2 = this.$source;
                boolean $i$f$withTimeout = false;
                boolean throwOnTimeout$iv = false;
                this_$iv.enter();
                try {
                    boolean bl = false;
                    long result$iv = source2.read(sink2, byteCount);
                    throwOnTimeout$iv = true;
                    long l = result$iv;
                    boolean timedOut$iv = this_$iv.exit();
                    if (!timedOut$iv) return l;
                }
                catch (IOException e$iv) {
                    try {
                        throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException(e$iv);
                    }
                    catch (Throwable throwable) {
                        boolean timedOut$iv = this_$iv.exit();
                        if (!timedOut$iv || !throwOnTimeout$iv) throw throwable;
                        throw this_$iv.access$newTimeoutException(null);
                    }
                }
                throw this_$iv.access$newTimeoutException(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void close() {
                void this_$iv;
                AsyncTimeout asyncTimeout = this.this$0;
                Source source2 = this.$source;
                boolean $i$f$withTimeout = false;
                boolean throwOnTimeout$iv = false;
                this_$iv.enter();
                try {
                    boolean bl = false;
                    source2.close();
                    Unit result$iv = Unit.INSTANCE;
                    throwOnTimeout$iv = true;
                    Unit unit = result$iv;
                    boolean timedOut$iv = this_$iv.exit();
                    if (!timedOut$iv) return;
                }
                catch (IOException e$iv) {
                    try {
                        throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException(e$iv);
                    }
                    catch (Throwable throwable) {
                        boolean timedOut$iv = this_$iv.exit();
                        if (!timedOut$iv || !throwOnTimeout$iv) throw throwable;
                        throw this_$iv.access$newTimeoutException(null);
                    }
                }
                throw this_$iv.access$newTimeoutException(null);
            }

            public AsyncTimeout timeout() {
                return this.this$0;
            }

            public String toString() {
                return "AsyncTimeout.source(" + this.$source + ')';
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withTimeout(@NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withTimeout = false;
        boolean throwOnTimeout = false;
        this.enter();
        try {
            Object result = block.invoke();
            throwOnTimeout = true;
            object = result;
        }
        catch (IOException e) {
            try {
                throw !this.exit() ? (Throwable)e : (Throwable)this.access$newTimeoutException(e);
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart((int)1);
                boolean timedOut = this.exit();
                if (timedOut && throwOnTimeout) {
                    throw this.access$newTimeoutException(null);
                }
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
        }
        InlineMarker.finallyStart((int)1);
        boolean timedOut = this.exit();
        if (timedOut) {
            throw this.access$newTimeoutException(null);
        }
        InlineMarker.finallyEnd((int)1);
        return (T)object;
    }

    @PublishedApi
    @NotNull
    public final IOException access$newTimeoutException(@Nullable IOException cause) {
        return this.newTimeoutException(cause);
    }

    @NotNull
    protected IOException newTimeoutException(@Nullable IOException cause) {
        InterruptedIOException e = new InterruptedIOException("timeout");
        if (cause != null) {
            e.initCause(cause);
        }
        return e;
    }

    static {
        lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"newCondition(...)");
        AsyncTimeout.condition = condition;
        IDLE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
        IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(IDLE_TIMEOUT_MILLIS);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u0004\u0018\u00010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lokio/AsyncTimeout$Companion;", "", "<init>", "()V", "queue", "Lokio/PriorityQueue;", "getQueue", "()Lokio/PriorityQueue;", "idleSentinel", "Lokio/AsyncTimeout;", "getIdleSentinel", "()Lokio/AsyncTimeout;", "setIdleSentinel", "(Lokio/AsyncTimeout;)V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "condition", "Ljava/util/concurrent/locks/Condition;", "getCondition", "()Ljava/util/concurrent/locks/Condition;", "TIMEOUT_WRITE_SIZE", "", "IDLE_TIMEOUT_MILLIS", "", "IDLE_TIMEOUT_NANOS", "STATE_IDLE", "STATE_IN_QUEUE", "STATE_TIMED_OUT", "STATE_CANCELED", "insertIntoQueue", "", "node", "timeoutNanos", "hasDeadline", "", "awaitTimeout", "okio"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PriorityQueue getQueue() {
            return queue;
        }

        @Nullable
        public final AsyncTimeout getIdleSentinel() {
            return idleSentinel;
        }

        public final void setIdleSentinel(@Nullable AsyncTimeout asyncTimeout) {
            idleSentinel = asyncTimeout;
        }

        @NotNull
        public final ReentrantLock getLock() {
            return lock;
        }

        @NotNull
        public final Condition getCondition() {
            return condition;
        }

        private final void insertIntoQueue(AsyncTimeout node, long timeoutNanos, boolean hasDeadline) {
            if (this.getIdleSentinel() == null) {
                this.setIdleSentinel(new AsyncTimeout());
                new Watchdog().start();
            }
            long now = System.nanoTime();
            if (timeoutNanos != 0L && hasDeadline) {
                node.timeoutAt = now + Math.min(timeoutNanos, node.deadlineNanoTime() - now);
            } else if (timeoutNanos != 0L) {
                node.timeoutAt = now + timeoutNanos;
            } else if (hasDeadline) {
                node.timeoutAt = node.deadlineNanoTime();
            } else {
                throw new AssertionError();
            }
            this.getQueue().add(node);
            if (node.index == 1) {
                this.getCondition().signal();
            }
        }

        @Nullable
        public final AsyncTimeout awaitTimeout() throws InterruptedException {
            AsyncTimeout node = this.getQueue().first();
            if (node == null) {
                long startNanos = System.nanoTime();
                this.getCondition().await(IDLE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
                return this.getQueue().first() == null && System.nanoTime() - startNanos >= IDLE_TIMEOUT_NANOS ? this.getIdleSentinel() : null;
            }
            long waitNanos = node.remainingNanos$okio(System.nanoTime());
            if (waitNanos > 0L) {
                this.getCondition().await(waitNanos, TimeUnit.NANOSECONDS);
                return null;
            }
            this.getQueue().remove(node);
            node.state = 2;
            return node;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lokio/AsyncTimeout$Watchdog;", "Ljava/lang/Thread;", "<init>", "()V", "run", "", "okio"})
    private static final class Watchdog
    extends Thread {
        public Watchdog() {
            super("Okio Watchdog");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    AsyncTimeout timedOut = null;
                    Lock lock = Companion.getLock();
                    lock.lock();
                    try {
                        boolean bl = false;
                        timedOut = Companion.awaitTimeout();
                        if (timedOut == Companion.getIdleSentinel()) {
                            Companion.setIdleSentinel(null);
                            return;
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                    AsyncTimeout asyncTimeout = timedOut;
                    if (asyncTimeout != null) {
                        asyncTimeout.timedOut();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

