/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cors;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.List;

public class CorsHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CorsHandler.class);
    private static final String ANY_ORIGIN = "*";
    private static final String NULL_ORIGIN = "null";
    private CorsConfig config;
    private HttpRequest request;
    private final List<CorsConfig> configList;
    private final boolean isShortCircuit;

    public CorsHandler(CorsConfig config2) {
        this(Collections.singletonList(ObjectUtil.checkNotNull(config2, "config")), config2.isShortCircuit());
    }

    public CorsHandler(List<CorsConfig> configList, boolean isShortCircuit) {
        ObjectUtil.checkNonEmpty(configList, "configList");
        this.configList = configList;
        this.isShortCircuit = isShortCircuit;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            this.request = (HttpRequest)msg;
            String origin2 = this.request.headers().get(HttpHeaderNames.ORIGIN);
            this.config = this.getForOrigin(origin2);
            if (CorsHandler.isPreflightRequest(this.request)) {
                this.handlePreflight(ctx, this.request);
                return;
            }
            if (this.isShortCircuit && origin2 != null && this.config == null) {
                CorsHandler.forbidden(ctx, this.request);
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    private void handlePreflight(ChannelHandlerContext ctx, HttpRequest request2) {
        DefaultFullHttpResponse response2 = new DefaultFullHttpResponse(request2.protocolVersion(), HttpResponseStatus.OK, Unpooled.buffer(0), DefaultHttpHeadersFactory.headersFactory().withCombiningHeaders(true), DefaultHttpHeadersFactory.trailersFactory().withCombiningHeaders(true));
        if (this.setOrigin(response2)) {
            this.setAllowMethods(response2);
            this.setAllowHeaders(response2);
            this.setAllowCredentials(response2);
            this.setMaxAge(response2);
            this.setPreflightHeaders(response2);
            this.setAllowPrivateNetwork(response2);
        }
        if (!response2.headers().contains(HttpHeaderNames.CONTENT_LENGTH)) {
            response2.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
        }
        ReferenceCountUtil.release(request2);
        CorsHandler.respond(ctx, request2, response2);
    }

    private void setPreflightHeaders(HttpResponse response2) {
        response2.headers().add(this.config.preflightResponseHeaders());
    }

    private CorsConfig getForOrigin(String requestOrigin) {
        for (CorsConfig corsConfig : this.configList) {
            if (corsConfig.isAnyOriginSupported()) {
                return corsConfig;
            }
            if (corsConfig.origins().contains(requestOrigin)) {
                return corsConfig;
            }
            if (!corsConfig.isNullOriginAllowed() && !NULL_ORIGIN.equals(requestOrigin)) continue;
            return corsConfig;
        }
        return null;
    }

    private boolean setOrigin(HttpResponse response2) {
        String origin2 = this.request.headers().get(HttpHeaderNames.ORIGIN);
        if (origin2 != null && this.config != null) {
            if (NULL_ORIGIN.equals(origin2) && this.config.isNullOriginAllowed()) {
                CorsHandler.setNullOrigin(response2);
                return true;
            }
            if (this.config.isAnyOriginSupported()) {
                if (this.config.isCredentialsAllowed()) {
                    this.echoRequestOrigin(response2);
                    CorsHandler.setVaryHeader(response2);
                } else {
                    CorsHandler.setAnyOrigin(response2);
                }
                return true;
            }
            if (this.config.origins().contains(origin2)) {
                CorsHandler.setOrigin(response2, origin2);
                CorsHandler.setVaryHeader(response2);
                return true;
            }
            logger.debug("Request origin [{}]] was not among the configured origins [{}]", (Object)origin2, (Object)this.config.origins());
        }
        return false;
    }

    private void echoRequestOrigin(HttpResponse response2) {
        CorsHandler.setOrigin(response2, this.request.headers().get(HttpHeaderNames.ORIGIN));
    }

    private static void setVaryHeader(HttpResponse response2) {
        response2.headers().set((CharSequence)HttpHeaderNames.VARY, (Object)HttpHeaderNames.ORIGIN);
    }

    private static void setAnyOrigin(HttpResponse response2) {
        CorsHandler.setOrigin(response2, ANY_ORIGIN);
    }

    private static void setNullOrigin(HttpResponse response2) {
        CorsHandler.setOrigin(response2, NULL_ORIGIN);
    }

    private static void setOrigin(HttpResponse response2, String origin2) {
        response2.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin2);
    }

    private void setAllowCredentials(HttpResponse response2) {
        if (this.config.isCredentialsAllowed() && !response2.headers().get(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN).equals(ANY_ORIGIN)) {
            response2.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        }
    }

    private static boolean isPreflightRequest(HttpRequest request2) {
        HttpHeaders headers2 = request2.headers();
        return HttpMethod.OPTIONS.equals(request2.method()) && headers2.contains(HttpHeaderNames.ORIGIN) && headers2.contains(HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD);
    }

    private void setExposeHeaders(HttpResponse response2) {
        if (!this.config.exposedHeaders().isEmpty()) {
            response2.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, this.config.exposedHeaders());
        }
    }

    private void setAllowMethods(HttpResponse response2) {
        response2.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, this.config.allowedRequestMethods());
    }

    private void setAllowHeaders(HttpResponse response2) {
        response2.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, this.config.allowedRequestHeaders());
    }

    private void setMaxAge(HttpResponse response2) {
        response2.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE, (Object)this.config.maxAge());
    }

    private void setAllowPrivateNetwork(HttpResponse response2) {
        if (this.request.headers().contains(HttpHeaderNames.ACCESS_CONTROL_REQUEST_PRIVATE_NETWORK)) {
            if (this.config.isPrivateNetworkAllowed()) {
                response2.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK, (Object)"true");
            } else {
                response2.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK, (Object)"false");
            }
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        HttpResponse response2;
        if (this.config != null && this.config.isCorsSupportEnabled() && msg instanceof HttpResponse && this.setOrigin(response2 = (HttpResponse)msg)) {
            this.setAllowCredentials(response2);
            this.setExposeHeaders(response2);
        }
        ctx.write(msg, promise);
    }

    private static void forbidden(ChannelHandlerContext ctx, HttpRequest request2) {
        DefaultFullHttpResponse response2 = new DefaultFullHttpResponse(request2.protocolVersion(), HttpResponseStatus.FORBIDDEN, ctx.alloc().buffer(0));
        response2.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
        ReferenceCountUtil.release(request2);
        CorsHandler.respond(ctx, request2, response2);
    }

    private static void respond(ChannelHandlerContext ctx, HttpRequest request2, HttpResponse response2) {
        boolean keepAlive = HttpUtil.isKeepAlive(request2);
        HttpUtil.setKeepAlive(response2, keepAlive);
        ChannelFuture future = ctx.writeAndFlush(response2);
        if (!keepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

