/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.cbor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.converter.jackson.deserializer.cbor.COSEKeyEnvelope;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class COSEKeyEnvelopeDeserializer
extends StdDeserializer<COSEKeyEnvelope> {
    public COSEKeyEnvelopeDeserializer() {
        super(COSEKeyEnvelope.class);
    }

    @Override
    @NotNull
    public COSEKeyEnvelope deserialize(@NotNull JsonParser p2, @NotNull DeserializationContext ctxt) throws IOException {
        @Nullable COSEKey coseKey = ctxt.readValue(p2, COSEKey.class);
        int length = (int)p2.getCurrentLocation().getByteOffset();
        return new COSEKeyEnvelope(coseKey, length);
    }
}

