/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.ApplicationKt;
import io.ktor.server.sessions.SessionSerializer;
import io.ktor.server.sessions.SessionTracker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B#\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0096@\u00a2\u0006\u0004\b\u000e\u0010\u000fJ \u0010\u0011\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00028\u0000H\u0096@\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\nH\u0096@\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lio/ktor/server/sessions/SessionTrackerByValue;", "", "S", "Lio/ktor/server/sessions/SessionTracker;", "Lkotlin/reflect/KClass;", "type", "Lio/ktor/server/sessions/SessionSerializer;", "serializer", "<init>", "(Lkotlin/reflect/KClass;Lio/ktor/server/sessions/SessionSerializer;)V", "Lio/ktor/server/application/ApplicationCall;", "call", "", "transport", "load", "(Lio/ktor/server/application/ApplicationCall;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "value", "store", "(Lio/ktor/server/application/ApplicationCall;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "validate", "(Ljava/lang/Object;)V", "clear", "(Lio/ktor/server/application/ApplicationCall;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "()Ljava/lang/String;", "Lkotlin/reflect/KClass;", "getType", "()Lkotlin/reflect/KClass;", "Lio/ktor/server/sessions/SessionSerializer;", "getSerializer", "()Lio/ktor/server/sessions/SessionSerializer;", "ktor-server-sessions"})
public final class SessionTrackerByValue<S>
implements SessionTracker<S> {
    @NotNull
    private final KClass<S> type;
    @NotNull
    private final SessionSerializer<S> serializer;

    public SessionTrackerByValue(@NotNull KClass<S> type2, @NotNull SessionSerializer<S> serializer2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        this.type = type2;
        this.serializer = serializer2;
    }

    @NotNull
    public final KClass<S> getType() {
        return this.type;
    }

    @NotNull
    public final SessionSerializer<S> getSerializer() {
        return this.serializer;
    }

    @Override
    @Nullable
    public Object load(@NotNull ApplicationCall call, @Nullable String transport, @NotNull Continuation<? super S> $completion) {
        Object v1;
        String string2 = transport;
        if (string2 != null) {
            S s2;
            String serialized = string2;
            boolean bl = false;
            try {
                s2 = this.serializer.deserialize(serialized);
            }
            catch (Throwable t) {
                ApplicationKt.getLog(call.getApplication()).debug("Failed to deserialize session: " + serialized, t);
                s2 = null;
            }
            v1 = s2;
        } else {
            v1 = null;
        }
        return v1;
    }

    @Override
    @Nullable
    public Object store(@NotNull ApplicationCall call, @NotNull S value, @NotNull Continuation<? super String> $completion) {
        return this.serializer.serialize(value);
    }

    @Override
    public void validate(@NotNull S value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!this.type.isInstance(value)) {
            throw new IllegalArgumentException("Value for this session tracker expected to be of type " + this.type + " but was " + value);
        }
    }

    @Override
    @Nullable
    public Object clear(@NotNull ApplicationCall call, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @NotNull
    public String toString() {
        return "SessionTrackerByValue";
    }
}

