/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.jws;

import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.jws.JWS;
import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.data.jws.JWSSignatureUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.Base64UrlUtil;
import com.webauthn4j.util.SignatureUtil;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import org.jetbrains.annotations.NotNull;

public class JWSFactory {
    private static final String HEADER_MUST_NOT_BE_NULL = "header must not be null";
    private static final String PAYLOAD_MUST_NOT_BE_NULL = "payload must not be null";
    private final JsonConverter jsonConverter;

    public JWSFactory(@NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.jsonConverter = objectConverter.getJsonConverter();
    }

    public JWSFactory() {
        this(new ObjectConverter());
    }

    @NotNull
    public <T> JWS<T> create(@NotNull JWSHeader header, @NotNull T payload, @NotNull PrivateKey privateKey) {
        AssertUtil.notNull((Object)header, (String)HEADER_MUST_NOT_BE_NULL);
        AssertUtil.notNull(payload, (String)PAYLOAD_MUST_NOT_BE_NULL);
        AssertUtil.notNull((Object)privateKey, (String)"privateKey must not be null");
        String headerString = Base64UrlUtil.encodeToString((byte[])this.jsonConverter.writeValueAsString(header).getBytes(StandardCharsets.UTF_8));
        String payloadString = Base64UrlUtil.encodeToString((byte[])this.jsonConverter.writeValueAsString(payload).getBytes(StandardCharsets.UTF_8));
        String signedData = headerString + "." + payloadString;
        if (header.getAlg() == null) {
            throw new IllegalArgumentException("alg must not be null");
        }
        Signature signatureObj = SignatureUtil.createSignature((String)header.getAlg().getJcaName());
        try {
            signatureObj.initSign(privateKey);
            signatureObj.update(signedData.getBytes());
            byte[] derSignature = signatureObj.sign();
            byte[] jwsSignature = JWSSignatureUtil.convertDerSignatureToJwsSignature(derSignature);
            return new JWS<T>(header, headerString, payload, payloadString, jwsSignature);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @NotNull
    public <T> JWS<T> create(@NotNull JWSHeader header, @NotNull T payload, @NotNull byte[] signature) {
        AssertUtil.notNull((Object)header, (String)HEADER_MUST_NOT_BE_NULL);
        AssertUtil.notNull(payload, (String)PAYLOAD_MUST_NOT_BE_NULL);
        AssertUtil.notNull((Object)signature, (String)"signature must not be null");
        String headerString = Base64UrlUtil.encodeToString((byte[])this.jsonConverter.writeValueAsString(header).getBytes(StandardCharsets.UTF_8));
        String payloadString = Base64UrlUtil.encodeToString((byte[])this.jsonConverter.writeValueAsString(payload).getBytes(StandardCharsets.UTF_8));
        return new JWS<T>(header, headerString, payload, payloadString, signature);
    }

    @NotNull
    public <T> JWS<T> parse(@NotNull String value, @NotNull Class<T> payloadType) {
        AssertUtil.notNull((Object)value, (String)"value must not be null");
        AssertUtil.notNull(payloadType, (String)"payloadType must not be null");
        String[] data = value.split("\\.");
        if (data.length != 3) {
            throw new IllegalArgumentException("JWS value is not divided by two period.");
        }
        String headerString = data[0];
        String payloadString = data[1];
        String signatureString = data[2];
        JWSHeader header = this.jsonConverter.readValue(new String(Base64UrlUtil.decode((String)headerString)), JWSHeader.class);
        T payload = this.jsonConverter.readValue(new String(Base64UrlUtil.decode((String)payloadString)), payloadType);
        byte[] signature = Base64UrlUtil.decode((String)signatureString);
        AssertUtil.notNull((Object)header, (String)HEADER_MUST_NOT_BE_NULL);
        AssertUtil.notNull(payload, (String)PAYLOAD_MUST_NOT_BE_NULL);
        return new JWS<T>(header, headerString, payload, payloadString, signature);
    }
}

