/*
 * Decompiled with CFR 0.152.
 */
package world.respect.datalayer.db.opds.daos;

import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.coroutines.FlowUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import io.ktor.http.Url;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.db.opds.daos.OpdsFeedEntityDao;
import world.respect.datalayer.db.opds.entities.OpdsFeedEntity;
import world.respect.datalayer.db.shared.LastModifiedAndETagDb;
import world.respect.datalayer.db.shared.SharedConverters;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lworld/respect/datalayer/db/opds/daos/OpdsFeedEntityDao_Impl;", "Lworld/respect/datalayer/db/opds/daos/OpdsFeedEntityDao;", "__db", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "__insertAdapterOfOpdsFeedEntity", "Landroidx/room/EntityInsertAdapter;", "Lworld/respect/datalayer/db/opds/entities/OpdsFeedEntity;", "__sharedConverters", "Lworld/respect/datalayer/db/shared/SharedConverters;", "insertList", "", "entities", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUrlHashAsFlow", "Lkotlinx/coroutines/flow/Flow;", "urlHash", "", "getLastModifiedAndETag", "Lworld/respect/datalayer/db/shared/LastModifiedAndETagDb;", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteByFeedUid", "feedUid", "Companion", "respect-datalayer-db_release"})
public final class OpdsFeedEntityDao_Impl
extends OpdsFeedEntityDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<OpdsFeedEntity> __insertAdapterOfOpdsFeedEntity;
    @NotNull
    private final SharedConverters __sharedConverters;

    public OpdsFeedEntityDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__sharedConverters = new SharedConverters();
        this.__db = __db;
        this.__insertAdapterOfOpdsFeedEntity = (EntityInsertAdapter)new EntityInsertAdapter<OpdsFeedEntity>(){

            protected String createQuery() {
                return "INSERT OR ABORT INTO `OpdsFeedEntity` (`ofeUid`,`ofeUrl`,`ofeUrlHash`,`ofeLastModifiedHeader`,`ofeEtag`) VALUES (?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, OpdsFeedEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindLong(1, entity.getOfeUid());
                String _tmp = __sharedConverters.fromUrl(entity.getOfeUrl());
                if (_tmp == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, _tmp);
                }
                statement.bindLong(3, entity.getOfeUrlHash());
                statement.bindLong(4, entity.getOfeLastModifiedHeader());
                String _tmpOfeEtag = entity.getOfeEtag();
                if (_tmpOfeEtag == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmpOfeEtag);
                }
            }
        };
    }

    @Override
    @Nullable
    public Object insertList(@NotNull List<OpdsFeedEntity> entities, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> OpdsFeedEntityDao_Impl.insertList$lambda$0(this, entities, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public Flow<OpdsFeedEntity> findByUrlHashAsFlow(long urlHash) {
        String _sql = "\n        SELECT * \n          FROM OpdsFeedEntity \n         WHERE ofeUrlHash = ?\n    ";
        String[] stringArray = new String[]{"OpdsFeedEntity"};
        return FlowUtil.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, arg_0 -> OpdsFeedEntityDao_Impl.findByUrlHashAsFlow$lambda$0(_sql, urlHash, this, arg_0));
    }

    @Override
    @Nullable
    public Object getLastModifiedAndETag(long urlHash, @NotNull Continuation<? super LastModifiedAndETagDb> $completion) {
        String _sql = "\n        SELECT OpdsFeedEntity.ofeLastModifiedHeader AS lastModified,\n               OpdsFeedEntity.ofeEtag AS etag\n          FROM OpdsFeedEntity\n         WHERE ofeUrlHash = ?\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> OpdsFeedEntityDao_Impl.getLastModifiedAndETag$lambda$0(_sql, urlHash, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object deleteByFeedUid(long feedUid, @NotNull Continuation<? super Unit> $completion) {
        String _sql = "\n        DELETE FROM OpdsFeedEntity \n         WHERE ofeUid = ?\n    ";
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> OpdsFeedEntityDao_Impl.deleteByFeedUid$lambda$0(_sql, feedUid, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit insertList$lambda$0(OpdsFeedEntityDao_Impl this$0, List $entities, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__insertAdapterOfOpdsFeedEntity.insert(_connection, (Iterable)$entities);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final OpdsFeedEntity findByUrlHashAsFlow$lambda$0(String $_sql, long $urlHash, OpdsFeedEntityDao_Impl this$0, SQLiteConnection _connection) {
        OpdsFeedEntity opdsFeedEntity;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $urlHash);
            int _columnIndexOfOfeUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"ofeUid");
            int _columnIndexOfOfeUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"ofeUrl");
            int _columnIndexOfOfeUrlHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"ofeUrlHash");
            int _columnIndexOfOfeLastModifiedHeader = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"ofeLastModifiedHeader");
            int _columnIndexOfOfeEtag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"ofeEtag");
            OpdsFeedEntity _result = null;
            if (_stmt.step()) {
                long _tmpOfeUid = 0L;
                _tmpOfeUid = _stmt.getLong(_columnIndexOfOfeUid);
                Url _tmpOfeUrl = null;
                String _tmp = null;
                _tmp = _stmt.isNull(_columnIndexOfOfeUrl) ? null : _stmt.getText(_columnIndexOfOfeUrl);
                Url _tmp_1 = this$0.__sharedConverters.toUrl(_tmp);
                if (_tmp_1 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.".toString());
                }
                _tmpOfeUrl = _tmp_1;
                long _tmpOfeUrlHash = 0L;
                _tmpOfeUrlHash = _stmt.getLong(_columnIndexOfOfeUrlHash);
                long _tmpOfeLastModifiedHeader = 0L;
                _tmpOfeLastModifiedHeader = _stmt.getLong(_columnIndexOfOfeLastModifiedHeader);
                String _tmpOfeEtag = null;
                _tmpOfeEtag = _stmt.isNull(_columnIndexOfOfeEtag) ? null : _stmt.getText(_columnIndexOfOfeEtag);
                _result = new OpdsFeedEntity(_tmpOfeUid, _tmpOfeUrl, _tmpOfeUrlHash, _tmpOfeLastModifiedHeader, _tmpOfeEtag);
            } else {
                _result = null;
            }
            opdsFeedEntity = _result;
        }
        return opdsFeedEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LastModifiedAndETagDb getLastModifiedAndETag$lambda$0(String $_sql, long $urlHash, SQLiteConnection _connection) {
        LastModifiedAndETagDb lastModifiedAndETagDb;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $urlHash);
            int _columnIndexOfLastModified = 0;
            int _columnIndexOfEtag = 1;
            LastModifiedAndETagDb _result = null;
            if (_stmt.step()) {
                long _tmpLastModified = 0L;
                _tmpLastModified = _stmt.getLong(_columnIndexOfLastModified);
                String _tmpEtag = null;
                _tmpEtag = _stmt.isNull(_columnIndexOfEtag) ? null : _stmt.getText(_columnIndexOfEtag);
                _result = new LastModifiedAndETagDb(_tmpLastModified, _tmpEtag);
            } else {
                _result = null;
            }
            lastModifiedAndETagDb = _result;
        }
        return lastModifiedAndETagDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit deleteByFeedUid$lambda$0(String $_sql, long $feedUid, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $feedUid);
            _stmt.step();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lworld/respect/datalayer/db/opds/daos/OpdsFeedEntityDao_Impl$Companion;", "", "<init>", "()V", "getRequiredConverters", "", "Lkotlin/reflect/KClass;", "respect-datalayer-db_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

