package world.respect.datalayer.db.schooldirectory.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import world.respect.datalayer.db.schooldirectory.entities.SchoolConfigEntity

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class SchoolConfigEntityDao_Impl(
  __db: RoomDatabase,
) : SchoolConfigEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfSchoolConfigEntity: EntityInsertAdapter<SchoolConfigEntity>
  init {
    this.__db = __db
    this.__insertAdapterOfSchoolConfigEntity = object : EntityInsertAdapter<SchoolConfigEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `SchoolConfigEntity` (`rcUid`,`dbUrl`) VALUES (?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: SchoolConfigEntity) {
        statement.bindLong(1, entity.rcUid)
        statement.bindText(2, entity.dbUrl)
      }
    }
  }

  public override suspend fun upsert(schoolConfigEntity: SchoolConfigEntity): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfSchoolConfigEntity.insert(_connection, schoolConfigEntity)
  }

  public override suspend fun findByUid(uid: Long): SchoolConfigEntity? {
    val _sql: String = """
        |
        |        SELECT SchoolConfigEntity.*
        |          FROM SchoolConfigEntity
        |         WHERE SchoolConfigEntity.rcUid = ? 
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uid)
        val _columnIndexOfRcUid: Int = getColumnIndexOrThrow(_stmt, "rcUid")
        val _columnIndexOfDbUrl: Int = getColumnIndexOrThrow(_stmt, "dbUrl")
        val _result: SchoolConfigEntity?
        if (_stmt.step()) {
          val _tmpRcUid: Long
          _tmpRcUid = _stmt.getLong(_columnIndexOfRcUid)
          val _tmpDbUrl: String
          _tmpDbUrl = _stmt.getText(_columnIndexOfDbUrl)
          _result = SchoolConfigEntity(_tmpRcUid,_tmpDbUrl)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
