package com.ustadmobile.libcache.db.dao

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import com.ustadmobile.libcache.db.entities.RequestedEntry
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class RequestedEntryDao_Impl(
  __db: RoomDatabase,
) : RequestedEntryDao() {
  private val __db: RoomDatabase

  private val __insertAdapterOfRequestedEntry: EntityInsertAdapter<RequestedEntry>
  init {
    this.__db = __db
    this.__insertAdapterOfRequestedEntry = object : EntityInsertAdapter<RequestedEntry>() {
      protected override fun createQuery(): String = "INSERT OR ABORT INTO `RequestedEntry` (`id`,`requestSha256`,`requestedKey`,`batchId`) VALUES (nullif(?, 0),?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RequestedEntry) {
        statement.bindLong(1, entity.id.toLong())
        statement.bindText(2, entity.requestSha256)
        statement.bindText(3, entity.requestedKey)
        statement.bindLong(4, entity.batchId.toLong())
      }
    }
  }

  public override suspend fun insertList(requestedSha256s: List<RequestedEntry>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRequestedEntry.insert(_connection, requestedSha256s)
  }

  public override suspend fun insertListAsync(requestedSha256s: List<RequestedEntry>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRequestedEntry.insert(_connection, requestedSha256s)
  }

  public override suspend fun findKeysNotPresent(batchId: Int): List<String> {
    val _sql: String = """
        |
        |        SELECT RequestedEntry.requestedKey
        |          FROM RequestedEntry
        |         WHERE RequestedEntry.batchId = ? 
        |           AND NOT EXISTS(
        |               SELECT CacheEntry.key
        |                 FROM CacheEntry
        |                WHERE CacheEntry.key = RequestedEntry.requestedKey
        |           )
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, batchId.toLong())
        val _result: MutableList<String> = mutableListOf()
        while (_stmt.step()) {
          val _item: String
          _item = _stmt.getText(0)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteBatch(batchId: Int) {
    val _sql: String = """
        |
        |        DELETE FROM RequestedEntry
        |         WHERE RequestedEntry.batchId = ?    
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, batchId.toLong())
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
