/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.shadow;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.BrushKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasKt;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.CompositeShaderBrush;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapConfig;
import androidx.compose.ui.graphics.ImageBitmapKt;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.PaintingStyle;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.ShaderBrush;
import androidx.compose.ui.graphics.ShaderKt;
import androidx.compose.ui.graphics.SkiaBackedPaint_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.shadow.BlurKt;
import androidx.compose.ui.graphics.shadow.Blur_skikoKt;
import androidx.compose.ui.graphics.shadow.Shadow;
import androidx.compose.ui.graphics.shadow.ShadowRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.MaskFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002JQ\u0010\u001e\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010#\u001a\u00020$H\u0014\u00a2\u0006\u0004\b%\u0010&J/\u0010'\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020 H\u0002\u00a2\u0006\u0004\b*\u0010+J/\u0010'\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010,\u001a\u00020 2\u0006\u0010)\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b-\u0010.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Landroidx/compose/ui/graphics/shadow/DropShadowRenderer;", "Landroidx/compose/ui/graphics/shadow/ShadowRenderer;", "shadow", "Landroidx/compose/ui/graphics/shadow/Shadow;", "outline", "Landroidx/compose/ui/graphics/Outline;", "<init>", "(Landroidx/compose/ui/graphics/shadow/Shadow;Landroidx/compose/ui/graphics/Outline;)V", "getShadow", "()Landroidx/compose/ui/graphics/shadow/Shadow;", "paint", "Landroidx/compose/ui/graphics/Paint;", "shadowBitmap", "Landroidx/compose/ui/graphics/ImageBitmap;", "compositeShader", "Landroidx/compose/ui/graphics/CompositeShaderBrush;", "buildShadow", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "size", "Landroidx/compose/ui/geometry/Size;", "cornerRadius", "Landroidx/compose/ui/geometry/CornerRadius;", "path", "Landroidx/compose/ui/graphics/Path;", "buildShadow-_SMYjrA", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;JJLandroidx/compose/ui/graphics/Path;)V", "obtainCompositeBrush", "Landroidx/compose/ui/graphics/Brush;", "brush", "onDrawShadow", "alpha", "", "colorFilter", "Landroidx/compose/ui/graphics/ColorFilter;", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "onDrawShadow-MLmccfk", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;JJLandroidx/compose/ui/graphics/Path;FLandroidx/compose/ui/graphics/ColorFilter;Landroidx/compose/ui/graphics/Brush;I)V", "createOuterShadowBitmap", "radius", "spread", "createOuterShadowBitmap-Cqks5Fs", "(JLandroidx/compose/ui/graphics/Path;FF)Landroidx/compose/ui/graphics/ImageBitmap;", "shadowRadius", "createOuterShadowBitmap-D_oqF2M", "(JFFJ)Landroidx/compose/ui/graphics/ImageBitmap;", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nDropShadowPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DropShadowPainter.kt\nandroidx/compose/ui/graphics/shadow/DropShadowRenderer\n+ 2 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 6 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 7 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 8 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 9 CornerRadius.kt\nandroidx/compose/ui/geometry/CornerRadius\n*L\n1#1,304:1\n33#2:305\n33#2:313\n53#3,3:306\n53#3,3:314\n53#3,3:321\n60#3:325\n70#3:328\n60#3:331\n70#3:334\n60#3:337\n70#3:340\n1#4:309\n120#5,3:310\n124#5,3:317\n30#6:320\n57#7:324\n61#7:327\n57#7:330\n61#7:333\n22#8:326\n22#8:329\n22#8:332\n22#8:335\n22#8:338\n22#8:341\n48#9:336\n53#9:339\n*S KotlinDebug\n*F\n+ 1 DropShadowPainter.kt\nandroidx/compose/ui/graphics/shadow/DropShadowRenderer\n*L\n165#1:305\n200#1:313\n165#1:306,3\n200#1:314,3\n208#1:321,3\n224#1:325\n225#1:328\n274#1:331\n275#1:334\n289#1:337\n290#1:340\n197#1:310,3\n197#1:317,3\n208#1:320\n224#1:324\n225#1:327\n274#1:330\n275#1:333\n224#1:326\n225#1:329\n274#1:332\n275#1:335\n289#1:338\n290#1:341\n289#1:336\n290#1:339\n*E\n"})
public final class DropShadowRenderer
extends ShadowRenderer {
    @NotNull
    private final Shadow shadow;
    @NotNull
    private final Paint paint;
    @Nullable
    private ImageBitmap shadowBitmap;
    @Nullable
    private CompositeShaderBrush compositeShader;

    public DropShadowRenderer(@NotNull Shadow shadow, @NotNull Outline outline) {
        Intrinsics.checkNotNullParameter((Object)shadow, (String)"shadow");
        Intrinsics.checkNotNullParameter((Object)outline, (String)"outline");
        super(outline);
        this.shadow = shadow;
        this.paint = SkiaBackedPaint_skikoKt.Paint();
    }

    @NotNull
    public final Shadow getShadow() {
        return this.shadow;
    }

    @Override
    protected void buildShadow-_SMYjrA(@NotNull DrawScope $this$buildShadow_u2d_SMYjrA, long size, long cornerRadius, @Nullable Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$buildShadow_u2d_SMYjrA, (String)"$this$buildShadow");
        float radius = $this$buildShadow_u2d_SMYjrA.toPx-0680j_4(this.shadow.getRadius-D9Ej5fM());
        float spread = $this$buildShadow_u2d_SMYjrA.toPx-0680j_4(this.shadow.getSpread-D9Ej5fM());
        this.shadowBitmap = path != null ? this.createOuterShadowBitmap-Cqks5Fs(size, path, radius, spread) : this.createOuterShadowBitmap-D_oqF2M(size, radius, spread, cornerRadius);
    }

    /*
     * WARNING - void declaration
     */
    private final Brush obtainCompositeBrush(ImageBitmap shadowBitmap, Brush brush) {
        Brush shader = this.compositeShader;
        if (shader == null || !Intrinsics.areEqual((Object)shader.getSrcBrush(), (Object)brush)) {
            Brush brush2;
            Brush brush3 = BrushKt.ShaderBrush(ShaderKt.ImageShader-F49vj9s$default(shadowBitmap, 0, 0, 6, null));
            if (brush instanceof ShaderBrush) {
                void height$iv;
                void width$iv;
                float f = shadowBitmap.getWidth();
                float f2 = shadowBitmap.getHeight();
                boolean $i$f$Size = false;
                boolean $i$f$packFloats = false;
                long v1$iv$iv = Float.floatToRawIntBits((float)width$iv);
                long v2$iv$iv = Float.floatToRawIntBits((float)height$iv);
                brush2 = BrushKt.ShaderBrush(((ShaderBrush)brush).createShader-uvyYCjk(Size.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL))));
            } else {
                brush2 = brush;
            }
            Brush brush4 = Brush.Companion.composite-7EN7VTw(brush3, brush2, BlendMode.Companion.getSrcIn-0nO6VwU());
            Intrinsics.checkNotNull((Object)brush4, (String)"null cannot be cast to non-null type androidx.compose.ui.graphics.CompositeShaderBrush");
            Brush it = brush4 = (CompositeShaderBrush)brush4;
            boolean bl = false;
            this.compositeShader = it;
            shader = brush4;
        }
        return shader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void onDrawShadow-MLmccfk(@NotNull DrawScope $this$onDrawShadow_u2dMLmccfk, long size, long cornerRadius, @Nullable Path path, float alpha, @Nullable ColorFilter colorFilter, @Nullable Brush brush, int blendMode) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$onDrawShadow_u2dMLmccfk, (String)"$this$onDrawShadow");
            ImageBitmap imageBitmap = this.shadowBitmap;
            if (imageBitmap == null) break block5;
            ImageBitmap shadowBitmap = imageBitmap;
            boolean bl = false;
            float offset = -($this$onDrawShadow_u2dMLmccfk.toPx-0680j_4(this.shadow.getRadius-D9Ej5fM()) + $this$onDrawShadow_u2dMLmccfk.toPx-0680j_4(this.shadow.getSpread-D9Ej5fM()));
            if (brush != null && colorFilter == null) {
                Brush shaderBrush = this.obtainCompositeBrush(shadowBitmap, brush);
                DrawScope $this$translate$iv = $this$onDrawShadow_u2dMLmccfk;
                boolean $i$f$translate = false;
                $this$translate$iv.getDrawContext().getTransform().translate(offset, offset);
                try {
                    void width$iv;
                    DrawScope $this$onDrawShadow_MLmccfk_u24lambda_u242_u24lambda_u241 = $this$translate$iv;
                    boolean bl2 = false;
                    float f = shadowBitmap.getWidth();
                    float height$iv = shadowBitmap.getHeight();
                    boolean $i$f$Size = false;
                    boolean $i$f$packFloats = false;
                    long v1$iv$iv = Float.floatToRawIntBits((float)width$iv);
                    long v2$iv$iv = Float.floatToRawIntBits(height$iv);
                    DrawScope.drawRect-AsUm42w$default($this$onDrawShadow_MLmccfk_u24lambda_u242_u24lambda_u241, shaderBrush, 0L, Size.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)), alpha, null, null, blendMode, 50, null);
                }
                finally {
                    $this$translate$iv.getDrawContext().getTransform().translate(-offset, -offset);
                }
            } else {
                boolean $i$f$Offset = false;
                boolean $i$f$packFloats = false;
                long v1$iv$iv = Float.floatToRawIntBits(offset);
                long v2$iv$iv = Float.floatToRawIntBits(offset);
                DrawScope.drawImage-gbVJVH8$default($this$onDrawShadow_u2dMLmccfk, shadowBitmap, Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)), alpha, null, colorFilter, blendMode, 8, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ImageBitmap createOuterShadowBitmap-Cqks5Fs(long size, Path path, float radius, float spread) {
        Canvas shadowCanvas;
        float outset = radius * (float)2 + spread * (float)2;
        boolean bl = false;
        long value$iv$iv = size;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float shadowWidth = Float.intBitsToFloat(bits$iv$iv$iv) + outset;
        boolean bl2 = false;
        long value$iv$iv2 = size;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        int $i$f$floatFromBits22 = 0;
        float shadowHeight = Float.intBitsToFloat(bits$iv$iv$iv2) + outset;
        ImageBitmap shadowBitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default((int)Math.ceil(shadowWidth), (int)Math.ceil(shadowHeight), ImageBitmapConfig.Companion.getAlpha8-_sVssgQ(), false, null, 24, null);
        Canvas $this$createOuterShadowBitmap_Cqks5Fs_u24lambda_u244 = shadowCanvas = CanvasKt.Canvas(shadowBitmap);
        boolean bl3 = false;
        if (spread > 0.0f) {
            void $this$createOuterShadowBitmap_Cqks5Fs_u24lambda_u244_u24lambda_u243;
            $this$createOuterShadowBitmap_Cqks5Fs_u24lambda_u244.translate(radius + spread, radius + spread);
            $this$createOuterShadowBitmap_Cqks5Fs_u24lambda_u244.drawPath(path, this.paint);
            Paint paint = this.paint;
            $i$f$floatFromBits22 = PaintingStyle.Companion.getStroke-TiuSbCo();
            MaskFilter maskFilter = radius > 0.0f ? Blur_skikoKt.BlurFilter(radius) : null;
            Paint $i$f$floatFromBits22 = paint = BlurKt.configureShadow-FoewPVk$default(paint, 0L, 0, maskFilter, $i$f$floatFromBits22, 3, null);
            Path path2 = path;
            Canvas canvas = $this$createOuterShadowBitmap_Cqks5Fs_u24lambda_u244;
            boolean bl4 = false;
            $this$createOuterShadowBitmap_Cqks5Fs_u24lambda_u244_u24lambda_u243.setStrokeWidth(spread * 2.0f);
            Unit unit = Unit.INSTANCE;
            canvas.drawPath(path2, paint);
        } else {
            BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, 0, radius > 0.0f ? Blur_skikoKt.BlurFilter(radius) : null, 0, 11, null);
            $this$createOuterShadowBitmap_Cqks5Fs_u24lambda_u244.translate(radius, radius);
            $this$createOuterShadowBitmap_Cqks5Fs_u24lambda_u244.drawPath(path, this.paint);
        }
        return shadowBitmap;
    }

    private final ImageBitmap createOuterShadowBitmap-D_oqF2M(long size, float shadowRadius, float spread, long cornerRadius) {
        Canvas shadowCanvas;
        float outset = shadowRadius * (float)2 + spread * (float)2;
        boolean bl = false;
        long value$iv$iv = size;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float shadowWidth = Float.intBitsToFloat(bits$iv$iv$iv) + outset;
        boolean bl2 = false;
        long value$iv$iv2 = size;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        float shadowHeight = Float.intBitsToFloat(bits$iv$iv$iv2) + outset;
        ImageBitmap shadowBitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default((int)Math.ceil(shadowWidth), (int)Math.ceil(shadowHeight), ImageBitmapConfig.Companion.getAlpha8-_sVssgQ(), false, null, 24, null);
        Canvas $this$createOuterShadowBitmap_D_oqF2M_u24lambda_u245 = shadowCanvas = CanvasKt.Canvas(shadowBitmap);
        boolean bl3 = false;
        boolean bl4 = false;
        long value$iv$iv3 = cornerRadius;
        boolean $i$f$unpackFloat12 = false;
        int bits$iv$iv$iv3 = (int)(value$iv$iv3 >> 32);
        boolean $i$f$floatFromBits3 = false;
        float f = Float.intBitsToFloat(bits$iv$iv$iv3);
        boolean bl5 = false;
        value$iv$iv3 = cornerRadius;
        boolean $i$f$unpackFloat22 = false;
        bits$iv$iv$iv3 = (int)(value$iv$iv3 & 0xFFFFFFFFL);
        $i$f$floatFromBits3 = false;
        $this$createOuterShadowBitmap_D_oqF2M_u24lambda_u245.drawRoundRect(shadowRadius, shadowRadius, shadowWidth - shadowRadius, shadowHeight - shadowRadius, f, Float.intBitsToFloat(bits$iv$iv$iv3), BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, 0, shadowRadius > 0.0f ? Blur_skikoKt.BlurFilter(shadowRadius) : null, 0, 11, null));
        return shadowBitmap;
    }
}

