/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.metadata.source;

import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.internal.GeoEntityUtility;
import com.google.i18n.phonenumbers.metadata.source.MapBackedMetadataContainer;
import com.google.i18n.phonenumbers.metadata.source.MetadataContainer;

final class CompositeMetadataContainer
implements MetadataContainer {
    private final MapBackedMetadataContainer<Integer> metadataByCountryCode = MapBackedMetadataContainer.byCountryCallingCode();
    private final MapBackedMetadataContainer<String> metadataByRegionCode = MapBackedMetadataContainer.byRegionCode();

    CompositeMetadataContainer() {
    }

    Phonemetadata.PhoneMetadata getMetadataBy(String regionCode) {
        return this.metadataByRegionCode.getMetadataBy(regionCode);
    }

    Phonemetadata.PhoneMetadata getMetadataBy(int countryCallingCode) {
        return this.metadataByCountryCode.getMetadataBy(countryCallingCode);
    }

    @Override
    public void accept(Phonemetadata.PhoneMetadata phoneMetadata) {
        String regionCode = this.metadataByRegionCode.getKeyProvider().getKeyOf(phoneMetadata);
        if (GeoEntityUtility.isGeoEntity(regionCode)) {
            this.metadataByRegionCode.accept(phoneMetadata);
        } else {
            this.metadataByCountryCode.accept(phoneMetadata);
        }
    }
}

