/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.webview;

import android.util.Log;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.ustadmobile.libcache.okhttp.ResponseExtKt;
import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HttpStatusCode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0003\u0012\u0013\u0014B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0017J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/ustadmobile/libcache/webview/OkHttpWebViewClient;", "Landroid/webkit/WebViewClient;", "shouldInterceptRequestFilter", "Lcom/ustadmobile/libcache/webview/OkHttpWebViewClient$ShouldInterceptRequestFilter;", "okHttpClient", "Lokhttp3/OkHttpClient;", "<init>", "(Lcom/ustadmobile/libcache/webview/OkHttpWebViewClient$ShouldInterceptRequestFilter;Lokhttp3/OkHttpClient;)V", "shouldInterceptRequest", "Landroid/webkit/WebResourceResponse;", "view", "Landroid/webkit/WebView;", "request", "Landroid/webkit/WebResourceRequest;", "shouldOverrideUrlLoading", "", "url", "", "ShouldInterceptRequestFilter", "DefaultShouldInterceptRequestFilter", "Companion", "respect-lib-cache_debug"})
@SourceDebugExtension(value={"SMAP\nOkHttpWebViewClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpWebViewClient.kt\ncom/ustadmobile/libcache/webview/OkHttpWebViewClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1869#2,2:157\n1193#2,2:160\n1267#2,2:162\n295#2,2:164\n1270#2:166\n1#3:159\n*S KotlinDebug\n*F\n+ 1 OkHttpWebViewClient.kt\ncom/ustadmobile/libcache/webview/OkHttpWebViewClient\n*L\n59#1:157,2\n81#1:160,2\n81#1:162,2\n82#1:164,2\n81#1:166\n*E\n"})
public final class OkHttpWebViewClient
extends WebViewClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ShouldInterceptRequestFilter shouldInterceptRequestFilter;
    @NotNull
    private final OkHttpClient okHttpClient;
    @NotNull
    private static final List<String> DEFAULT_DONT_INTERCEPT_HOSTS;
    @NotNull
    private static final List<String> RESERVED_HEADERS;

    public OkHttpWebViewClient(@NotNull ShouldInterceptRequestFilter shouldInterceptRequestFilter, @NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)shouldInterceptRequestFilter, (String)"shouldInterceptRequestFilter");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        this.shouldInterceptRequestFilter = shouldInterceptRequestFilter;
        this.okHttpClient = okHttpClient;
    }

    public /* synthetic */ OkHttpWebViewClient(ShouldInterceptRequestFilter shouldInterceptRequestFilter, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            shouldInterceptRequestFilter = new DefaultShouldInterceptRequestFilter();
        }
        this(shouldInterceptRequestFilter, okHttpClient);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public WebResourceResponse shouldInterceptRequest(@Nullable WebView view, @Nullable WebResourceRequest request) {
        if (request != null && this.shouldInterceptRequestFilter.shouldIntercept(request)) {
            try {
                void $this$associateTo$iv$iv;
                Map.Entry it;
                void $this$shouldInterceptRequest_u24lambda_u240;
                Request.Builder builder;
                Request.Builder builder2 = new Request.Builder();
                String string = request.getUrl().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                Request.Builder builder3 = builder = builder2.url(string);
                OkHttpClient okHttpClient = this.okHttpClient;
                boolean bl = false;
                String string2 = request.getMethod();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMethod(...)");
                $this$shouldInterceptRequest_u24lambda_u240.method(string2, null);
                Iterable $this$forEach$iv = request.getRequestHeaders().entrySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    Object k = it.getKey();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                    String string3 = (String)k;
                    Object v = it.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                    $this$shouldInterceptRequest_u24lambda_u240.header(string3, (String)v);
                }
                Response response = okHttpClient.newCall(builder.build()).execute();
                HttpStatusCode httpStatusCode = HttpStatusCode.Companion.fromValue(response.code());
                long contentLength = ResponseExtKt.headersContentLength(response);
                String string4 = Response.header$default((Response)response, (String)"content-type", null, (int)2, null);
                if (string4 == null) {
                    string4 = "application/octet-stream";
                }
                ContentType contentType = ContentType.Companion.parse(string4);
                String mimeType = contentType.getContentType() + "/" + contentType.getContentSubtype();
                Log.d((String)"UstadCacheWebViewClient", (String)("Intercept " + request.getUrl() + " (" + response.code() + " " + httpStatusCode.getDescription() + ") " + mimeType + " (charset=" + ContentTypesKt.charset((HeaderValueWithParameters)((HeaderValueWithParameters)contentType)) + ") " + contentLength + " bytes"));
                Map.Entry it2 = it = response;
                boolean bl3 = false;
                Map.Entry entry = HttpHeaders.promisesBody((Response)it2) ? it : null;
                ResponseBody responseBody = entry != null ? entry.body() : null;
                Iterable $this$associate$iv = response.headers().names();
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    String modHeaderName;
                    String string5;
                    Object v8;
                    String headerName;
                    Map map;
                    block9: {
                        map = destination$iv$iv;
                        headerName = (String)element$iv$iv;
                        boolean bl4 = false;
                        Iterable $this$firstOrNull$iv = RESERVED_HEADERS;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            String it3 = (String)element$iv;
                            boolean bl5 = false;
                            if (!StringsKt.equals((String)it3, (String)headerName, (boolean)true)) continue;
                            v8 = element$iv;
                            break block9;
                        }
                        v8 = null;
                    }
                    if ((string5 = (modHeaderName = (String)v8)) == null) {
                        string5 = headerName;
                    }
                    String string6 = Response.header$default((Response)response, (String)headerName, null, (int)2, null);
                    Intrinsics.checkNotNull((Object)string6);
                    Pair pair = TuplesKt.to((Object)string5, (Object)string6);
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map responseHeaders2 = destination$iv$iv;
                Charset charset = ContentTypesKt.charset((HeaderValueWithParameters)((HeaderValueWithParameters)contentType));
                String string7 = charset != null ? charset.name() : null;
                int n = response.code();
                String string8 = HttpStatusCode.Companion.fromValue(response.code()).getDescription();
                Object object = responseBody;
                if (object == null || (object = object.byteStream()) == null) {
                    object = new ByteArrayInputStream(new byte[0]);
                }
                return new WebResourceResponse(mimeType, string7, n, string8, responseHeaders2, (InputStream)object);
            }
            catch (Throwable e) {
                void $this$shouldInterceptRequest_u24lambda_u243;
                Log.w((String)"UstadWebViewClient", (String)"Error intercepting request", (Throwable)e);
                Object object = "OkHttpWebViewClient error: " + e.getMessage();
                byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] responseBytes = byArray;
                Object contentType = object = MapsKt.createMapBuilder();
                String string = "Service Unavailable";
                int n = 503;
                String string9 = "UTF-8";
                String string10 = "text/plain";
                boolean bl = false;
                $this$shouldInterceptRequest_u24lambda_u243.put("Content-Type", "text/plain");
                $this$shouldInterceptRequest_u24lambda_u243.put("Content-Length", String.valueOf(responseBytes.length));
                $this$shouldInterceptRequest_u24lambda_u243.put("Cache-Control", "no-cache, no-store, must-revalidate");
                Unit unit = Unit.INSTANCE;
                InputStream inputStream = new ByteArrayInputStream(responseBytes);
                Map map = MapsKt.build((Map)object);
                String string11 = string;
                int n2 = n;
                String string12 = string9;
                String string13 = string10;
                return new WebResourceResponse(string13, string12, n2, string11, map, inputStream);
            }
        }
        return null;
    }

    @Deprecated(message="Deprecated in Java")
    public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable String url) {
        return false;
    }

    public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable WebResourceRequest request) {
        return false;
    }

    static {
        Object[] objectArray = new String[]{"localhost", "127.0.0.1"};
        DEFAULT_DONT_INTERCEPT_HOSTS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"Content-Type", "Content-Length", "Content-Encoding"};
        RESERVED_HEADERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/ustadmobile/libcache/webview/OkHttpWebViewClient$Companion;", "", "<init>", "()V", "DEFAULT_DONT_INTERCEPT_HOSTS", "", "", "getDEFAULT_DONT_INTERCEPT_HOSTS", "()Ljava/util/List;", "RESERVED_HEADERS", "getRESERVED_HEADERS", "respect-lib-cache_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getDEFAULT_DONT_INTERCEPT_HOSTS() {
            return DEFAULT_DONT_INTERCEPT_HOSTS;
        }

        @NotNull
        public final List<String> getRESERVED_HEADERS() {
            return RESERVED_HEADERS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/ustadmobile/libcache/webview/OkHttpWebViewClient$DefaultShouldInterceptRequestFilter;", "Lcom/ustadmobile/libcache/webview/OkHttpWebViewClient$ShouldInterceptRequestFilter;", "<init>", "()V", "shouldIntercept", "", "request", "Landroid/webkit/WebResourceRequest;", "respect-lib-cache_debug"})
    @SourceDebugExtension(value={"SMAP\nOkHttpWebViewClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpWebViewClient.kt\ncom/ustadmobile/libcache/webview/OkHttpWebViewClient$DefaultShouldInterceptRequestFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
    public static final class DefaultShouldInterceptRequestFilter
    implements ShouldInterceptRequestFilter {
        @Override
        public boolean shouldIntercept(@NotNull WebResourceRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            String string = request.getMethod();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethod(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            String it = string2;
            boolean bl = false;
            boolean bl2 = !Intrinsics.areEqual((Object)it, (Object)"GET") && !Intrinsics.areEqual((Object)it, (Object)"HEAD");
            if (bl2) {
                return false;
            }
            it = request.getUrl().getHost();
            boolean bl3 = false;
            return !CollectionsKt.contains((Iterable)Companion.getDEFAULT_DONT_INTERCEPT_HOSTS(), (Object)it);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/ustadmobile/libcache/webview/OkHttpWebViewClient$ShouldInterceptRequestFilter;", "", "shouldIntercept", "", "request", "Landroid/webkit/WebResourceRequest;", "respect-lib-cache_debug"})
    public static interface ShouldInterceptRequestFilter {
        public boolean shouldIntercept(@NotNull WebResourceRequest var1);
    }
}

