/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1.type;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.apache.kerby.asn1.UniversalTag;
import org.apache.kerby.asn1.type.Asn1Simple;

public class Asn1GeneralizedTime
extends Asn1Simple<Date> {
    public Asn1GeneralizedTime() {
        this((Date)null);
    }

    public Asn1GeneralizedTime(long time2) {
        super(UniversalTag.GENERALIZED_TIME, new Date(time2));
    }

    public Asn1GeneralizedTime(Date date) {
        super(UniversalTag.GENERALIZED_TIME, date);
    }

    @Override
    protected void toValue() throws IOException {
        SimpleDateFormat sdf;
        String dateStr;
        String fixedDateStr = dateStr = new String(this.getBytes(), StandardCharsets.US_ASCII);
        boolean withZ = dateStr.endsWith("Z");
        String timeZonePart = this.getTimeZonePart(dateStr);
        boolean withZone = timeZonePart != null;
        String millSecs = this.getMillSeconds(dateStr);
        fixedDateStr = dateStr.substring(0, 14) + millSecs;
        if (withZ) {
            sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.US);
            sdf.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else if (withZone) {
            fixedDateStr = fixedDateStr + timeZonePart;
            sdf = new SimpleDateFormat("yyyyMMddHHmmssSSSz", Locale.US);
            sdf.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else {
            sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.US);
            sdf.setTimeZone(new SimpleTimeZone(0, TimeZone.getDefault().getID()));
        }
        try {
            this.setValue(sdf.parse(fixedDateStr));
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse as generalized time string " + dateStr);
        }
    }

    @Override
    protected void toBytes() {
        Date date = (Date)this.getValue();
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmss'Z'", Locale.US);
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        String str2 = dateF.format(date);
        byte[] bytes = str2.getBytes(StandardCharsets.US_ASCII);
        this.setBytes(bytes);
    }

    private String getMillSeconds(String dateStr) {
        char[] millDigits = new char[]{'0', '0', '0'};
        int iPos = dateStr.indexOf(46);
        if (iPos > 0) {
            char chr;
            if (iPos != 14) {
                throw new IllegalArgumentException("Bad generalized time string, with improper milli seconds " + dateStr);
            }
            int j = 0;
            for (int i2 = 15; i2 < dateStr.length() && j < millDigits.length && '0' <= (chr = dateStr.charAt(i2)) && chr <= '9'; ++i2) {
                millDigits[j++] = chr;
            }
        }
        return new String(millDigits);
    }

    private String getTimeZonePart(String dateStr) {
        int iPos = dateStr.indexOf(43);
        if (iPos == -1) {
            iPos = dateStr.indexOf(45);
        }
        if (iPos > 0 && iPos != dateStr.length() - 5) {
            throw new IllegalArgumentException("Bad generalized time string, with improper timezone part " + dateStr);
        }
        if (iPos > 0) {
            return dateStr.substring(iPos);
        }
        return null;
    }
}

