/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.spatial;

import androidx.collection.IntObjectMap;
import androidx.collection.IntObjectMapKt;
import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Actual_jvmKt;
import androidx.compose.ui.Actuals_skikoKt;
import androidx.compose.ui.ComposeUiFlags;
import androidx.compose.ui.geometry.MutableRect;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.MatrixKt;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.MeasurePassDelegate;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.node.OwnedLayer;
import androidx.compose.ui.spatial.RectList;
import androidx.compose.ui.spatial.RectManagerKt;
import androidx.compose.ui.spatial.RelativeLayoutBounds;
import androidx.compose.ui.spatial.ThrottledCallbacks;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntOffsetKt;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0019\u001a\u00020\u0010J5\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J\u0006\u0010%\u001a\u00020\u0010J\u000e\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0012J\u0016\u0010(\u001a\u0004\u0018\u00010\u00012\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ:\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u0002002\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u001001J:\u00103\u001a\u00020+2\u0006\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u0002002\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u001001J\u0010\u00104\u001a\u00020\u00102\b\u00105\u001a\u0004\u0018\u00010\u0001J\u000e\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0004J\u001e\u00108\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u0012J\u000e\u0010;\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0004J\u0016\u0010<\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0012J\u0010\u0010>\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0004H\u0002J\u0010\u0010?\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0004H\u0002J\u0018\u0010B\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0012H\u0002J8\u0010C\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u00122\u0006\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u00020!2\u0006\u0010F\u001a\u00020!2\u0006\u0010G\u001a\u00020!H\u0002J\u0014\u0010H\u001a\u00020\u0010*\u00020I2\u0006\u0010J\u001a\u00020AH\u0002J\u0013\u0010K\u001a\u00020\u001c*\u00020\u0004H\u0002\u00a2\u0006\u0004\bL\u0010MJ\u000e\u0010N\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0004J\u001d\u0010O\u001a\u00020\u00122\u0006\u0010P\u001a\u00020!2\u0006\u0010Q\u001a\u00020!H\u0000\u00a2\u0006\u0002\bRR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Landroidx/compose/ui/spatial/RectManager;", "", "layoutNodes", "Landroidx/collection/IntObjectMap;", "Landroidx/compose/ui/node/LayoutNode;", "<init>", "(Landroidx/collection/IntObjectMap;)V", "rects", "Landroidx/compose/ui/spatial/RectList;", "getRects", "()Landroidx/compose/ui/spatial/RectList;", "throttledCallbacks", "Landroidx/compose/ui/spatial/ThrottledCallbacks;", "callbacks", "Landroidx/collection/MutableObjectList;", "Lkotlin/Function0;", "", "isDirty", "", "isScreenOrWindowDirty", "isFragmented", "dispatchToken", "scheduledDispatchDeadline", "", "dispatchLambda", "invalidate", "updateOffsets", "screenOffset", "Landroidx/compose/ui/unit/IntOffset;", "windowOffset", "viewToWindowMatrix", "Landroidx/compose/ui/graphics/Matrix;", "windowWidth", "", "windowHeight", "updateOffsets-gTq6Wqs", "(JJ[FII)V", "dispatchCallbacks", "scheduleDebounceCallback", "ensureSomethingScheduled", "registerOnChangedCallback", "callback", "registerOnRectChangedCallback", "Landroidx/compose/ui/node/DelegatableNode$RegistrationHandle;", "id", "throttleMillis", "debounceMillis", "node", "Landroidx/compose/ui/node/DelegatableNode;", "Lkotlin/Function1;", "Landroidx/compose/ui/spatial/RelativeLayoutBounds;", "registerOnGlobalLayoutCallback", "unregisterOnChangedCallback", "token", "invalidateCallbacksFor", "layoutNode", "updateFlagsFor", "focusable", "gesturable", "onLayoutLayerPositionalPropertiesChanged", "onLayoutPositionChanged", "firstPlacement", "recalculateOffsetFromRoot", "insertOrUpdateTransformedNodeSubhierarchy", "cachedRect", "Landroidx/compose/ui/geometry/MutableRect;", "insertOrUpdateTransformedNode", "insertOrUpdate", "l", "t", "r", "b", "boundingRectInRoot", "Landroidx/compose/ui/node/NodeCoordinator;", "rect", "outerToInnerOffset", "outerToInnerOffset-Bjo55l4", "(Landroidx/compose/ui/node/LayoutNode;)J", "remove", "isTargetDrawnFirst", "targetId", "otherId", "isTargetDrawnFirst$ui", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRectManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RectManager.kt\nandroidx/compose/ui/spatial/RectManager\n+ 2 ObjectList.kt\nandroidx/collection/ObjectListKt\n+ 3 RectManager.kt\nandroidx/compose/ui/spatial/RectManagerKt\n+ 4 ObjectList.kt\nandroidx/collection/ObjectList\n+ 5 RectList.kt\nandroidx/compose/ui/spatial/RectList\n+ 6 RectList.kt\nandroidx/compose/ui/spatial/RectListKt\n+ 7 ThrottledCallbacks.kt\nandroidx/compose/ui/spatial/ThrottledCallbacks\n+ 8 IntObjectMap.kt\nandroidx/collection/IntObjectMap\n+ 9 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 10 LayoutNode.kt\nandroidx/compose/ui/node/LayoutNode\n+ 11 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 12 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 13 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 14 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 15 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n+ 16 IntOffset.kt\nandroidx/compose/ui/unit/IntOffsetKt\n+ 17 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 18 Trace.desktop.kt\nandroidx/compose/ui/util/Trace_jbKt__Trace_desktopKt\n*L\n1#1,527:1\n1516#2:528\n524#3:529\n520#3:617\n524#3:618\n287#4,6:530\n779#5,7:536\n786#5,3:544\n790#5,3:548\n891#6:543\n860#6:547\n191#7:551\n192#7,8:568\n200#7:583\n397#8,3:552\n354#8,6:555\n364#8,3:562\n367#8,2:566\n370#8,6:576\n400#8:582\n1399#9:561\n1270#9:565\n207#10:584\n207#10:599\n424#11,8:585\n424#11,8:600\n54#12:593\n59#12:595\n85#13:594\n90#13:596\n80#13:598\n53#13,3:614\n30#14:597\n118#15:608\n94#15:609\n118#15:610\n94#15:611\n159#16:612\n30#17:613\n23#18:619\n*S KotlinDebug\n*F\n+ 1 RectManager.kt\nandroidx/compose/ui/spatial/RectManager\n*L\n51#1:528\n78#1:529\n405#1:617\n406#1:618\n95#1:530,6\n96#1:536,7\n96#1:544,3\n96#1:548,3\n96#1:543\n96#1:547\n99#1:551\n99#1:568,8\n99#1:583\n99#1:552,3\n99#1:555,6\n99#1:562,3\n99#1:566,2\n99#1:576,6\n99#1:582\n99#1:561\n99#1:565\n216#1:584\n310#1:599\n216#1:585,8\n310#1:600,8\n245#1:593\n246#1:595\n245#1:594\n246#1:596\n258#1:598\n382#1:614,3\n258#1:597\n345#1:608\n346#1:609\n370#1:610\n371#1:611\n382#1:612\n382#1:613\n59#1:619\n*E\n"})
public final class RectManager {
    @NotNull
    private final IntObjectMap<LayoutNode> layoutNodes;
    @NotNull
    private final RectList rects;
    @NotNull
    private final ThrottledCallbacks throttledCallbacks;
    @NotNull
    private final MutableObjectList<Function0<Unit>> callbacks;
    private boolean isDirty;
    private boolean isScreenOrWindowDirty;
    private boolean isFragmented;
    @Nullable
    private Object dispatchToken;
    private long scheduledDispatchDeadline;
    @NotNull
    private final Function0<Unit> dispatchLambda;
    @NotNull
    private final MutableRect cachedRect;
    public static final int $stable = 8;

    public RectManager(@NotNull IntObjectMap<LayoutNode> layoutNodes) {
        Intrinsics.checkNotNullParameter(layoutNodes, (String)"layoutNodes");
        this.layoutNodes = layoutNodes;
        this.rects = new RectList();
        this.throttledCallbacks = new ThrottledCallbacks();
        boolean $i$f$mutableObjectListOf = false;
        this.callbacks = new MutableObjectList(0, 1, null);
        this.scheduledDispatchDeadline = -1L;
        this.dispatchLambda = () -> RectManager.dispatchLambda$lambda$1(this);
        this.cachedRect = new MutableRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public /* synthetic */ RectManager(IntObjectMap intObjectMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            intObjectMap = IntObjectMapKt.intObjectMapOf();
        }
        this((IntObjectMap<LayoutNode>)intObjectMap);
    }

    @NotNull
    public final RectList getRects() {
        return this.rects;
    }

    public final void invalidate() {
        this.isDirty = true;
    }

    public final void updateOffsets-gTq6Wqs(long screenOffset, long windowOffset, @NotNull float[] viewToWindowMatrix, int windowWidth, int windowHeight) {
        int analysis;
        Intrinsics.checkNotNullParameter((Object)viewToWindowMatrix, (String)"viewToWindowMatrix");
        int $this$hasNonTranslationComponents$iv = analysis = RectManagerKt.access$analyzeComponents-58bKbWc(viewToWindowMatrix);
        boolean $i$f$getHasNonTranslationComponents = false;
        this.isScreenOrWindowDirty = this.throttledCallbacks.updateOffsets-LDcG7Xg(screenOffset, windowOffset, (float[])(($this$hasNonTranslationComponents$iv & 2) == 0 ? viewToWindowMatrix : null), windowWidth, windowHeight) || this.isScreenOrWindowDirty;
    }

    /*
     * WARNING - void declaration
     */
    public final void dispatchCallbacks() {
        boolean isDispatchGlobalCallbacks;
        long currentTime = Actual_jvmKt.currentTimeMillis();
        boolean bl = isDispatchGlobalCallbacks = this.isDirty || this.isScreenOrWindowDirty;
        if (this.isDirty) {
            this.isDirty = false;
            Object this_$iv = (ObjectList)this.callbacks;
            boolean $i$f$forEach = false;
            Object[] content$iv = ((ObjectList)this_$iv).content;
            int n = ((ObjectList)this_$iv)._size;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                Function0 it = (Function0)content$iv[i$iv];
                boolean bl2 = false;
                it.invoke();
            }
            this_$iv = this.rects;
            boolean $i$f$forEachUpdatedRect = false;
            long[] items$iv = ((RectList)this_$iv).items;
            int size$iv = ((RectList)this_$iv).itemsSize;
            for (int i$iv = 0; i$iv < items$iv.length - 2 && i$iv < size$iv; i$iv += 3) {
                void bottomRight;
                void topLeft;
                long meta$iv = items$iv[i$iv + 2];
                boolean $i$f$unpackMetaUpdated = false;
                if (((int)(meta$iv >> 61) & 1) == 0) continue;
                long topLeft$iv = items$iv[i$iv + 0];
                long bottomRight$iv = items$iv[i$iv + 1];
                boolean $i$f$unpackMetaValue = false;
                long l = bottomRight$iv;
                long l2 = topLeft$iv;
                int id = (int)meta$iv & 0x3FFFFFF;
                boolean bl3 = false;
                this.throttledCallbacks.fireOnUpdatedRect(id, (long)topLeft, (long)bottomRight, currentTime);
            }
            this_$iv = this.throttledCallbacks;
            boolean $i$f$forEachNewCallbackNeverInvoked = false;
            IntObjectMap this_$iv$iv = (IntObjectMap)((ThrottledCallbacks)this_$iv).getRectChangedMap();
            boolean $i$f$forEachValue = false;
            Object[] v$iv$iv = this_$iv$iv.values;
            IntObjectMap this_$iv$iv$iv = this_$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int i$iv$iv$iv = 0;
            long[] m$iv$iv$iv = this_$iv$iv$iv.metadata;
            int lastIndex$iv$iv$iv = m$iv$iv$iv.length - 2;
            if (i$iv$iv$iv <= lastIndex$iv$iv$iv) {
                while (true) {
                    long slot$iv$iv$iv;
                    long $this$maskEmptyOrDeleted$iv$iv$iv$iv = slot$iv$iv$iv = m$iv$iv$iv[i$iv$iv$iv];
                    boolean $i$f$maskEmptyOrDeleted = false;
                    if (($this$maskEmptyOrDeleted$iv$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                        int bitCount$iv$iv$iv = 8 - (~(i$iv$iv$iv - lastIndex$iv$iv$iv) >>> 31);
                        for (int j$iv$iv$iv = 0; j$iv$iv$iv < bitCount$iv$iv$iv; ++j$iv$iv$iv) {
                            long value$iv$iv$iv$iv = slot$iv$iv$iv & 0xFFL;
                            boolean $i$f$isFull = false;
                            if (value$iv$iv$iv$iv < 128L) {
                                int index$iv$iv$iv;
                                int index$iv$iv = index$iv$iv$iv = (i$iv$iv$iv << 3) + j$iv$iv$iv;
                                boolean bl4 = false;
                                ThrottledCallbacks.Entry entry$iv = (ThrottledCallbacks.Entry)v$iv$iv[index$iv$iv];
                                boolean bl5 = false;
                                for (ThrottledCallbacks.Entry next$iv = entry$iv; next$iv != null; next$iv = next$iv.getNext()) {
                                    if (entry$iv.getLastInvokeMillis() != Long.MIN_VALUE) continue;
                                    ThrottledCallbacks.Entry entry = entry$iv;
                                    boolean bl6 = false;
                                    this.rects.withTopLeftBottomRight(entry.getId(), (Function2<? super Long, ? super Long, Unit>)((Function2)(arg_0, arg_1) -> RectManager.dispatchCallbacks$lambda$5$lambda$4(this, entry, currentTime, arg_0, arg_1)));
                                }
                            }
                            slot$iv$iv$iv >>= 8;
                        }
                        if (bitCount$iv$iv$iv != 8) break;
                    }
                    if (i$iv$iv$iv == lastIndex$iv$iv$iv) break;
                    ++i$iv$iv$iv;
                }
            }
            this.rects.clearUpdated();
        }
        if (this.isScreenOrWindowDirty) {
            this.isScreenOrWindowDirty = false;
            this.throttledCallbacks.fireOnRectChangedEntries(currentTime);
        }
        if (isDispatchGlobalCallbacks) {
            this.throttledCallbacks.fireGlobalChangeEntries(currentTime);
        }
        if (this.isFragmented) {
            this.isFragmented = false;
            this.rects.defragment();
        }
        this.throttledCallbacks.triggerDebounced(currentTime);
    }

    public final void scheduleDebounceCallback(boolean ensureSomethingScheduled) {
        long deadline;
        boolean canExitEarly = !ensureSomethingScheduled || this.dispatchToken != null;
        long nextDeadline = this.throttledCallbacks.getMinDebounceDeadline();
        if (nextDeadline < 0L && canExitEarly) {
            return;
        }
        long currentScheduledDeadline = this.scheduledDispatchDeadline;
        if (currentScheduledDeadline == nextDeadline && canExitEarly) {
            return;
        }
        if (this.dispatchToken != null) {
            Actuals_skikoKt.removePost(this.dispatchToken);
        }
        long currentTime = Actual_jvmKt.currentTimeMillis();
        long nextFrameIsh = currentTime + (long)16;
        this.scheduledDispatchDeadline = deadline = Math.max(nextDeadline, nextFrameIsh);
        long delay = deadline - currentTime;
        this.dispatchToken = Actuals_skikoKt.postDelayed(delay, this.dispatchLambda);
    }

    @Nullable
    public final Object registerOnChangedCallback(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callbacks.add(callback);
        return callback;
    }

    @NotNull
    public final DelegatableNode.RegistrationHandle registerOnRectChangedCallback(int id, long throttleMillis, long debounceMillis, @NotNull DelegatableNode node, @NotNull Function1<? super RelativeLayoutBounds, Unit> callback) {
        DelegatableNode.RegistrationHandle registrationHandle;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        DelegatableNode.RegistrationHandle it = registrationHandle = this.throttledCallbacks.registerOnRectChanged(id, throttleMillis, debounceMillis, node, callback);
        boolean bl = false;
        this.invalidate();
        this.scheduleDebounceCallback(true);
        return registrationHandle;
    }

    @NotNull
    public final DelegatableNode.RegistrationHandle registerOnGlobalLayoutCallback(int id, long throttleMillis, long debounceMillis, @NotNull DelegatableNode node, @NotNull Function1<? super RelativeLayoutBounds, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return this.throttledCallbacks.registerOnGlobalChange(id, throttleMillis, debounceMillis, node, callback);
    }

    public final void unregisterOnChangedCallback(@Nullable Object token) {
        if ((TypeIntrinsics.isFunctionOfArity((Object)token, (int)0) ? (Function0)token : null) == null) {
            return;
        }
        this.callbacks.remove(token);
    }

    public final void invalidateCallbacksFor(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        this.isDirty = true;
        this.rects.markUpdated(layoutNode.getSemanticsId());
        this.scheduleDebounceCallback(true);
    }

    public final void updateFlagsFor(@NotNull LayoutNode layoutNode, boolean focusable, boolean gesturable) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (layoutNode.isAttached()) {
            this.rects.updateFlagsFor(layoutNode.getSemanticsId(), focusable, gesturable);
        }
    }

    public final void onLayoutLayerPositionalPropertiesChanged(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (!ComposeUiFlags.isRectTrackingEnabled) {
            return;
        }
        long outerToInnerOffset = this.outerToInnerOffset-Bjo55l4(layoutNode);
        if (RectManagerKt.access$isSet--gyyYBs(outerToInnerOffset)) {
            layoutNode.setOuterToInnerOffset--gyyYBs$ui(outerToInnerOffset);
            layoutNode.setOuterToInnerOffsetDirty$ui(false);
            LayoutNode this_$iv = layoutNode;
            boolean $i$f$forEachChild = false;
            MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
            boolean $i$f$forEach = false;
            Object[] content$iv$iv = this_$iv$iv.content;
            int size$iv$iv = this_$iv$iv.getSize();
            for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
                LayoutNode it = (LayoutNode)content$iv$iv[i$iv$iv];
                boolean bl = false;
                this.onLayoutPositionChanged(it, false);
            }
            this.invalidateCallbacksFor(layoutNode);
        } else {
            this.insertOrUpdateTransformedNodeSubhierarchy(layoutNode);
        }
    }

    public final void onLayoutPositionChanged(@NotNull LayoutNode layoutNode, boolean firstPlacement) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (!ComposeUiFlags.isRectTrackingEnabled) {
            return;
        }
        MeasurePassDelegate delegate = layoutNode.getMeasurePassDelegate$ui();
        int width = delegate.getMeasuredWidth();
        int height = delegate.getMeasuredHeight();
        long lastOffset = layoutNode.getOffsetFromRoot-nOcc-ac$ui();
        long lastSize = layoutNode.getLastSize-YbymL2g$ui();
        boolean bl = false;
        long value$iv$iv = lastSize;
        boolean $i$f$unpackInt1 = false;
        int lastWidth = (int)(value$iv$iv >> 32);
        boolean bl2 = false;
        long value$iv$iv2 = lastSize;
        boolean $i$f$unpackInt2 = false;
        int lastHeight = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        this.recalculateOffsetFromRoot(layoutNode);
        long offset = layoutNode.getOffsetFromRoot-nOcc-ac$ui();
        if (!RectManagerKt.access$isSet--gyyYBs(offset)) {
            this.insertOrUpdateTransformedNode(layoutNode, firstPlacement);
            return;
        }
        boolean $i$f$IntSize = false;
        boolean $i$f$packInts = false;
        layoutNode.setLastSize-ozmzZPI$ui(IntSize.constructor-impl((long)((long)width << 32 | (long)height & 0xFFFFFFFFL)));
        int l = IntOffset.getX-impl((long)offset);
        int t = IntOffset.getY-impl((long)offset);
        int r = l + width;
        int b = t + height;
        if (!firstPlacement && IntOffset.equals-impl0((long)offset, (long)lastOffset) && lastWidth == width && lastHeight == height) {
            return;
        }
        this.insertOrUpdate(layoutNode, firstPlacement, l, t, r, b);
    }

    private final void recalculateOffsetFromRoot(LayoutNode layoutNode) {
        long l;
        long position = layoutNode.getOuterCoordinator$ui().getPosition-nOcc-ac();
        LayoutNode parent = layoutNode.getParent$ui();
        if (parent != null) {
            long parentOffset;
            if (!RectManagerKt.access$isSet--gyyYBs(parent.getOffsetFromRoot-nOcc-ac$ui())) {
                this.recalculateOffsetFromRoot(parent);
            }
            if (!RectManagerKt.access$isSet--gyyYBs(parentOffset = parent.getOffsetFromRoot-nOcc-ac$ui())) {
                l = IntOffset.Companion.getMax-nOcc-ac();
            } else {
                long parentOuterInnerOffset;
                long l2;
                if (parent.getOuterToInnerOffsetDirty$ui()) {
                    long it = this.outerToInnerOffset-Bjo55l4(parent);
                    parent.setOuterToInnerOffset--gyyYBs$ui(it);
                    parent.setOuterToInnerOffsetDirty$ui(false);
                    l2 = it;
                } else {
                    l2 = parentOuterInnerOffset = parent.getOuterToInnerOffset-nOcc-ac$ui();
                }
                l = !RectManagerKt.access$isSet--gyyYBs(parentOuterInnerOffset) ? IntOffset.Companion.getMax-nOcc-ac() : IntOffset.plus-qkQi6aY((long)IntOffset.plus-qkQi6aY((long)parentOffset, (long)parentOuterInnerOffset), (long)position);
            }
        } else {
            l = position;
        }
        layoutNode.setOffsetFromRoot--gyyYBs$ui(l);
    }

    private final void insertOrUpdateTransformedNodeSubhierarchy(LayoutNode layoutNode) {
        LayoutNode this_$iv = layoutNode;
        boolean $i$f$forEachChild = false;
        MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
        boolean $i$f$forEach = false;
        Object[] content$iv$iv = this_$iv$iv.content;
        int size$iv$iv = this_$iv$iv.getSize();
        for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
            LayoutNode it = (LayoutNode)content$iv$iv[i$iv$iv];
            boolean bl = false;
            this.insertOrUpdateTransformedNode(it, false);
            this.insertOrUpdateTransformedNodeSubhierarchy(it);
        }
    }

    private final void insertOrUpdateTransformedNode(LayoutNode layoutNode, boolean firstPlacement) {
        NodeCoordinator coord = layoutNode.getOuterCoordinator$ui();
        MeasurePassDelegate delegate = layoutNode.getMeasurePassDelegate$ui();
        int width = delegate.getMeasuredWidth();
        int height = delegate.getMeasuredHeight();
        MutableRect rect = this.cachedRect;
        rect.set(0.0f, 0.0f, (float)width, (float)height);
        this.boundingRectInRoot(coord, rect);
        int l = (int)rect.getLeft();
        int t = (int)rect.getTop();
        int r = (int)rect.getRight();
        int b = (int)rect.getBottom();
        int id = layoutNode.getSemanticsId();
        if (firstPlacement || !this.rects.update(id, l, t, r, b)) {
            LayoutNode layoutNode2 = layoutNode.getParent$ui();
            int parentId = layoutNode2 != null ? layoutNode2.getSemanticsId() : -1;
            boolean bl = false;
            boolean bl2 = false;
            this.rects.insert(id, l, t, r, b, parentId, layoutNode.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(1024)), layoutNode.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(16)));
        }
        this.invalidate();
    }

    private final void insertOrUpdate(LayoutNode layoutNode, boolean firstPlacement, int l, int t, int r, int b) {
        int id = layoutNode.getSemanticsId();
        if (firstPlacement || !this.rects.move(id, l, t, r, b)) {
            LayoutNode layoutNode2 = layoutNode.getParent$ui();
            int parentId = layoutNode2 != null ? layoutNode2.getSemanticsId() : -1;
            boolean bl = false;
            boolean bl2 = false;
            this.rects.insert(id, l, t, r, b, parentId, layoutNode.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(1024)), layoutNode.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(16)));
        }
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    private final void boundingRectInRoot(NodeCoordinator $this$boundingRectInRoot, MutableRect rect) {
        for (NodeCoordinator coordinator = $this$boundingRectInRoot; coordinator != null; coordinator = coordinator.getWrappedBy$ui()) {
            float[] matrix;
            void x$iv$iv;
            OwnedLayer layer = coordinator.getLayer();
            long $this$toOffset_u2d_u2dgyyYBs$iv = coordinator.getPosition-nOcc-ac();
            boolean bl = false;
            float f = IntOffset.getX-impl((long)$this$toOffset_u2d_u2dgyyYBs$iv);
            float y$iv$iv = IntOffset.getY-impl((long)$this$toOffset_u2d_u2dgyyYBs$iv);
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv$iv = Float.floatToRawIntBits((float)x$iv$iv);
            long v2$iv$iv$iv = Float.floatToRawIntBits(y$iv$iv);
            rect.translate-k-4lQ0M(Offset.constructor-impl((long)(v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL)));
            if (layer == null || MatrixKt.isIdentity-58bKbWc((float[])(matrix = layer.getUnderlyingMatrix-sQKQjiQ()))) continue;
            Matrix.map-impl((float[])matrix, (MutableRect)rect);
        }
    }

    private final long outerToInnerOffset-Bjo55l4(LayoutNode $this$outerToInnerOffset_u2dBjo55l4) {
        NodeCoordinator terminator = $this$outerToInnerOffset_u2dBjo55l4.getOuterCoordinator$ui();
        long position = Offset.Companion.getZero-F1C5BW0();
        for (NodeCoordinator coordinator = $this$outerToInnerOffset_u2dBjo55l4.getInnerCoordinator$ui(); coordinator != null && coordinator != terminator; coordinator = coordinator.getWrappedBy$ui()) {
            int analysis;
            OwnedLayer layer = coordinator.getLayer();
            position = IntOffsetKt.plus-Nv-tHpc((long)position, (long)coordinator.getPosition-nOcc-ac());
            if (layer == null) continue;
            float[] matrix = layer.getUnderlyingMatrix-sQKQjiQ();
            int $this$isIdentity$iv = analysis = RectManagerKt.access$analyzeComponents-58bKbWc(matrix);
            boolean $i$f$isIdentity = false;
            if ($this$isIdentity$iv == 3) continue;
            int $this$hasNonTranslationComponents$iv = analysis;
            boolean $i$f$getHasNonTranslationComponents = false;
            if (($this$hasNonTranslationComponents$iv & 2) == 0) {
                return IntOffset.Companion.getMax-nOcc-ac();
            }
            position = Matrix.map-MK-Hz9U((float[])matrix, (long)position);
        }
        return IntOffsetKt.round-k-4lQ0M((long)position);
    }

    public final void remove(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        this.rects.remove(layoutNode.getSemanticsId());
        this.invalidate();
        this.isFragmented = true;
    }

    public final boolean isTargetDrawnFirst$ui(int targetId, int otherId) {
        LayoutNode layoutNode = (LayoutNode)this.layoutNodes.get(targetId);
        if (layoutNode == null) {
            return false;
        }
        LayoutNode nodeA = layoutNode;
        LayoutNode layoutNode2 = (LayoutNode)this.layoutNodes.get(otherId);
        if (layoutNode2 == null) {
            return false;
        }
        LayoutNode nodeB = layoutNode2;
        if (nodeA.getDepth$ui() == 0 || nodeB.getDepth$ui() == 0) {
            return false;
        }
        while (nodeA.getDepth$ui() > nodeB.getDepth$ui()) {
            if (nodeA.getParent$ui() != null) continue;
            return false;
        }
        if (nodeA == nodeB) {
            return false;
        }
        while (nodeB.getDepth$ui() > nodeA.getDepth$ui()) {
            if (nodeB.getParent$ui() != null) continue;
            return false;
        }
        if (nodeA == nodeB) {
            return false;
        }
        LayoutNode lastParentA = nodeA;
        LayoutNode lastParentB = nodeB;
        while (nodeA != nodeB) {
            lastParentA = nodeA;
            lastParentB = nodeB;
            if (nodeA.getParent$ui() == null) {
                return false;
            }
            if (nodeB.getParent$ui() != null) continue;
            return false;
        }
        if (lastParentA.getMeasurePassDelegate$ui().getZIndex$ui() == lastParentB.getMeasurePassDelegate$ui().getZIndex$ui()) {
            return lastParentA.getPlaceOrder$ui() < lastParentB.getPlaceOrder$ui();
        }
        return lastParentA.getMeasurePassDelegate$ui().getZIndex$ui() < lastParentB.getMeasurePassDelegate$ui().getZIndex$ui();
    }

    private static final Unit dispatchLambda$lambda$1(RectManager this$0) {
        this$0.dispatchToken = null;
        String sectionName$iv = "OnPositionedDispatch";
        boolean $i$f$trace = false;
        boolean bl = false;
        this$0.dispatchCallbacks();
        return Unit.INSTANCE;
    }

    private static final Unit dispatchCallbacks$lambda$5$lambda$4(RectManager this$0, ThrottledCallbacks.Entry $entry, long $currentTime, long topLeft, long bottomRight) {
        this$0.throttledCallbacks.fireWithUpdatedRect$ui($entry, topLeft, bottomRight, $currentTime);
        return Unit.INSTANCE;
    }

    public RectManager() {
        this(null, 1, null);
    }
}

