/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1.type;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kerby.asn1.Asn1Dumpable;
import org.apache.kerby.asn1.Asn1Dumper;
import org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.Tag;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.type.AbstractAsn1Type;
import org.apache.kerby.asn1.type.Asn1CollectionType;
import org.apache.kerby.asn1.type.Asn1Tagging;
import org.apache.kerby.asn1.type.Asn1Type;

public abstract class Asn1TaggingCollection
extends AbstractAsn1Type<Asn1CollectionType>
implements Asn1Dumpable {
    private Asn1Tagging<Asn1CollectionType> tagging;
    private Asn1CollectionType tagged;

    public Asn1TaggingCollection(int taggingTagNo, Asn1FieldInfo[] tags, boolean isAppSpecific, boolean isImplicit) {
        super(Asn1TaggingCollection.makeTag(isAppSpecific, taggingTagNo));
        this.tagged = this.createTaggedCollection(tags);
        this.setValue(this.tagged);
        this.tagging = new Asn1Tagging<Asn1CollectionType>(taggingTagNo, this.tagged, isAppSpecific, isImplicit);
    }

    private static Tag makeTag(boolean isAppSpecific, int tagNo) {
        return isAppSpecific ? Tag.newAppTag(tagNo) : Tag.newCtxTag(tagNo);
    }

    protected abstract Asn1CollectionType createTaggedCollection(Asn1FieldInfo[] var1);

    @Override
    public Tag tag() {
        return this.tagging.tag();
    }

    @Override
    public int tagNo() {
        return this.tagging.tagNo();
    }

    @Override
    public void usePrimitive(boolean isPrimitive) {
        this.tagging.usePrimitive(isPrimitive);
    }

    @Override
    public boolean isPrimitive() {
        return this.tagging.isPrimitive();
    }

    @Override
    public void useDefinitiveLength(boolean isDefinitiveLength) {
        this.tagging.useDefinitiveLength(isDefinitiveLength);
    }

    @Override
    public boolean isDefinitiveLength() {
        return this.tagging.isDefinitiveLength();
    }

    @Override
    public void useImplicit(boolean isImplicit) {
        this.tagging.useImplicit(isImplicit);
    }

    @Override
    public boolean isImplicit() {
        return this.tagging.isImplicit();
    }

    @Override
    public void useDER() {
        this.tagging.useDER();
    }

    @Override
    public boolean isDER() {
        return this.tagging.isDER();
    }

    @Override
    public void useBER() {
        this.tagging.useBER();
    }

    @Override
    public boolean isBER() {
        return this.tagging.isBER();
    }

    @Override
    public void useCER() {
        this.tagging.useCER();
    }

    @Override
    public boolean isCER() {
        return this.tagging.isCER();
    }

    @Override
    protected int encodingBodyLength() throws IOException {
        return this.tagging.encodingBodyLength();
    }

    @Override
    protected void encodeBody(ByteBuffer buffer) throws IOException {
        this.tagging.encodeBody(buffer);
    }

    @Override
    public void decode(ByteBuffer content2) throws IOException {
        this.tagging.decode(content2);
    }

    @Override
    protected void decodeBody(Asn1ParseResult parseResult) throws IOException {
        this.tagging.decodeBody(parseResult);
    }

    protected <T extends Asn1Type> T getFieldAs(EnumType index2, Class<T> t) {
        return this.tagged.getFieldAs(index2, t);
    }

    protected void setFieldAs(EnumType index2, Asn1Type value) {
        this.tagged.setFieldAs(index2, value);
    }

    protected String getFieldAsString(EnumType index2) {
        return this.tagged.getFieldAsString(index2);
    }

    protected byte[] getFieldAsOctets(EnumType index2) {
        return this.tagged.getFieldAsOctets(index2);
    }

    protected void setFieldAsOctets(EnumType index2, byte[] bytes) {
        this.tagged.setFieldAsOctets(index2, bytes);
    }

    protected Integer getFieldAsInteger(EnumType index2) {
        return this.tagged.getFieldAsInteger(index2);
    }

    protected void setFieldAsInt(EnumType index2, int value) {
        this.tagged.setFieldAsInt(index2, value);
    }

    protected byte[] getFieldAsOctetBytes(EnumType index2) {
        return this.tagged.getFieldAsOctets(index2);
    }

    protected void setFieldAsOctetBytes(EnumType index2, byte[] value) {
        this.tagged.setFieldAsOctets(index2, value);
    }

    @Override
    public void dumpWith(Asn1Dumper dumper, int indents) {
        Asn1Type taggedValue = (Asn1Type)this.getValue();
        dumper.indent(indents).appendType(this.getClass());
        dumper.append(this.simpleInfo()).newLine();
        dumper.dumpType(indents, taggedValue);
    }
}

