/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.partial;

import com.ustadmobile.libcache.partial.RangeRequestNotSatisfiableException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\t\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\t\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\t\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/ustadmobile/libcache/partial/ContentRange;", "", "", "fromByte", "toByte", "totalBytes", "contentLength", "<init>", "(JJJJ)V", "J", "getFromByte", "()J", "getToByte", "getTotalBytes", "getContentLength", "", "getContentRangeResponseHeader", "()Ljava/lang/String;", "contentRangeResponseHeader", "Companion", "respect-lib-cache"})
public final class ContentRange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long fromByte;
    private final long toByte;
    private final long totalBytes;
    private final long contentLength;

    public ContentRange(long fromByte, long toByte, long totalBytes, long contentLength) {
        this.fromByte = fromByte;
        this.toByte = toByte;
        this.totalBytes = totalBytes;
        this.contentLength = contentLength;
    }

    public final long getFromByte() {
        return this.fromByte;
    }

    public final long getToByte() {
        return this.toByte;
    }

    public final long getTotalBytes() {
        return this.totalBytes;
    }

    public final long getContentLength() {
        return this.contentLength;
    }

    @NotNull
    public final String getContentRangeResponseHeader() {
        return "bytes " + this.fromByte + "-" + this.toByte + "/" + this.totalBytes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/ustadmobile/libcache/partial/ContentRange$Companion;", "", "<init>", "()V", "", "header", "", "totalContentLength", "Lcom/ustadmobile/libcache/partial/ContentRange;", "parseRangeHeader", "(Ljava/lang/String;J)Lcom/ustadmobile/libcache/partial/ContentRange;", "respect-lib-cache"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ContentRange parseRangeHeader(@NotNull String header2, long totalContentLength) {
            ContentRange contentRange;
            Intrinsics.checkNotNullParameter(header2, "header");
            String headerTrimmed = ((Object)StringsKt.trim((CharSequence)header2)).toString();
            if (StringsKt.indexOf$default((CharSequence)headerTrimmed, ",", 0, false, 6, null) != -1) {
                throw new RangeRequestNotSatisfiableException("Multiple content-ranges are not supported");
            }
            int equalsPos = StringsKt.indexOf$default((CharSequence)headerTrimmed, "=", 0, false, 6, null);
            if (equalsPos < 0) {
                throw new IllegalArgumentException("Malformed Content-Range: must have unit followed = eg. bytes=");
            }
            String string2 = headerTrimmed.substring(0, equalsPos);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String unit = string2;
            if (!Intrinsics.areEqual(unit, "bytes")) {
                throw new RangeRequestNotSatisfiableException("Content-Range: only supported unit is: bytes, " + unit + " is not supported");
            }
            int dashIndex = StringsKt.indexOf$default((CharSequence)headerTrimmed, "-", 0, false, 6, null);
            String string3 = headerTrimmed.substring(equalsPos + 1, dashIndex);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            String it = string3;
            boolean bl = false;
            long firstBytePos = !StringsKt.isBlank(it) ? Long.parseLong(it) : -1L;
            String string4 = headerTrimmed.substring(dashIndex + 1);
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            String it2 = string4;
            boolean bl2 = false;
            long lastBytePos = !StringsKt.isBlank(it2) ? Long.parseLong(it2) : -1L;
            if (lastBytePos >= 0L && firstBytePos == -1L) {
                contentRange = new ContentRange(totalContentLength - lastBytePos + 1L, totalContentLength, totalContentLength, lastBytePos);
            } else {
                long lastByte;
                long l = lastByte = lastBytePos == -1L ? totalContentLength - 1L : lastBytePos;
                if (lastByte < firstBytePos) {
                    throw new RangeRequestNotSatisfiableException("Cannot satisfy range: last byte " + lastByte + " is before first byte " + firstBytePos);
                }
                if (lastBytePos >= totalContentLength) {
                    throw new RangeRequestNotSatisfiableException("Cannot satisfy range: last byte is " + lastByte + ", but totalSize is " + totalContentLength);
                }
                contentRange = new ContentRange(firstBytePos, lastByte, totalContentLength, lastByte - firstBytePos + 1L);
            }
            return contentRange;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

