/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateProgression;
import kotlinx.datetime.internal.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0002*\u00020\u0002\u001a\u001a\u0010\u0007\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\u0007\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0015\u0010\r\u001a\u00020\u0002*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0004\u001a\u0014\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"first", "Lkotlinx/datetime/LocalDate;", "Lkotlinx/datetime/LocalDateProgression;", "last", "firstOrNull", "lastOrNull", "reversed", "step", "value", "", "unit", "Lkotlinx/datetime/DateTimeUnit$DayBased;", "", "downTo", "that", "random", "Lkotlin/random/Random;", "randomOrNull", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nLocalDateRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDateRange.kt\nkotlinx/datetime/LocalDateRangeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n1#2:279\n*E\n"})
public final class LocalDateRangeKt {
    @NotNull
    public static final LocalDate first(@NotNull LocalDateProgression $this$first) {
        Intrinsics.checkNotNullParameter($this$first, "<this>");
        if ($this$first.isEmpty()) {
            throw new NoSuchElementException("Progression " + $this$first + " is empty.");
        }
        return $this$first.getFirst();
    }

    @NotNull
    public static final LocalDate last(@NotNull LocalDateProgression $this$last) {
        Intrinsics.checkNotNullParameter($this$last, "<this>");
        if ($this$last.isEmpty()) {
            throw new NoSuchElementException("Progression " + $this$last + " is empty.");
        }
        return $this$last.getLast();
    }

    @Nullable
    public static final LocalDate firstOrNull(@NotNull LocalDateProgression $this$firstOrNull) {
        Intrinsics.checkNotNullParameter($this$firstOrNull, "<this>");
        return $this$firstOrNull.isEmpty() ? null : $this$firstOrNull.getFirst();
    }

    @Nullable
    public static final LocalDate lastOrNull(@NotNull LocalDateProgression $this$lastOrNull) {
        Intrinsics.checkNotNullParameter($this$lastOrNull, "<this>");
        return $this$lastOrNull.isEmpty() ? null : $this$lastOrNull.getLast();
    }

    @NotNull
    public static final LocalDateProgression reversed(@NotNull LocalDateProgression $this$reversed) {
        Intrinsics.checkNotNullParameter($this$reversed, "<this>");
        return new LocalDateProgression(RangesKt.reversed($this$reversed.getLongProgression$kotlinx_datetime()));
    }

    @NotNull
    public static final LocalDateProgression step(@NotNull LocalDateProgression $this$step, int value, @NotNull DateTimeUnit.DayBased unit) {
        Intrinsics.checkNotNullParameter($this$step, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return LocalDateRangeKt.step($this$step, (long)value, unit);
    }

    @NotNull
    public static final LocalDateProgression step(@NotNull LocalDateProgression $this$step, long value, @NotNull DateTimeUnit.DayBased unit) {
        Intrinsics.checkNotNullParameter($this$step, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return new LocalDateProgression(RangesKt.step($this$step.getLongProgression$kotlinx_datetime(), MathKt.safeMultiplyOrClamp(value, unit.getDays())));
    }

    @NotNull
    public static final LocalDateProgression downTo(@NotNull LocalDate $this$downTo, @NotNull LocalDate that) {
        Intrinsics.checkNotNullParameter($this$downTo, "<this>");
        Intrinsics.checkNotNullParameter(that, "that");
        return LocalDateProgression.Companion.fromClosedRange$kotlinx_datetime($this$downTo, that, -1L, DateTimeUnit.Companion.getDAY());
    }

    @NotNull
    public static final LocalDate random(@NotNull LocalDateProgression $this$random, @NotNull Random random) {
        Intrinsics.checkNotNullParameter($this$random, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        if ($this$random.isEmpty()) {
            throw new NoSuchElementException("Cannot get random in empty range: " + $this$random);
        }
        long l = MathKt.randomUnsafe($this$random.getLongProgression$kotlinx_datetime(), random);
        LocalDate.Companion companion = LocalDate.Companion;
        long p0 = l;
        boolean bl = false;
        return companion.fromEpochDays(p0);
    }

    public static /* synthetic */ LocalDate random$default(LocalDateProgression localDateProgression, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            random = Random.Default;
        }
        return LocalDateRangeKt.random(localDateProgression, random);
    }

    @Nullable
    public static final LocalDate randomOrNull(@NotNull LocalDateProgression $this$randomOrNull, @NotNull Random random) {
        LocalDate localDate;
        Intrinsics.checkNotNullParameter($this$randomOrNull, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        Long l = MathKt.randomUnsafeOrNull($this$randomOrNull.getLongProgression$kotlinx_datetime(), random);
        if (l != null) {
            Long l2 = l;
            LocalDate.Companion companion = LocalDate.Companion;
            long p0 = ((Number)l2).longValue();
            boolean bl = false;
            localDate = companion.fromEpochDays(p0);
        } else {
            localDate = null;
        }
        return localDate;
    }

    public static /* synthetic */ LocalDate randomOrNull$default(LocalDateProgression localDateProgression, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            random = Random.Default;
        }
        return LocalDateRangeKt.randomOrNull(localDateProgression, random);
    }
}

