/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.helper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrefixPattern {
    private final String prefixChars_;
    private final Pattern prefixPattern_;

    public PrefixPattern(String prefixChars) {
        this.prefixChars_ = prefixChars;
        this.prefixPattern_ = PrefixPattern.compilePrefixPattern(prefixChars);
    }

    public boolean match(String str2) {
        Matcher m = this.prefixPattern_.matcher(str2);
        return m.find() && !m.group(0).equals(str2);
    }

    public boolean matchLongFlag(String str2) {
        Matcher m = this.prefixPattern_.matcher(str2);
        return m.find() && !m.group(0).equals(str2) && m.group(0).length() >= 2;
    }

    public boolean matchShortFlag(String str2) {
        Matcher m = this.prefixPattern_.matcher(str2);
        return m.find() && !m.group(0).equals(str2) && m.group(0).length() == 1;
    }

    public String removePrefix(String str2) {
        Matcher m = this.prefixPattern_.matcher(str2);
        if (m.find() && !m.group(0).equals(str2)) {
            return m.replaceFirst("");
        }
        return str2;
    }

    public String getPrefixChars() {
        return this.prefixChars_;
    }

    public Pattern getPrefixPattern() {
        return this.prefixPattern_;
    }

    private static Pattern compilePrefixPattern(String prefixChars) {
        String qs = Pattern.quote(prefixChars);
        return Pattern.compile("^[" + qs + "]+");
    }
}

