/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.response;

import com.ustadmobile.ihttp.ext.ByteArrayExt_jvmKt;
import com.ustadmobile.ihttp.headers.IHttpHeaders;
import com.ustadmobile.ihttp.headers.MergedHeaders;
import com.ustadmobile.ihttp.request.IHttpRequest;
import com.ustadmobile.ihttp.response.IHttpResponse;
import com.ustadmobile.libcache.CompressionType;
import com.ustadmobile.libcache.io.SourceExtKt;
import com.ustadmobile.libcache.partial.ContentRange;
import com.ustadmobile.libcache.partial.RangeRequestNotSatisfiableException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.io.CoreKt;
import kotlinx.io.Source;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.PathsJvmKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0017R\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001f\u001a\u0004\b \u0010!R\u0016\u0010#\u001a\u0004\u0018\u00010\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcom/ustadmobile/libcache/response/CacheResponse;", "Lcom/ustadmobile/ihttp/response/IHttpResponse;", "Lkotlinx/io/files/FileSystem;", "fileSystem", "Lcom/ustadmobile/ihttp/request/IHttpRequest;", "request", "Lcom/ustadmobile/ihttp/headers/IHttpHeaders;", "headers", "", "storageUri", "", "uncompressedSize", "", "httpResponseCode", "<init>", "(Lkotlinx/io/files/FileSystem;Lcom/ustadmobile/ihttp/request/IHttpRequest;Lcom/ustadmobile/ihttp/headers/IHttpHeaders;Ljava/lang/String;JI)V", "Lkotlinx/io/Source;", "bodyAsSource", "()Lkotlinx/io/Source;", "Lkotlinx/io/files/FileSystem;", "Lcom/ustadmobile/ihttp/request/IHttpRequest;", "getRequest", "()Lcom/ustadmobile/ihttp/request/IHttpRequest;", "Ljava/lang/String;", "I", "getResponseCode", "()I", "responseCode", "Lcom/ustadmobile/libcache/partial/ContentRange;", "rangeResponse", "Lcom/ustadmobile/libcache/partial/ContentRange;", "Lcom/ustadmobile/ihttp/headers/IHttpHeaders;", "getHeaders", "()Lcom/ustadmobile/ihttp/headers/IHttpHeaders;", "", "errorBody", "[B", "Lcom/ustadmobile/libcache/CompressionType;", "bodyUncompressType", "Lcom/ustadmobile/libcache/CompressionType;", "respect-lib-cache"})
public final class CacheResponse
implements IHttpResponse {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final IHttpRequest request;
    @NotNull
    private final String storageUri;
    private volatile int httpResponseCode;
    @Nullable
    private final ContentRange rangeResponse;
    @NotNull
    private final IHttpHeaders headers;
    @Nullable
    private final byte[] errorBody;
    @NotNull
    private final CompressionType bodyUncompressType;

    public CacheResponse(@NotNull FileSystem fileSystem2, @NotNull IHttpRequest request2, @NotNull IHttpHeaders headers2, @NotNull String storageUri, long uncompressedSize, int httpResponseCode) {
        Object errorBody;
        ContentRange rangeResponse;
        Map overrideHeadersMap;
        block8: {
            Intrinsics.checkNotNullParameter(fileSystem2, "fileSystem");
            Intrinsics.checkNotNullParameter(request2, "request");
            Intrinsics.checkNotNullParameter(headers2, "headers");
            Intrinsics.checkNotNullParameter(storageUri, "storageUri");
            this.fileSystem = fileSystem2;
            this.request = request2;
            this.storageUri = storageUri;
            this.httpResponseCode = httpResponseCode;
            String rangeRequestHeader = this.getRequest().getHeaders().get("range");
            String ifRangeRequestHeader = this.getRequest().getHeaders().get("if-range");
            overrideHeadersMap = new LinkedHashMap();
            rangeResponse = null;
            errorBody = null;
            List<CompressionType> acceptEncoding = CompressionType.Companion.parseAcceptEncodingHeader(this.getRequest().getHeaders().get("accept-encoding"));
            CompressionType storageContentEncoding = CompressionType.Companion.byHeaderVal(headers2.get("content-encoding"));
            if (!acceptEncoding.contains((Object)storageContentEncoding)) {
                overrideHeadersMap.put("content-encoding", CollectionsKt.listOf("identity"));
                overrideHeadersMap.put("content-length", CollectionsKt.listOf(String.valueOf(uncompressedSize)));
                v0 = storageContentEncoding;
            } else {
                v0 = this.bodyUncompressType = CompressionType.NONE;
            }
            if (rangeRequestHeader == null || ifRangeRequestHeader != null && !Intrinsics.areEqual(ifRangeRequestHeader, headers2.get("etag"))) break block8;
            Object object = (List)overrideHeadersMap.get("content-length");
            if ((object == null || (object = (String)CollectionsKt.firstOrNull(object)) == null) && (object = headers2.get("content-length")) == null) {
                throw new IllegalStateException("CacheResponse headers missing content-length");
            }
            Object effectiveContentLength = object;
            long totalSize = Long.parseLong((String)effectiveContentLength);
            try {
                ContentRange contentRange;
                ContentRange it = contentRange = ContentRange.Companion.parseRangeHeader(rangeRequestHeader, totalSize);
                boolean bl = false;
                rangeResponse = it;
                this.httpResponseCode = 206;
                overrideHeadersMap.put("content-length", CollectionsKt.listOf(String.valueOf(it.getContentLength())));
                overrideHeadersMap.put("Content-Range", CollectionsKt.listOf(it.getContentRangeResponseHeader()));
            }
            catch (RangeRequestNotSatisfiableException e) {
                Object object2;
                block10: {
                    block9: {
                        this.httpResponseCode = 416;
                        object2 = e.getMessage();
                        if (object2 == null) break block9;
                        String string2 = object2;
                        byte[] byArray = string2.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                        object2 = byArray;
                        if (byArray != null) break block10;
                    }
                    object2 = new byte[0];
                }
                errorBody = object2;
                overrideHeadersMap.put("content-length", CollectionsKt.listOf(String.valueOf(((Object)errorBody).length)));
            }
        }
        this.rangeResponse = rangeResponse;
        IHttpHeaders[] iHttpHeadersArray = new IHttpHeaders[]{IHttpHeaders.Companion.fromMap(MapsKt.toMap(overrideHeadersMap)), headers2};
        this.headers = new MergedHeaders(iHttpHeadersArray);
        this.errorBody = errorBody;
    }

    public /* synthetic */ CacheResponse(FileSystem fileSystem2, IHttpRequest iHttpRequest, IHttpHeaders iHttpHeaders, String string2, long l, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            n = 200;
        }
        this(fileSystem2, iHttpRequest, iHttpHeaders, string2, l, n);
    }

    @Override
    @NotNull
    public IHttpRequest getRequest() {
        return this.request;
    }

    @Override
    public int getResponseCode() {
        return this.httpResponseCode;
    }

    @Override
    @NotNull
    public IHttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Source bodyAsSource() {
        Object object;
        if (this.getRequest().getMethod() == IHttpRequest.Companion.Method.HEAD) {
            object = CoreKt.buffered(ByteArrayExt_jvmKt.asSource(new byte[0]));
        } else if (this.errorBody != null) {
            object = CoreKt.buffered(ByteArrayExt_jvmKt.asSource(this.errorBody));
        } else {
            void var1_1;
            Source source2 = SourceExtKt.uncompress(CoreKt.buffered(this.fileSystem.source(PathsJvmKt.Path(this.storageUri))), this.bodyUncompressType);
            object = this.rangeResponse != null ? CoreKt.buffered(SourceExtKt.range(source2, this.rangeResponse.getFromByte(), this.rangeResponse.getToByte())) : var1_1;
        }
        return object;
    }
}

