/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.atomicfu.locks;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import kotlinx.atomicfu.locks.Free;
import kotlinx.atomicfu.locks.Parked;
import kotlinx.atomicfu.locks.ParkingDelegator;
import kotlinx.atomicfu.locks.ParkingState;
import kotlinx.atomicfu.locks.Unparked;
import kotlinx.atomicfu.locks.Unparking;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\n2\u0016\u0010\u000f\u001a\u0012\u0012\b\u0012\u00060\u0011j\u0002`\u0012\u0012\u0004\u0012\u00020\n0\u0010H\u0002J\u0006\u0010\u0013\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkotlinx/atomicfu/locks/ThreadParker;", "", "<init>", "()V", "delegator", "Lkotlinx/atomicfu/locks/ParkingDelegator;", "state", "Lkotlinx/atomicfu/AtomicRef;", "Lkotlinx/atomicfu/locks/ParkingState;", "park", "", "parkNanos", "nanos", "", "parkWith", "invokeWait", "Lkotlin/Function1;", "Ljava/lang/Thread;", "Lkotlinx/atomicfu/locks/ParkingData;", "unpark", "atomicfu"})
public final class ThreadParker {
    @NotNull
    private final ParkingDelegator delegator = ParkingDelegator.INSTANCE;
    @NotNull
    private final AtomicRef<ParkingState> state = AtomicFU.atomic(Free.INSTANCE);

    public final void park() {
        this.parkWith((Function1<? super Thread, Unit>)((Function1)arg_0 -> ThreadParker.park$lambda$1(this, arg_0)));
    }

    public final void parkNanos(long nanos) {
        long mark = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        this.parkWith((Function1<? super Thread, Unit>)((Function1)arg_0 -> ThreadParker.parkNanos$lambda$3(nanos, mark, this, arg_0)));
    }

    /*
     * Unable to fully structure code
     */
    private final void parkWith(Function1<? super Thread, Unit> invokeWait) {
        block8: {
            while (true) {
                block9: {
                    block7: {
                        if (!Intrinsics.areEqual((Object)(var2_2 = this.state.getValue()), (Object)Free.INSTANCE)) break block9;
                        pd = this.delegator.createRef();
                        if (!this.state.compareAndSet(Free.INSTANCE, new Parked(pd))) {
                            this.delegator.destroyRef(pd);
                            continue;
                        }
                        invokeWait.invoke((Object)pd);
                        do lbl-1000:
                        // 3 sources

                        {
                            block10: {
                                if (!((changedState = this.state.getValue()) instanceof Parked)) break block10;
                                if (!this.state.compareAndSet(changedState, Free.INSTANCE)) ** GOTO lbl-1000
                                this.delegator.destroyRef(pd);
                                return;
                            }
                            if (!(changedState instanceof Unparking)) break block7;
                        } while (!this.state.compareAndSet(changedState, Free.INSTANCE));
                        return;
                    }
                    if (Intrinsics.areEqual((Object)changedState, (Object)Free.INSTANCE)) {
                        this.delegator.destroyRef(pd);
                        return;
                    }
                    if (Intrinsics.areEqual((Object)changedState, (Object)Unparked.INSTANCE)) {
                        this.delegator.destroyRef(pd);
                        return;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                if (!Intrinsics.areEqual((Object)var2_2, (Object)Unparked.INSTANCE)) break block8;
                if (this.state.compareAndSet(Unparked.INSTANCE, Free.INSTANCE)) break;
            }
            return;
        }
        if (var2_2 instanceof Parked) {
            throw new IllegalStateException("Thread should not be able to call park when it is already parked");
        }
        if (var2_2 instanceof Unparking) {
            throw new IllegalStateException("Thread should not be able to call park when it is already parked");
        }
        throw new NoWhenBranchMatchedException();
    }

    public final void unpark() {
        block5: {
            ParkingState currentState;
            Unparking myUnparkingState = new Unparking();
            while (true) {
                if (Intrinsics.areEqual((Object)(currentState = this.state.getValue()), (Object)Unparked.INSTANCE)) {
                    return;
                }
                if (currentState instanceof Unparking) {
                    return;
                }
                if (Intrinsics.areEqual((Object)currentState, (Object)Free.INSTANCE)) {
                    if (!this.state.compareAndSet(Free.INSTANCE, Unparked.INSTANCE)) continue;
                    return;
                }
                if (!(currentState instanceof Parked)) break block5;
                if (this.state.compareAndSet(currentState, myUnparkingState)) break;
            }
            this.delegator.wake(((Parked)currentState).getData());
            if (this.state.compareAndSet(myUnparkingState, Free.INSTANCE)) {
                return;
            }
            this.delegator.destroyRef(((Parked)currentState).getData());
            return;
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final boolean park$lambda$1$lambda$0(ThreadParker this$0) {
        return this$0.state.getValue() instanceof Parked;
    }

    private static final Unit park$lambda$1(ThreadParker this$0, Thread data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this$0.delegator.wait(data, (Function0<Boolean>)((Function0)() -> ThreadParker.park$lambda$1$lambda$0(this$0)));
        return Unit.INSTANCE;
    }

    private static final boolean parkNanos$lambda$3$lambda$2(ThreadParker this$0) {
        return this$0.state.getValue() instanceof Parked;
    }

    private static final Unit parkNanos$lambda$3(long $nanos, long $mark, ThreadParker this$0, Thread data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        long remainingTime = $nanos - Duration.toLong-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)$mark), (DurationUnit)DurationUnit.NANOSECONDS);
        if (remainingTime > 0L) {
            this$0.delegator.timedWait(data, remainingTime, (Function0<Boolean>)((Function0)() -> ThreadParker.parkNanos$lambda$3$lambda$2(this$0)));
        }
        return Unit.INSTANCE;
    }
}

