/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.util;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\b*\u00020\u0002\u00a8\u0006\n"}, d2={"writeShortString", "", "Ljava/nio/ByteBuffer;", "string", "", "readShortString", "writePayload", "payload", "", "readPayload", "respect-lib-cache_debug"})
public final class ByteBufferExtKt {
    public static final void writeShortString(@NotNull ByteBuffer $this$writeShortString, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)$this$writeShortString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] stringAsBytes = byArray;
        if (stringAsBytes.length > 127) {
            throw new IllegalArgumentException("Write short string: must not exceed 127 bytes");
        }
        $this$writeShortString.put((byte)stringAsBytes.length);
        $this$writeShortString.put(stringAsBytes);
    }

    @NotNull
    public static final String readShortString(@NotNull ByteBuffer $this$readShortString) {
        Intrinsics.checkNotNullParameter((Object)$this$readShortString, (String)"<this>");
        byte stringByteSize = $this$readShortString.get();
        if (stringByteSize < 0) {
            throw new IllegalArgumentException("Doesn't look like size in bytes: " + stringByteSize);
        }
        if (stringByteSize == 0) {
            return "";
        }
        byte[] byteArray = new byte[stringByteSize];
        $this$readShortString.get(byteArray);
        return StringsKt.decodeToString((byte[])byteArray);
    }

    public static final void writePayload(@NotNull ByteBuffer $this$writePayload, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)$this$writePayload, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (payload.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("writePayload: max byte array size of 32767 exceeded");
        }
        $this$writePayload.putShort((short)payload.length);
        if (!(payload.length == 0)) {
            $this$writePayload.put(payload);
        }
    }

    @NotNull
    public static final byte[] readPayload(@NotNull ByteBuffer $this$readPayload) {
        Intrinsics.checkNotNullParameter((Object)$this$readPayload, (String)"<this>");
        short payloadSize = $this$readPayload.getShort();
        if (payloadSize < 0) {
            throw new IllegalStateException("Payload size cannot be negative");
        }
        byte[] payload = new byte[payloadSize];
        if (payloadSize > 0) {
            $this$readPayload.get(payload);
        }
        return payload;
    }
}

