/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.attestation.authenticator.AbstractCOSEKey;
import com.webauthn4j.data.attestation.authenticator.Curve;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.COSEKeyOperation;
import com.webauthn4j.data.attestation.statement.COSEKeyType;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.EdECPrivateKey;
import java.security.interfaces.EdECPublicKey;
import java.security.spec.EdECPoint;
import java.security.spec.EdECPrivateKeySpec;
import java.security.spec.EdECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.NamedParameterSpec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EdDSACOSEKey
extends AbstractCOSEKey {
    private static final String CURVE_NULL_CHECK_MESSAGE = "curve must not be null";
    private static final String ALG_VALUE_CHECK_MESSAGE = "alg must be EdDSA";
    @JsonProperty(value="-1")
    private final Curve curve;
    @JsonProperty(value="-2")
    private byte[] x;
    @JsonProperty(value="-4")
    private byte[] d;

    @JsonCreator
    public EdDSACOSEKey(@JsonProperty(value="2") @Nullable byte[] keyId, @JsonProperty(value="3") @Nullable COSEAlgorithmIdentifier algorithm, @JsonProperty(value="4") @Nullable List<COSEKeyOperation> keyOps, @JsonProperty(value="-1") @Nullable Curve curve, @JsonProperty(value="-2") @Nullable byte[] x2, @JsonProperty(value="-4") @Nullable byte[] d) {
        super(keyId, algorithm, keyOps, null);
        this.curve = curve;
        this.x = x2;
        this.d = d;
    }

    @NotNull
    public static EdDSACOSEKey create(@NotNull EdECPrivateKey privateKey, @Nullable COSEAlgorithmIdentifier alg) {
        AssertUtil.isTrue(alg == COSEAlgorithmIdentifier.EdDSA, ALG_VALUE_CHECK_MESSAGE);
        byte[] d = privateKey.getBytes().orElseThrow(() -> new IllegalArgumentException("privateKey must not be null"));
        Curve curve = EdDSACOSEKey.getCurve(privateKey.getParams());
        return new EdDSACOSEKey(null, alg, null, curve, null, d);
    }

    @NotNull
    public static EdDSACOSEKey create(@NotNull EdECPublicKey publicKey, @Nullable COSEAlgorithmIdentifier alg) {
        AssertUtil.isTrue(alg == COSEAlgorithmIdentifier.EdDSA, ALG_VALUE_CHECK_MESSAGE);
        Curve curve = EdDSACOSEKey.getCurve(publicKey.getParams());
        byte[] x2 = EdDSACOSEKey.calcCOSEXParam(publicKey);
        return new EdDSACOSEKey(null, alg, null, curve, x2, null);
    }

    @NotNull
    public static EdDSACOSEKey create(@NotNull KeyPair keyPair, @Nullable COSEAlgorithmIdentifier alg) {
        AssertUtil.isTrue(alg == COSEAlgorithmIdentifier.EdDSA, ALG_VALUE_CHECK_MESSAGE);
        EdECPublicKey edECPublicKey = (EdECPublicKey)keyPair.getPublic();
        EdECPrivateKey edECPrivateKey = (EdECPrivateKey)keyPair.getPrivate();
        Curve curve = EdDSACOSEKey.getCurve(edECPublicKey.getParams());
        byte[] x2 = EdDSACOSEKey.calcCOSEXParam(edECPublicKey);
        byte[] d = edECPrivateKey.getBytes().orElseThrow(() -> new IllegalArgumentException("privateKey must not be null"));
        return new EdDSACOSEKey(null, alg, null, curve, x2, d);
    }

    @NotNull
    public static EdDSACOSEKey create(@NotNull EdECPrivateKey privateKey) {
        return EdDSACOSEKey.create(privateKey, COSEAlgorithmIdentifier.EdDSA);
    }

    @NotNull
    public static EdDSACOSEKey create(@NotNull EdECPublicKey publicKey) {
        return EdDSACOSEKey.create(publicKey, COSEAlgorithmIdentifier.EdDSA);
    }

    @NotNull
    public static EdDSACOSEKey create(@NotNull KeyPair keyPair) {
        return EdDSACOSEKey.create(keyPair, COSEAlgorithmIdentifier.EdDSA);
    }

    @Override
    public boolean hasPublicKey() {
        return this.x != null;
    }

    @Override
    public boolean hasPrivateKey() {
        return this.d != null;
    }

    @Override
    @Nullable
    public PublicKey getPublicKey() {
        if (!this.hasPublicKey()) {
            return null;
        }
        try {
            KeyFactory factory = KeyFactory.getInstance("EdDSA");
            NamedParameterSpec namedParameterSpec = (NamedParameterSpec)this.curve.getParameterSpec();
            EdECPoint edECPoint = EdDSACOSEKey.toEdECPoint(this.x);
            EdECPublicKeySpec keySpec = new EdECPublicKeySpec(namedParameterSpec, edECPoint);
            return factory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    @Override
    @Nullable
    public PrivateKey getPrivateKey() {
        if (!this.hasPrivateKey()) {
            return null;
        }
        try {
            KeyFactory factory = KeyFactory.getInstance("EdDSA");
            NamedParameterSpec namedParameterSpec = (NamedParameterSpec)this.curve.getParameterSpec();
            EdECPrivateKeySpec keySpec = new EdECPrivateKeySpec(namedParameterSpec, this.d);
            return factory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    @Override
    @NotNull
    public COSEKeyType getKeyType() {
        return COSEKeyType.OKP;
    }

    @Nullable
    public Curve getCurve() {
        return this.curve;
    }

    @Nullable
    public byte[] getX() {
        return ArrayUtil.clone(this.x);
    }

    @Nullable
    public byte[] getD() {
        return ArrayUtil.clone(this.d);
    }

    @Override
    public void validate() {
        if (this.curve == null) {
            throw new ConstraintViolationException(CURVE_NULL_CHECK_MESSAGE);
        }
        if (this.curve != Curve.ED25519) {
            throw new ConstraintViolationException("curve must be Ed25519");
        }
        COSEAlgorithmIdentifier algorithm = this.getAlgorithm();
        if (algorithm != null && !Objects.equals(algorithm, COSEAlgorithmIdentifier.EdDSA)) {
            throw new ConstraintViolationException("algorithm must be EdDSA if present");
        }
        if (!this.hasPublicKey() && !this.hasPrivateKey()) {
            throw new ConstraintViolationException("x or d must be present");
        }
        if (this.x == null) {
            throw new ConstraintViolationException("x must not be null");
        }
    }

    static Curve getCurve(NamedParameterSpec namedParameterSpec) {
        if (Objects.equals(namedParameterSpec.getName(), NamedParameterSpec.ED25519.getName())) {
            return Curve.ED25519;
        }
        throw new IllegalArgumentException(String.format("%s is not supported. Ed25519 is the only supported curve.", namedParameterSpec.getName()));
    }

    private static byte[] calcCOSEXParam(EdECPublicKey publicKey) {
        Curve curve = EdDSACOSEKey.getCurve(publicKey.getParams());
        BigInteger y2 = publicKey.getPoint().getY();
        byte[] bytes = ArrayUtil.convertToFixedByteArray(curve.getSize(), y2);
        EdDSACOSEKey.reverse(bytes);
        boolean xOdd = publicKey.getPoint().isXOdd();
        if (xOdd) {
            int n = bytes.length - 1;
            bytes[n] = (byte)(bytes[n] | 0xFFFFFF80);
        }
        return bytes;
    }

    private static EdECPoint toEdECPoint(byte[] bytes) {
        byte[] cloned = (byte[])bytes.clone();
        boolean xOdd = (cloned[bytes.length - 1] & 0x80) != 0;
        int n = bytes.length - 1;
        cloned[n] = (byte)(cloned[n] & 0x7F);
        EdDSACOSEKey.reverse(cloned);
        BigInteger y2 = new BigInteger(1, cloned);
        return new EdECPoint(xOdd, y2);
    }

    private static void reverse(byte[] bytes) {
        int i2 = 0;
        for (int j = bytes.length - 1; i2 < j; ++i2, --j) {
            byte tmp = bytes[i2];
            bytes[i2] = bytes[j];
            bytes[j] = tmp;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EdDSACOSEKey that = (EdDSACOSEKey)o;
        return this.curve == that.curve && Arrays.equals(this.x, that.x) && Arrays.equals(this.d, that.d);
    }

    @Override
    public int hashCode() {
        int result2 = Objects.hash(new Object[]{super.hashCode(), this.curve});
        result2 = 31 * result2 + Arrays.hashCode(this.x);
        result2 = 31 * result2 + Arrays.hashCode(this.d);
        return result2;
    }

    public String toString() {
        return "EdDSACOSEKey(keyId=" + ArrayUtil.toHexString(this.getKeyId()) + ", alg=" + this.getAlgorithm() + ", curve=" + this.curve + ", x=" + ArrayUtil.toHexString(this.x) + ", d=" + ArrayUtil.toHexString(this.d) + ")";
    }
}

