package com.ustadmobile.libcache.db

import androidx.room.Database
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.libcache.db.dao.CacheEntryDao
import com.ustadmobile.libcache.db.dao.RequestedEntryDao
import com.ustadmobile.libcache.db.dao.RetentionLockDao
import com.ustadmobile.libcache.db.entities.CacheEntry
import com.ustadmobile.libcache.db.entities.RequestedEntry
import com.ustadmobile.libcache.db.entities.RetentionLock

@Database(
  version = 9,
  entities = arrayOf(CacheEntry::class, RequestedEntry::class, RetentionLock::class),
  views = arrayOf(),
  exportSchema = true,
)
public actual abstract class UstadCacheDb : RoomDatabase() {
  public actual abstract val cacheEntryDao: CacheEntryDao

  public actual abstract val requestedEntryDao: RequestedEntryDao

  public actual abstract val retentionLockDao: RetentionLockDao
}
