/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.lib.db.composites.ActorUidEtagAndLastMod;
import com.ustadmobile.lib.db.entities.xapi.ActorEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u00a7@\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u00a7@\u00a2\u0006\u0002\u0010\u0012J(\u0010\u0016\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\u001aJ\u001c\u0010\u001b\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u00a7@\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/ustadmobile/core/db/dao/xapi/ActorDao;", "", "()V", "findByUidAndPersonUidAsync", "Lcom/ustadmobile/lib/db/entities/xapi/ActorEntity;", "actorUid", "", "accountPersonUid", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidAsync", "uid", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findGroupMembers", "", "groupActorUid", "findUidAndEtagByListAsync", "Lcom/ustadmobile/lib/db/composites/ActorUidEtagAndLastMod;", "uidList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertOrIgnoreListAsync", "", "entities", "updateIfNameChanged", "name", "", "updateTime", "(JLjava/lang/String;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "upsertListAsync", "lib-database_release"})
@Dao
public abstract class ActorDao {
    @Insert(entity=Object.class, onConflict=5)
    @Nullable
    public abstract Object insertOrIgnoreListAsync(@NotNull List<ActorEntity> var1, @NotNull Continuation<? super Unit> var2);

    @Insert(entity=Object.class, onConflict=1)
    @Nullable
    public abstract Object upsertListAsync(@NotNull List<ActorEntity> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        UPDATE ActorEntity\n           SET actorName = :name,\n               actorLct = :updateTime\n         WHERE actorUid = :uid\n           AND ActorEntity.actorName != :name\n    ")
    @Nullable
    public abstract Object updateIfNameChanged(long var1, @Nullable String var3, long var4, @NotNull Continuation<? super Unit> var6);

    @Query(value="\n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorUid = :uid\n    ")
    @Nullable
    public abstract Object findByUidAsync(long var1, @NotNull Continuation<? super ActorEntity> var3);

    @Query(value="\n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorUid = :actorUid\n           AND ActorEntity.actorPersonUid = :accountPersonUid  \n    ")
    @Nullable
    public abstract Object findByUidAndPersonUidAsync(long var1, long var3, @NotNull Continuation<? super ActorEntity> var5);

    @Query(value="\n        SELECT ActorEntity.actorUid, ActorEntity.actorEtag, ActorEntity.actorLct\n          FROM ActorEntity\n         WHERE ActorEntity.actorUid IN (:uidList)\n    ")
    @Nullable
    public abstract Object findUidAndEtagByListAsync(@NotNull List<Long> var1, @NotNull Continuation<? super List<ActorUidEtagAndLastMod>> var2);

    @Query(value="\n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorUid IN (\n               SELECT GroupMemberActorJoin.gmajMemberActorUid\n                 FROM GroupMemberActorJoin\n                WHERE GroupMemberActorJoin.gmajGroupActorUid = :groupActorUid\n                  AND GroupMemberActorJoin.gmajLastMod = (\n                      SELECT GroupActorEntity.actorLct\n                        FROM ActorEntity GroupActorEntity\n                       WHERE GroupActorEntity.actorUid = :groupActorUid)\n              ) \n    ")
    @Nullable
    public abstract Object findGroupMembers(long var1, @NotNull Continuation<? super List<ActorEntity>> var3);
}

