/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ScheduleDao;
import com.ustadmobile.lib.db.entities.Schedule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class ScheduleDao_Impl
extends ScheduleDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Schedule> __insertionAdapterOfSchedule;
    private final EntityInsertionAdapter<Schedule> __insertionAdapterOfSchedule_1;
    private final EntityDeletionOrUpdateAdapter<Schedule> __updateAdapterOfSchedule;
    private final SharedSQLiteStatement __preparedStmtOfUpdateScheduleActivated;

    public ScheduleDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSchedule = new EntityInsertionAdapter<Schedule>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `Schedule` (`scheduleUid`,`sceduleStartTime`,`scheduleEndTime`,`scheduleDay`,`scheduleMonth`,`scheduleFrequency`,`umCalendarUid`,`scheduleClazzUid`,`scheduleMasterChangeSeqNum`,`scheduleLocalChangeSeqNum`,`scheduleLastChangedBy`,`scheduleLastChangedTime`,`scheduleActive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Schedule entity) {
                statement.bindLong(1, entity.getScheduleUid());
                statement.bindLong(2, entity.getSceduleStartTime());
                statement.bindLong(3, entity.getScheduleEndTime());
                statement.bindLong(4, (long)entity.getScheduleDay());
                statement.bindLong(5, (long)entity.getScheduleMonth());
                statement.bindLong(6, (long)entity.getScheduleFrequency());
                statement.bindLong(7, entity.getUmCalendarUid());
                statement.bindLong(8, entity.getScheduleClazzUid());
                statement.bindLong(9, entity.getScheduleMasterChangeSeqNum());
                statement.bindLong(10, entity.getScheduleLocalChangeSeqNum());
                statement.bindLong(11, (long)entity.getScheduleLastChangedBy());
                statement.bindLong(12, entity.getScheduleLastChangedTime());
                int _tmp = entity.getScheduleActive() ? 1 : 0;
                statement.bindLong(13, (long)_tmp);
            }
        };
        this.__insertionAdapterOfSchedule_1 = new EntityInsertionAdapter<Schedule>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `Schedule` (`scheduleUid`,`sceduleStartTime`,`scheduleEndTime`,`scheduleDay`,`scheduleMonth`,`scheduleFrequency`,`umCalendarUid`,`scheduleClazzUid`,`scheduleMasterChangeSeqNum`,`scheduleLocalChangeSeqNum`,`scheduleLastChangedBy`,`scheduleLastChangedTime`,`scheduleActive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Schedule entity) {
                statement.bindLong(1, entity.getScheduleUid());
                statement.bindLong(2, entity.getSceduleStartTime());
                statement.bindLong(3, entity.getScheduleEndTime());
                statement.bindLong(4, (long)entity.getScheduleDay());
                statement.bindLong(5, (long)entity.getScheduleMonth());
                statement.bindLong(6, (long)entity.getScheduleFrequency());
                statement.bindLong(7, entity.getUmCalendarUid());
                statement.bindLong(8, entity.getScheduleClazzUid());
                statement.bindLong(9, entity.getScheduleMasterChangeSeqNum());
                statement.bindLong(10, entity.getScheduleLocalChangeSeqNum());
                statement.bindLong(11, (long)entity.getScheduleLastChangedBy());
                statement.bindLong(12, entity.getScheduleLastChangedTime());
                int _tmp = entity.getScheduleActive() ? 1 : 0;
                statement.bindLong(13, (long)_tmp);
            }
        };
        this.__updateAdapterOfSchedule = new EntityDeletionOrUpdateAdapter<Schedule>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `Schedule` SET `scheduleUid` = ?,`sceduleStartTime` = ?,`scheduleEndTime` = ?,`scheduleDay` = ?,`scheduleMonth` = ?,`scheduleFrequency` = ?,`umCalendarUid` = ?,`scheduleClazzUid` = ?,`scheduleMasterChangeSeqNum` = ?,`scheduleLocalChangeSeqNum` = ?,`scheduleLastChangedBy` = ?,`scheduleLastChangedTime` = ?,`scheduleActive` = ? WHERE `scheduleUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Schedule entity) {
                statement.bindLong(1, entity.getScheduleUid());
                statement.bindLong(2, entity.getSceduleStartTime());
                statement.bindLong(3, entity.getScheduleEndTime());
                statement.bindLong(4, (long)entity.getScheduleDay());
                statement.bindLong(5, (long)entity.getScheduleMonth());
                statement.bindLong(6, (long)entity.getScheduleFrequency());
                statement.bindLong(7, entity.getUmCalendarUid());
                statement.bindLong(8, entity.getScheduleClazzUid());
                statement.bindLong(9, entity.getScheduleMasterChangeSeqNum());
                statement.bindLong(10, entity.getScheduleLocalChangeSeqNum());
                statement.bindLong(11, (long)entity.getScheduleLastChangedBy());
                statement.bindLong(12, entity.getScheduleLastChangedTime());
                int _tmp = entity.getScheduleActive() ? 1 : 0;
                statement.bindLong(13, (long)_tmp);
                statement.bindLong(14, entity.getScheduleUid());
            }
        };
        this.__preparedStmtOfUpdateScheduleActivated = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE Schedule \n           SET scheduleActive = ?,\n               scheduleLastChangedTime = ?\n         WHERE scheduleUid = ?\n            ";
                return "\n        UPDATE Schedule \n           SET scheduleActive = ?,\n               scheduleLastChangedTime = ?\n         WHERE scheduleUid = ?\n            ";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(Schedule entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfSchedule.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final Schedule entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ScheduleDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ScheduleDao_Impl.this.__insertionAdapterOfSchedule.insertAndReturnId((Object)entity);
                    ScheduleDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ScheduleDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends Schedule> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfSchedule.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object upsertListAsync(final List<Schedule> entities, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ScheduleDao_Impl.this.__db.beginTransaction();
                try {
                    ScheduleDao_Impl.this.__insertionAdapterOfSchedule_1.insert((Iterable)entities);
                    ScheduleDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ScheduleDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(Schedule entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfSchedule.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final Schedule entity, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                ScheduleDao_Impl.this.__db.beginTransaction();
                try {
                    ScheduleDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += ScheduleDao_Impl.this.__updateAdapterOfSchedule.handle((Object)entity);
                    return n;
                }
                finally {
                    ScheduleDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateScheduleActivated(final long scheduleUid, final boolean active, final long changeTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ScheduleDao_Impl.this.__preparedStmtOfUpdateScheduleActivated.acquire();
                int _argIndex = 1;
                int _tmp = active ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, changeTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, scheduleUid);
                try {
                    Unit unit;
                    ScheduleDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ScheduleDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ScheduleDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ScheduleDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ScheduleDao_Impl.this.__preparedStmtOfUpdateScheduleActivated.release(_stmt);
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schedule findByUid(long uid) {
        String _sql = "SELECT * FROM Schedule WHERE scheduleUid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Schedule WHERE scheduleUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Schedule _result2;
            int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleUid");
            int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sceduleStartTime");
            int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEndTime");
            int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleDay");
            int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleMonth");
            int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleFrequency");
            int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarUid");
            int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleClazzUid");
            int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleMasterChangeSeqNum");
            int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLocalChangeSeqNum");
            int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLastChangedBy");
            int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLastChangedTime");
            int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleActive");
            if (_cursor.moveToFirst()) {
                _result2 = new Schedule();
                long _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
                _result2.setScheduleUid(_tmpScheduleUid);
                long _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
                _result2.setSceduleStartTime(_tmpSceduleStartTime);
                long _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
                _result2.setScheduleEndTime(_tmpScheduleEndTime);
                int _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
                _result2.setScheduleDay(_tmpScheduleDay);
                int _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
                _result2.setScheduleMonth(_tmpScheduleMonth);
                int _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
                _result2.setScheduleFrequency(_tmpScheduleFrequency);
                long _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
                _result2.setUmCalendarUid(_tmpUmCalendarUid);
                long _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
                _result2.setScheduleClazzUid(_tmpScheduleClazzUid);
                long _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
                _result2.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
                long _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
                _result2.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
                int _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
                _result2.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
                long _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
                _result2.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
                int _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
                boolean _tmpScheduleActive = _tmp != 0;
                _result2.setScheduleActive(_tmpScheduleActive);
            } else {
                _result2 = null;
            }
            Schedule schedule = _result2;
            return schedule;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findByUidAsync(long uid, Continuation<? super Schedule> $completion) {
        String _sql = "SELECT * FROM Schedule WHERE scheduleUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Schedule WHERE scheduleUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Schedule>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Schedule call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ScheduleDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Schedule _result2;
                    int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleUid");
                    int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sceduleStartTime");
                    int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEndTime");
                    int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleDay");
                    int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleMonth");
                    int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleFrequency");
                    int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarUid");
                    int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleClazzUid");
                    int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleMasterChangeSeqNum");
                    int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLocalChangeSeqNum");
                    int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLastChangedBy");
                    int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLastChangedTime");
                    int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleActive");
                    if (_cursor.moveToFirst()) {
                        _result2 = new Schedule();
                        long _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
                        _result2.setScheduleUid(_tmpScheduleUid);
                        long _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
                        _result2.setSceduleStartTime(_tmpSceduleStartTime);
                        long _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
                        _result2.setScheduleEndTime(_tmpScheduleEndTime);
                        int _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
                        _result2.setScheduleDay(_tmpScheduleDay);
                        int _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
                        _result2.setScheduleMonth(_tmpScheduleMonth);
                        int _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
                        _result2.setScheduleFrequency(_tmpScheduleFrequency);
                        long _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
                        _result2.setUmCalendarUid(_tmpUmCalendarUid);
                        long _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
                        _result2.setScheduleClazzUid(_tmpScheduleClazzUid);
                        long _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
                        _result2.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
                        long _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
                        _result2.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
                        int _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
                        _result2.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
                        long _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
                        _result2.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
                        int _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
                        boolean _tmpScheduleActive = _tmp != 0;
                        _result2.setScheduleActive(_tmpScheduleActive);
                    } else {
                        _result2 = null;
                    }
                    Schedule schedule = _result2;
                    return schedule;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, Schedule> findAllSchedulesByClazzUid(long clazzUid) {
        String _sql = "SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1 ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1 ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        return new LimitOffsetPagingSource<Schedule>(_statement, this.__db, new String[]{"Schedule"}){

            @NonNull
            protected List<Schedule> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"scheduleUid");
                int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sceduleStartTime");
                int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"scheduleEndTime");
                int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"scheduleDay");
                int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"scheduleMonth");
                int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"scheduleFrequency");
                int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"umCalendarUid");
                int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"scheduleClazzUid");
                int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"scheduleMasterChangeSeqNum");
                int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"scheduleLocalChangeSeqNum");
                int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"scheduleLastChangedBy");
                int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"scheduleLastChangedTime");
                int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"scheduleActive");
                ArrayList<Schedule> _result2 = new ArrayList<Schedule>(cursor.getCount());
                while (cursor.moveToNext()) {
                    Schedule _item = new Schedule();
                    long _tmpScheduleUid = cursor.getLong(_cursorIndexOfScheduleUid);
                    _item.setScheduleUid(_tmpScheduleUid);
                    long _tmpSceduleStartTime = cursor.getLong(_cursorIndexOfSceduleStartTime);
                    _item.setSceduleStartTime(_tmpSceduleStartTime);
                    long _tmpScheduleEndTime = cursor.getLong(_cursorIndexOfScheduleEndTime);
                    _item.setScheduleEndTime(_tmpScheduleEndTime);
                    int _tmpScheduleDay = cursor.getInt(_cursorIndexOfScheduleDay);
                    _item.setScheduleDay(_tmpScheduleDay);
                    int _tmpScheduleMonth = cursor.getInt(_cursorIndexOfScheduleMonth);
                    _item.setScheduleMonth(_tmpScheduleMonth);
                    int _tmpScheduleFrequency = cursor.getInt(_cursorIndexOfScheduleFrequency);
                    _item.setScheduleFrequency(_tmpScheduleFrequency);
                    long _tmpUmCalendarUid = cursor.getLong(_cursorIndexOfUmCalendarUid);
                    _item.setUmCalendarUid(_tmpUmCalendarUid);
                    long _tmpScheduleClazzUid = cursor.getLong(_cursorIndexOfScheduleClazzUid);
                    _item.setScheduleClazzUid(_tmpScheduleClazzUid);
                    long _tmpScheduleMasterChangeSeqNum = cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
                    _item.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
                    long _tmpScheduleLocalChangeSeqNum = cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
                    _item.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
                    int _tmpScheduleLastChangedBy = cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
                    _item.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
                    long _tmpScheduleLastChangedTime = cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
                    _item.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
                    int _tmp = cursor.getInt(_cursorIndexOfScheduleActive);
                    boolean _tmpScheduleActive = _tmp != 0;
                    _item.setScheduleActive(_tmpScheduleActive);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Schedule> findAllSchedulesByClazzUidAsList(long clazzUid) {
        String _sql = "SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleUid");
            int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sceduleStartTime");
            int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEndTime");
            int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleDay");
            int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleMonth");
            int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleFrequency");
            int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarUid");
            int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleClazzUid");
            int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleMasterChangeSeqNum");
            int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLocalChangeSeqNum");
            int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLastChangedBy");
            int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLastChangedTime");
            int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleActive");
            ArrayList<Schedule> _result2 = new ArrayList<Schedule>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Schedule _item = new Schedule();
                long _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
                _item.setScheduleUid(_tmpScheduleUid);
                long _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
                _item.setSceduleStartTime(_tmpSceduleStartTime);
                long _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
                _item.setScheduleEndTime(_tmpScheduleEndTime);
                int _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
                _item.setScheduleDay(_tmpScheduleDay);
                int _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
                _item.setScheduleMonth(_tmpScheduleMonth);
                int _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
                _item.setScheduleFrequency(_tmpScheduleFrequency);
                long _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
                _item.setUmCalendarUid(_tmpUmCalendarUid);
                long _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
                _item.setScheduleClazzUid(_tmpScheduleClazzUid);
                long _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
                _item.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
                long _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
                _item.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
                int _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
                _item.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
                long _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
                _item.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
                int _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
                boolean _tmpScheduleActive = _tmp != 0;
                _item.setScheduleActive(_tmpScheduleActive);
                _result2.add(_item);
            }
            ArrayList<Schedule> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flow<List<Schedule>> findAllSchedulesByClazzUidAsLiveList(long clazzUid) {
        String _sql = "SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Schedule"}, (Callable)new Callable<List<Schedule>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Schedule> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ScheduleDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleUid");
                    int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sceduleStartTime");
                    int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEndTime");
                    int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleDay");
                    int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleMonth");
                    int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleFrequency");
                    int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarUid");
                    int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleClazzUid");
                    int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleMasterChangeSeqNum");
                    int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLocalChangeSeqNum");
                    int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLastChangedBy");
                    int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLastChangedTime");
                    int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleActive");
                    ArrayList<Schedule> _result2 = new ArrayList<Schedule>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Schedule _item = new Schedule();
                        long _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
                        _item.setScheduleUid(_tmpScheduleUid);
                        long _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
                        _item.setSceduleStartTime(_tmpSceduleStartTime);
                        long _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
                        _item.setScheduleEndTime(_tmpScheduleEndTime);
                        int _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
                        _item.setScheduleDay(_tmpScheduleDay);
                        int _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
                        _item.setScheduleMonth(_tmpScheduleMonth);
                        int _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
                        _item.setScheduleFrequency(_tmpScheduleFrequency);
                        long _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
                        _item.setUmCalendarUid(_tmpUmCalendarUid);
                        long _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
                        _item.setScheduleClazzUid(_tmpScheduleClazzUid);
                        long _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
                        _item.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
                        long _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
                        _item.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
                        int _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
                        _item.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
                        long _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
                        _item.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
                        int _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
                        boolean _tmpScheduleActive = _tmp != 0;
                        _item.setScheduleActive(_tmpScheduleActive);
                        _result2.add(_item);
                    }
                    ArrayList<Schedule> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findAllSchedulesByClazzUidAsync(long clazzUid, Continuation<? super List<Schedule>> $completion) {
        String _sql = "SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1 ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1 ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Schedule>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Schedule> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ScheduleDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleUid");
                    int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sceduleStartTime");
                    int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleEndTime");
                    int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleDay");
                    int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleMonth");
                    int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleFrequency");
                    int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarUid");
                    int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleClazzUid");
                    int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleMasterChangeSeqNum");
                    int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLocalChangeSeqNum");
                    int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLastChangedBy");
                    int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleLastChangedTime");
                    int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheduleActive");
                    ArrayList<Schedule> _result2 = new ArrayList<Schedule>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Schedule _item = new Schedule();
                        long _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
                        _item.setScheduleUid(_tmpScheduleUid);
                        long _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
                        _item.setSceduleStartTime(_tmpSceduleStartTime);
                        long _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
                        _item.setScheduleEndTime(_tmpScheduleEndTime);
                        int _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
                        _item.setScheduleDay(_tmpScheduleDay);
                        int _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
                        _item.setScheduleMonth(_tmpScheduleMonth);
                        int _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
                        _item.setScheduleFrequency(_tmpScheduleFrequency);
                        long _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
                        _item.setUmCalendarUid(_tmpUmCalendarUid);
                        long _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
                        _item.setScheduleClazzUid(_tmpScheduleClazzUid);
                        long _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
                        _item.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
                        long _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
                        _item.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
                        int _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
                        _item.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
                        long _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
                        _item.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
                        int _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
                        boolean _tmpScheduleActive = _tmp != 0;
                        _item.setScheduleActive(_tmpScheduleActive);
                        _result2.add(_item);
                    }
                    ArrayList<Schedule> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

