/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.CourseAssignmentMarkDao;
import com.ustadmobile.lib.db.composites.CourseAssignmentMarkAndMarkerName;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.entities.AverageCourseAssignmentMark;
import com.ustadmobile.lib.db.entities.CourseAssignmentMark;
import com.ustadmobile.lib.db.entities.CourseAssignmentMarkWithPersonMarker;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class CourseAssignmentMarkDao_Impl
extends CourseAssignmentMarkDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CourseAssignmentMark> __insertionAdapterOfCourseAssignmentMark;
    private final EntityDeletionOrUpdateAdapter<CourseAssignmentMark> __updateAdapterOfCourseAssignmentMark;

    public CourseAssignmentMarkDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCourseAssignmentMark = new EntityInsertionAdapter<CourseAssignmentMark>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `CourseAssignmentMark` (`camUid`,`camAssignmentUid`,`camSubmitterUid`,`camMarkerSubmitterUid`,`camMarkerPersonUid`,`camMarkerComment`,`camMark`,`camMaxMark`,`camPenalty`,`camLct`,`camClazzUid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseAssignmentMark entity) {
                statement.bindLong(1, entity.getCamUid());
                statement.bindLong(2, entity.getCamAssignmentUid());
                statement.bindLong(3, entity.getCamSubmitterUid());
                statement.bindLong(4, entity.getCamMarkerSubmitterUid());
                statement.bindLong(5, entity.getCamMarkerPersonUid());
                if (entity.getCamMarkerComment() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getCamMarkerComment());
                }
                statement.bindDouble(7, (double)entity.getCamMark());
                statement.bindDouble(8, (double)entity.getCamMaxMark());
                statement.bindDouble(9, (double)entity.getCamPenalty());
                statement.bindLong(10, entity.getCamLct());
                statement.bindLong(11, entity.getCamClazzUid());
            }
        };
        this.__updateAdapterOfCourseAssignmentMark = new EntityDeletionOrUpdateAdapter<CourseAssignmentMark>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `CourseAssignmentMark` SET `camUid` = ?,`camAssignmentUid` = ?,`camSubmitterUid` = ?,`camMarkerSubmitterUid` = ?,`camMarkerPersonUid` = ?,`camMarkerComment` = ?,`camMark` = ?,`camMaxMark` = ?,`camPenalty` = ?,`camLct` = ?,`camClazzUid` = ? WHERE `camUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseAssignmentMark entity) {
                statement.bindLong(1, entity.getCamUid());
                statement.bindLong(2, entity.getCamAssignmentUid());
                statement.bindLong(3, entity.getCamSubmitterUid());
                statement.bindLong(4, entity.getCamMarkerSubmitterUid());
                statement.bindLong(5, entity.getCamMarkerPersonUid());
                if (entity.getCamMarkerComment() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getCamMarkerComment());
                }
                statement.bindDouble(7, (double)entity.getCamMark());
                statement.bindDouble(8, (double)entity.getCamMaxMark());
                statement.bindDouble(9, (double)entity.getCamPenalty());
                statement.bindLong(10, entity.getCamLct());
                statement.bindLong(11, entity.getCamClazzUid());
                statement.bindLong(12, entity.getCamUid());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(CourseAssignmentMark entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfCourseAssignmentMark.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final CourseAssignmentMark entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                CourseAssignmentMarkDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = CourseAssignmentMarkDao_Impl.this.__insertionAdapterOfCourseAssignmentMark.insertAndReturnId((Object)entity);
                    CourseAssignmentMarkDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    CourseAssignmentMarkDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends CourseAssignmentMark> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCourseAssignmentMark.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(CourseAssignmentMark entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCourseAssignmentMark.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Flow<Boolean> checkNoSubmissionsMarked(long assignmentUid) {
        String _sql = "\n        SELECT NOT EXISTS(SELECT 1\n                        FROM CourseAssignmentMark\n                       WHERE CourseAssignmentMark.camAssignmentUid = ?\n                       LIMIT 1)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT NOT EXISTS(SELECT 1\n                        FROM CourseAssignmentMark\n                       WHERE CourseAssignmentMark.camAssignmentUid = ?\n                       LIMIT 1)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseAssignmentMark"}, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentMarkDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<AverageCourseAssignmentMark> getMarkOfAssignmentForSubmitterLiveData(long assignmentUid, long submitterUid) {
        String _sql = "\n         WITH ScoreByMarker (averageScore, averagePenalty) AS (\n                 SELECT AVG(camMark), AVG(camPenalty)\n                   FROM courseAssignmentMark\n                        JOIN ClazzAssignment\n                        ON caUid = courseAssignmentMark.camAssignmentUid         \n                    AND camAssignmentUid = ?\n                    AND camSubmitterUid = ?\n                  WHERE camLct = (SELECT MAX(mark.camLct) \n                                    FROM CourseAssignmentMark As mark\n                                    WHERE mark.camAssignmentUid = ?\n                                     AND mark.camSubmitterUid = ?\n                                     AND (caMarkingType = 1\n                                       OR mark.camMarkerSubmitterUid = courseAssignmentMark.camMarkerSubmitterUid))\n                )                       \n\n         SELECT COALESCE(averageScore, -1) AS averageScore, COALESCE(averagePenalty, -1) AS averagePenalty\n           FROM ScoreByMarker\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n         WITH ScoreByMarker (averageScore, averagePenalty) AS (\n                 SELECT AVG(camMark), AVG(camPenalty)\n                   FROM courseAssignmentMark\n                        JOIN ClazzAssignment\n                        ON caUid = courseAssignmentMark.camAssignmentUid         \n                    AND camAssignmentUid = ?\n                    AND camSubmitterUid = ?\n                  WHERE camLct = (SELECT MAX(mark.camLct) \n                                    FROM CourseAssignmentMark As mark\n                                    WHERE mark.camAssignmentUid = ?\n                                     AND mark.camSubmitterUid = ?\n                                     AND (caMarkingType = 1\n                                       OR mark.camMarkerSubmitterUid = courseAssignmentMark.camMarkerSubmitterUid))\n                )                       \n\n         SELECT COALESCE(averageScore, -1) AS averageScore, COALESCE(averagePenalty, -1) AS averagePenalty\n           FROM ScoreByMarker\n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, submitterUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, submitterUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"courseAssignmentMark", "ClazzAssignment", "CourseAssignmentMark"}, (Callable)new Callable<AverageCourseAssignmentMark>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public AverageCourseAssignmentMark call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentMarkDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    AverageCourseAssignmentMark _result2;
                    boolean _cursorIndexOfAverageScore = false;
                    boolean _cursorIndexOfAveragePenalty = true;
                    if (_cursor.moveToFirst()) {
                        _result2 = new AverageCourseAssignmentMark();
                        float _tmpAverageScore = _cursor.getFloat(0);
                        _result2.setAverageScore(_tmpAverageScore);
                        int _tmpAveragePenalty = _cursor.getInt(1);
                        _result2.setAveragePenalty(_tmpAveragePenalty);
                    } else {
                        _result2 = null;
                    }
                    AverageCourseAssignmentMark averageCourseAssignmentMark = _result2;
                    return averageCourseAssignmentMark;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<List<CourseAssignmentMarkAndMarkerName>> getAllMarksForUserAsFlow(long accountPersonUid, long assignmentUid) {
        String _sql = "\n        SELECT CourseAssignmentMark.*,\n               Person.firstNames AS markerFirstNames,\n               Person.lastName AS markerLastName,\n               PersonPicture.personPictureThumbnailUri AS markerPictureUri\n          FROM CourseAssignmentMark\n               LEFT JOIN Person\n                         ON Person.personUid = CourseAssignmentMark.camMarkerPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = CourseAssignmentMark.camMarkerPersonUid\n         WHERE (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    ) > 0\n           AND CourseAssignmentMark.camAssignmentUid = ?\n           AND CourseAssignmentMark.camSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n      ORDER BY CourseAssignmentMark.camLct DESC    \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseAssignmentMark.*,\n               Person.firstNames AS markerFirstNames,\n               Person.lastName AS markerLastName,\n               PersonPicture.personPictureThumbnailUri AS markerPictureUri\n          FROM CourseAssignmentMark\n               LEFT JOIN Person\n                         ON Person.personUid = CourseAssignmentMark.camMarkerPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = CourseAssignmentMark.camMarkerPersonUid\n         WHERE (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    ) > 0\n           AND CourseAssignmentMark.camAssignmentUid = ?\n           AND CourseAssignmentMark.camSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n      ORDER BY CourseAssignmentMark.camLct DESC    \n    ", (int)21);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 14;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 16;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 17;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 19;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 20;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 21;
        _statement.bindLong(_argIndex, accountPersonUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseAssignmentMark", "Person", "PersonPicture", "ClazzAssignment", "ClazzEnrolment", "CourseGroupMember"}, (Callable)new Callable<List<CourseAssignmentMarkAndMarkerName>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseAssignmentMarkAndMarkerName> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentMarkDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camUid");
                    int _cursorIndexOfCamAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camAssignmentUid");
                    int _cursorIndexOfCamSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camSubmitterUid");
                    int _cursorIndexOfCamMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMarkerSubmitterUid");
                    int _cursorIndexOfCamMarkerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMarkerPersonUid");
                    int _cursorIndexOfCamMarkerComment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMarkerComment");
                    int _cursorIndexOfCamMark = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMark");
                    int _cursorIndexOfCamMaxMark = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMaxMark");
                    int _cursorIndexOfCamPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camPenalty");
                    int _cursorIndexOfCamLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camLct");
                    int _cursorIndexOfCamClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camClazzUid");
                    int _cursorIndexOfMarkerFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markerFirstNames");
                    int _cursorIndexOfMarkerLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markerLastName");
                    int _cursorIndexOfMarkerPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markerPictureUri");
                    ArrayList<CourseAssignmentMarkAndMarkerName> _result2 = new ArrayList<CourseAssignmentMarkAndMarkerName>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CourseAssignmentMark _tmpCourseAssignmentMark;
                        String _tmpMarkerFirstNames = _cursor.isNull(_cursorIndexOfMarkerFirstNames) ? null : _cursor.getString(_cursorIndexOfMarkerFirstNames);
                        String _tmpMarkerLastName = _cursor.isNull(_cursorIndexOfMarkerLastName) ? null : _cursor.getString(_cursorIndexOfMarkerLastName);
                        String _tmpMarkerPictureUri = _cursor.isNull(_cursorIndexOfMarkerPictureUri) ? null : _cursor.getString(_cursorIndexOfMarkerPictureUri);
                        if (!(_cursor.isNull(_cursorIndexOfCamUid) && _cursor.isNull(_cursorIndexOfCamAssignmentUid) && _cursor.isNull(_cursorIndexOfCamSubmitterUid) && _cursor.isNull(_cursorIndexOfCamMarkerSubmitterUid) && _cursor.isNull(_cursorIndexOfCamMarkerPersonUid) && _cursor.isNull(_cursorIndexOfCamMarkerComment) && _cursor.isNull(_cursorIndexOfCamMark) && _cursor.isNull(_cursorIndexOfCamMaxMark) && _cursor.isNull(_cursorIndexOfCamPenalty) && _cursor.isNull(_cursorIndexOfCamLct) && _cursor.isNull(_cursorIndexOfCamClazzUid))) {
                            _tmpCourseAssignmentMark = new CourseAssignmentMark();
                            long _tmpCamUid = _cursor.getLong(_cursorIndexOfCamUid);
                            _tmpCourseAssignmentMark.setCamUid(_tmpCamUid);
                            long _tmpCamAssignmentUid = _cursor.getLong(_cursorIndexOfCamAssignmentUid);
                            _tmpCourseAssignmentMark.setCamAssignmentUid(_tmpCamAssignmentUid);
                            long _tmpCamSubmitterUid = _cursor.getLong(_cursorIndexOfCamSubmitterUid);
                            _tmpCourseAssignmentMark.setCamSubmitterUid(_tmpCamSubmitterUid);
                            long _tmpCamMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfCamMarkerSubmitterUid);
                            _tmpCourseAssignmentMark.setCamMarkerSubmitterUid(_tmpCamMarkerSubmitterUid);
                            long _tmpCamMarkerPersonUid = _cursor.getLong(_cursorIndexOfCamMarkerPersonUid);
                            _tmpCourseAssignmentMark.setCamMarkerPersonUid(_tmpCamMarkerPersonUid);
                            String _tmpCamMarkerComment = _cursor.isNull(_cursorIndexOfCamMarkerComment) ? null : _cursor.getString(_cursorIndexOfCamMarkerComment);
                            _tmpCourseAssignmentMark.setCamMarkerComment(_tmpCamMarkerComment);
                            float _tmpCamMark = _cursor.getFloat(_cursorIndexOfCamMark);
                            _tmpCourseAssignmentMark.setCamMark(_tmpCamMark);
                            float _tmpCamMaxMark = _cursor.getFloat(_cursorIndexOfCamMaxMark);
                            _tmpCourseAssignmentMark.setCamMaxMark(_tmpCamMaxMark);
                            float _tmpCamPenalty = _cursor.getFloat(_cursorIndexOfCamPenalty);
                            _tmpCourseAssignmentMark.setCamPenalty(_tmpCamPenalty);
                            long _tmpCamLct = _cursor.getLong(_cursorIndexOfCamLct);
                            _tmpCourseAssignmentMark.setCamLct(_tmpCamLct);
                            long _tmpCamClazzUid = _cursor.getLong(_cursorIndexOfCamClazzUid);
                            _tmpCourseAssignmentMark.setCamClazzUid(_tmpCamClazzUid);
                        } else {
                            _tmpCourseAssignmentMark = null;
                        }
                        CourseAssignmentMarkAndMarkerName _item = new CourseAssignmentMarkAndMarkerName(_tmpCourseAssignmentMark, _tmpMarkerFirstNames, _tmpMarkerLastName, _tmpMarkerPictureUri);
                        _result2.add(_item);
                    }
                    ArrayList<CourseAssignmentMarkAndMarkerName> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<List<CourseAssignmentMarkAndMarkerName>> getAllMarksForSubmitterAsFlow(long submitterUid, long assignmentUid) {
        String _sql = "\n        SELECT CourseAssignmentMark.*,\n               Person.firstNames AS markerFirstNames,\n               Person.lastName AS markerLastName,\n               PersonPicture.personPictureThumbnailUri AS markerPictureUri\n          FROM CourseAssignmentMark\n               LEFT JOIN Person\n                         ON Person.personUid = CourseAssignmentMark.camMarkerPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = CourseAssignmentMark.camMarkerPersonUid\n         WHERE CourseAssignmentMark.camAssignmentUid = ?\n           AND CourseAssignmentMark.camSubmitterUid = ?\n      ORDER BY CourseAssignmentMark.camLct DESC                             \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseAssignmentMark.*,\n               Person.firstNames AS markerFirstNames,\n               Person.lastName AS markerLastName,\n               PersonPicture.personPictureThumbnailUri AS markerPictureUri\n          FROM CourseAssignmentMark\n               LEFT JOIN Person\n                         ON Person.personUid = CourseAssignmentMark.camMarkerPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = CourseAssignmentMark.camMarkerPersonUid\n         WHERE CourseAssignmentMark.camAssignmentUid = ?\n           AND CourseAssignmentMark.camSubmitterUid = ?\n      ORDER BY CourseAssignmentMark.camLct DESC                             \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, submitterUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseAssignmentMark", "Person", "PersonPicture"}, (Callable)new Callable<List<CourseAssignmentMarkAndMarkerName>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseAssignmentMarkAndMarkerName> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentMarkDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camUid");
                    int _cursorIndexOfCamAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camAssignmentUid");
                    int _cursorIndexOfCamSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camSubmitterUid");
                    int _cursorIndexOfCamMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMarkerSubmitterUid");
                    int _cursorIndexOfCamMarkerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMarkerPersonUid");
                    int _cursorIndexOfCamMarkerComment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMarkerComment");
                    int _cursorIndexOfCamMark = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMark");
                    int _cursorIndexOfCamMaxMark = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMaxMark");
                    int _cursorIndexOfCamPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camPenalty");
                    int _cursorIndexOfCamLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camLct");
                    int _cursorIndexOfCamClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camClazzUid");
                    int _cursorIndexOfMarkerFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markerFirstNames");
                    int _cursorIndexOfMarkerLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markerLastName");
                    int _cursorIndexOfMarkerPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"markerPictureUri");
                    ArrayList<CourseAssignmentMarkAndMarkerName> _result2 = new ArrayList<CourseAssignmentMarkAndMarkerName>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CourseAssignmentMark _tmpCourseAssignmentMark;
                        String _tmpMarkerFirstNames = _cursor.isNull(_cursorIndexOfMarkerFirstNames) ? null : _cursor.getString(_cursorIndexOfMarkerFirstNames);
                        String _tmpMarkerLastName = _cursor.isNull(_cursorIndexOfMarkerLastName) ? null : _cursor.getString(_cursorIndexOfMarkerLastName);
                        String _tmpMarkerPictureUri = _cursor.isNull(_cursorIndexOfMarkerPictureUri) ? null : _cursor.getString(_cursorIndexOfMarkerPictureUri);
                        if (!(_cursor.isNull(_cursorIndexOfCamUid) && _cursor.isNull(_cursorIndexOfCamAssignmentUid) && _cursor.isNull(_cursorIndexOfCamSubmitterUid) && _cursor.isNull(_cursorIndexOfCamMarkerSubmitterUid) && _cursor.isNull(_cursorIndexOfCamMarkerPersonUid) && _cursor.isNull(_cursorIndexOfCamMarkerComment) && _cursor.isNull(_cursorIndexOfCamMark) && _cursor.isNull(_cursorIndexOfCamMaxMark) && _cursor.isNull(_cursorIndexOfCamPenalty) && _cursor.isNull(_cursorIndexOfCamLct) && _cursor.isNull(_cursorIndexOfCamClazzUid))) {
                            _tmpCourseAssignmentMark = new CourseAssignmentMark();
                            long _tmpCamUid = _cursor.getLong(_cursorIndexOfCamUid);
                            _tmpCourseAssignmentMark.setCamUid(_tmpCamUid);
                            long _tmpCamAssignmentUid = _cursor.getLong(_cursorIndexOfCamAssignmentUid);
                            _tmpCourseAssignmentMark.setCamAssignmentUid(_tmpCamAssignmentUid);
                            long _tmpCamSubmitterUid = _cursor.getLong(_cursorIndexOfCamSubmitterUid);
                            _tmpCourseAssignmentMark.setCamSubmitterUid(_tmpCamSubmitterUid);
                            long _tmpCamMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfCamMarkerSubmitterUid);
                            _tmpCourseAssignmentMark.setCamMarkerSubmitterUid(_tmpCamMarkerSubmitterUid);
                            long _tmpCamMarkerPersonUid = _cursor.getLong(_cursorIndexOfCamMarkerPersonUid);
                            _tmpCourseAssignmentMark.setCamMarkerPersonUid(_tmpCamMarkerPersonUid);
                            String _tmpCamMarkerComment = _cursor.isNull(_cursorIndexOfCamMarkerComment) ? null : _cursor.getString(_cursorIndexOfCamMarkerComment);
                            _tmpCourseAssignmentMark.setCamMarkerComment(_tmpCamMarkerComment);
                            float _tmpCamMark = _cursor.getFloat(_cursorIndexOfCamMark);
                            _tmpCourseAssignmentMark.setCamMark(_tmpCamMark);
                            float _tmpCamMaxMark = _cursor.getFloat(_cursorIndexOfCamMaxMark);
                            _tmpCourseAssignmentMark.setCamMaxMark(_tmpCamMaxMark);
                            float _tmpCamPenalty = _cursor.getFloat(_cursorIndexOfCamPenalty);
                            _tmpCourseAssignmentMark.setCamPenalty(_tmpCamPenalty);
                            long _tmpCamLct = _cursor.getLong(_cursorIndexOfCamLct);
                            _tmpCourseAssignmentMark.setCamLct(_tmpCamLct);
                            long _tmpCamClazzUid = _cursor.getLong(_cursorIndexOfCamClazzUid);
                            _tmpCourseAssignmentMark.setCamClazzUid(_tmpCamClazzUid);
                        } else {
                            _tmpCourseAssignmentMark = null;
                        }
                        CourseAssignmentMarkAndMarkerName _item = new CourseAssignmentMarkAndMarkerName(_tmpCourseAssignmentMark, _tmpMarkerFirstNames, _tmpMarkerLastName, _tmpMarkerPictureUri);
                        _result2.add(_item);
                    }
                    ArrayList<CourseAssignmentMarkAndMarkerName> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object getAllMarksForSubmitterAsFlowMarkerPersons(long submitterUid, long assignmentUid, Continuation<? super List<PersonAndPicture>> $completion) {
        String _sql = "\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE PersonUid IN\n               (SELECT CourseAssignmentMark.camMarkerPersonUid\n                  FROM CourseAssignmentMark\n                 WHERE CourseAssignmentMark.camAssignmentUid = ?\n                   AND CourseAssignmentMark.camSubmitterUid = ?)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE PersonUid IN\n               (SELECT CourseAssignmentMark.camMarkerPersonUid\n                  FROM CourseAssignmentMark\n                 WHERE CourseAssignmentMark.camAssignmentUid = ?\n                   AND CourseAssignmentMark.camSubmitterUid = ?)\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, submitterUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PersonAndPicture>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PersonAndPicture> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentMarkDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    ArrayList<PersonAndPicture> _result2 = new ArrayList<PersonAndPicture>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        PersonPicture _tmpPicture;
                        Person _tmpPerson;
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_1 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                            long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                            long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                            String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                            String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                            int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                            boolean _tmpPersonPictureActive = _tmp_2 != 0;
                            _tmpPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                        } else {
                            _tmpPicture = null;
                        }
                        PersonAndPicture _item = new PersonAndPicture(_tmpPerson, _tmpPicture);
                        _result2.add(_item);
                    }
                    ArrayList<PersonAndPicture> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, CourseAssignmentMarkWithPersonMarker> getAllMarksOfAssignmentForSubmitter(long assignmentUid, long submitterUid, int filter) {
        String _sql = "\n          WITH ScoreByMarker AS (\n                 SELECT *\n                   FROM courseAssignmentMark    \n                  WHERE camAssignmentUid = ?\n                    AND camSubmitterUid = ?\n                    AND (? = 0 OR camLct = (SELECT MAX(mark.camLct) \n                                    FROM CourseAssignmentMark As mark\n                                    WHERE mark.camAssignmentUid = ?\n                                      AND mark.camSubmitterUid = ?\n                                      AND mark.camMarkerSubmitterUid = courseAssignmentMark.camMarkerSubmitterUid\n                                      ))                 \n                ORDER BY camLct DESC)    \n                \n          SELECT marker.*, ScoreByMarker.*, (ClazzAssignment.caGroupUid != 0) AS isGroup\n            FROM ScoreByMarker\n                 JOIN Person As marker\n                 ON Marker.personUid = ScoreByMarker.camMarkerPersonUid\n                 JOIN ClazzAssignment\n                 ON ClazzAssignment.caUid = ?\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n          WITH ScoreByMarker AS (\n                 SELECT *\n                   FROM courseAssignmentMark    \n                  WHERE camAssignmentUid = ?\n                    AND camSubmitterUid = ?\n                    AND (? = 0 OR camLct = (SELECT MAX(mark.camLct) \n                                    FROM CourseAssignmentMark As mark\n                                    WHERE mark.camAssignmentUid = ?\n                                      AND mark.camSubmitterUid = ?\n                                      AND mark.camMarkerSubmitterUid = courseAssignmentMark.camMarkerSubmitterUid\n                                      ))                 \n                ORDER BY camLct DESC)    \n                \n          SELECT marker.*, ScoreByMarker.*, (ClazzAssignment.caGroupUid != 0) AS isGroup\n            FROM ScoreByMarker\n                 JOIN Person As marker\n                 ON Marker.personUid = ScoreByMarker.camMarkerPersonUid\n                 JOIN ClazzAssignment\n                 ON ClazzAssignment.caUid = ?\n    ", (int)6);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, submitterUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)filter);
        _argIndex = 4;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, submitterUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, assignmentUid);
        return new LimitOffsetPagingSource<CourseAssignmentMarkWithPersonMarker>(_statement, this.__db, new String[]{"courseAssignmentMark", "CourseAssignmentMark", "Person", "ClazzAssignment"}){

            @NonNull
            protected List<CourseAssignmentMarkWithPersonMarker> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personUid");
                int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"username");
                int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"firstNames");
                int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastName");
                int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"emailAddr");
                int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"phoneNum");
                int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"gender");
                int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"active");
                int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dateOfBirth");
                int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personAddress");
                int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personOrgId");
                int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personGroupUid");
                int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLct");
                int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personCountry");
                int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personType");
                int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personMasterChangeSeqNum");
                int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLocalChangeSeqNum");
                int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLastChangedBy");
                int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"admin");
                int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personNotes");
                int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherName");
                int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherNumber");
                int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherName");
                int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherNum");
                int _cursorIndexOfCamUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"camUid");
                int _cursorIndexOfCamAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"camAssignmentUid");
                int _cursorIndexOfCamSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"camSubmitterUid");
                int _cursorIndexOfCamMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"camMarkerSubmitterUid");
                int _cursorIndexOfCamMarkerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"camMarkerPersonUid");
                int _cursorIndexOfCamMarkerComment = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"camMarkerComment");
                int _cursorIndexOfCamMark = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"camMark");
                int _cursorIndexOfCamMaxMark = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"camMaxMark");
                int _cursorIndexOfCamPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"camPenalty");
                int _cursorIndexOfCamLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"camLct");
                int _cursorIndexOfCamClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"camClazzUid");
                int _cursorIndexOfIsGroup = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isGroup");
                ArrayList<CourseAssignmentMarkWithPersonMarker> _result2 = new ArrayList<CourseAssignmentMarkWithPersonMarker>(cursor.getCount());
                while (cursor.moveToNext()) {
                    Person _tmpMarker;
                    if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
                        long _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = cursor.isNull(_cursorIndexOfUsername) ? null : cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = cursor.isNull(_cursorIndexOfFirstNames) ? null : cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = cursor.isNull(_cursorIndexOfLastName) ? null : cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = cursor.isNull(_cursorIndexOfEmailAddr) ? null : cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = cursor.isNull(_cursorIndexOfPhoneNum) ? null : cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = cursor.getInt(_cursorIndexOfGender);
                        int _tmp = cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp != 0;
                        long _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = cursor.isNull(_cursorIndexOfPersonAddress) ? null : cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = cursor.isNull(_cursorIndexOfPersonOrgId) ? null : cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = cursor.isNull(_cursorIndexOfPersonCountry) ? null : cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_1 != 0;
                        String _tmpPersonNotes = cursor.isNull(_cursorIndexOfPersonNotes) ? null : cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = cursor.isNull(_cursorIndexOfFatherName) ? null : cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = cursor.isNull(_cursorIndexOfFatherNumber) ? null : cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = cursor.isNull(_cursorIndexOfMotherName) ? null : cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = cursor.isNull(_cursorIndexOfMotherNum) ? null : cursor.getString(_cursorIndexOfMotherNum);
                        _tmpMarker = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _tmpMarker = null;
                    }
                    CourseAssignmentMarkWithPersonMarker _item = new CourseAssignmentMarkWithPersonMarker();
                    long _tmpCamUid = cursor.getLong(_cursorIndexOfCamUid);
                    _item.setCamUid(_tmpCamUid);
                    long _tmpCamAssignmentUid = cursor.getLong(_cursorIndexOfCamAssignmentUid);
                    _item.setCamAssignmentUid(_tmpCamAssignmentUid);
                    long _tmpCamSubmitterUid = cursor.getLong(_cursorIndexOfCamSubmitterUid);
                    _item.setCamSubmitterUid(_tmpCamSubmitterUid);
                    long _tmpCamMarkerSubmitterUid = cursor.getLong(_cursorIndexOfCamMarkerSubmitterUid);
                    _item.setCamMarkerSubmitterUid(_tmpCamMarkerSubmitterUid);
                    long _tmpCamMarkerPersonUid = cursor.getLong(_cursorIndexOfCamMarkerPersonUid);
                    _item.setCamMarkerPersonUid(_tmpCamMarkerPersonUid);
                    String _tmpCamMarkerComment = cursor.isNull(_cursorIndexOfCamMarkerComment) ? null : cursor.getString(_cursorIndexOfCamMarkerComment);
                    _item.setCamMarkerComment(_tmpCamMarkerComment);
                    float _tmpCamMark = cursor.getFloat(_cursorIndexOfCamMark);
                    _item.setCamMark(_tmpCamMark);
                    float _tmpCamMaxMark = cursor.getFloat(_cursorIndexOfCamMaxMark);
                    _item.setCamMaxMark(_tmpCamMaxMark);
                    float _tmpCamPenalty = cursor.getFloat(_cursorIndexOfCamPenalty);
                    _item.setCamPenalty(_tmpCamPenalty);
                    long _tmpCamLct = cursor.getLong(_cursorIndexOfCamLct);
                    _item.setCamLct(_tmpCamLct);
                    long _tmpCamClazzUid = cursor.getLong(_cursorIndexOfCamClazzUid);
                    _item.setCamClazzUid(_tmpCamClazzUid);
                    int _tmp_2 = cursor.getInt(_cursorIndexOfIsGroup);
                    boolean _tmpIsGroup = _tmp_2 != 0;
                    _item.setGroup(_tmpIsGroup);
                    _item.setMarker(_tmpMarker);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CourseAssignmentMark getMarkOfAssignmentForStudent(long assignmentUid, long submitterUid) {
        String _sql = "\n        SELECT * \n          FROM CourseAssignmentMark\n         WHERE camAssignmentUid = ?\n           AND camSubmitterUid = ?\n      ORDER BY camLct DESC\n         LIMIT 1\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM CourseAssignmentMark\n         WHERE camAssignmentUid = ?\n           AND camSubmitterUid = ?\n      ORDER BY camLct DESC\n         LIMIT 1\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, submitterUid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            CourseAssignmentMark _result2;
            int _cursorIndexOfCamUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camUid");
            int _cursorIndexOfCamAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camAssignmentUid");
            int _cursorIndexOfCamSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camSubmitterUid");
            int _cursorIndexOfCamMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMarkerSubmitterUid");
            int _cursorIndexOfCamMarkerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMarkerPersonUid");
            int _cursorIndexOfCamMarkerComment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMarkerComment");
            int _cursorIndexOfCamMark = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMark");
            int _cursorIndexOfCamMaxMark = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camMaxMark");
            int _cursorIndexOfCamPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camPenalty");
            int _cursorIndexOfCamLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camLct");
            int _cursorIndexOfCamClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"camClazzUid");
            if (_cursor.moveToFirst()) {
                _result2 = new CourseAssignmentMark();
                long _tmpCamUid = _cursor.getLong(_cursorIndexOfCamUid);
                _result2.setCamUid(_tmpCamUid);
                long _tmpCamAssignmentUid = _cursor.getLong(_cursorIndexOfCamAssignmentUid);
                _result2.setCamAssignmentUid(_tmpCamAssignmentUid);
                long _tmpCamSubmitterUid = _cursor.getLong(_cursorIndexOfCamSubmitterUid);
                _result2.setCamSubmitterUid(_tmpCamSubmitterUid);
                long _tmpCamMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfCamMarkerSubmitterUid);
                _result2.setCamMarkerSubmitterUid(_tmpCamMarkerSubmitterUid);
                long _tmpCamMarkerPersonUid = _cursor.getLong(_cursorIndexOfCamMarkerPersonUid);
                _result2.setCamMarkerPersonUid(_tmpCamMarkerPersonUid);
                String _tmpCamMarkerComment = _cursor.isNull(_cursorIndexOfCamMarkerComment) ? null : _cursor.getString(_cursorIndexOfCamMarkerComment);
                _result2.setCamMarkerComment(_tmpCamMarkerComment);
                float _tmpCamMark = _cursor.getFloat(_cursorIndexOfCamMark);
                _result2.setCamMark(_tmpCamMark);
                float _tmpCamMaxMark = _cursor.getFloat(_cursorIndexOfCamMaxMark);
                _result2.setCamMaxMark(_tmpCamMaxMark);
                float _tmpCamPenalty = _cursor.getFloat(_cursorIndexOfCamPenalty);
                _result2.setCamPenalty(_tmpCamPenalty);
                long _tmpCamLct = _cursor.getLong(_cursorIndexOfCamLct);
                _result2.setCamLct(_tmpCamLct);
                long _tmpCamClazzUid = _cursor.getLong(_cursorIndexOfCamClazzUid);
                _result2.setCamClazzUid(_tmpCamClazzUid);
            } else {
                _result2 = null;
            }
            CourseAssignmentMark courseAssignmentMark = _result2;
            return courseAssignmentMark;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findNextSubmitterToMarkForAssignment(long assignmentUid, long submitterUid, long markerUid, Continuation<? super Long> $completion) {
        String _sql = "\n         SELECT COALESCE((\n            SELECT casSubmitterUid\n              FROM CourseAssignmentSubmission\n              \n                   JOIN ClazzAssignment\n                   ON ClazzAssignment.caUid = CourseAssignmentSubmission.casAssignmentUid\n              \n                   LEFT JOIN CourseAssignmentMark\n                   ON CourseAssignmentMark.camSubmitterUid = CourseAssignmentSubmission.casSubmitterUid\n                   AND CourseAssignmentMark.camAssignmentUid = ClazzAssignment.caUid\n                   \n                   LEFT JOIN PeerReviewerAllocation\n                   ON praAssignmentUid = ClazzAssignment.caUid\n                   AND praToMarkerSubmitterUid = ?\n                   \n             WHERE CourseAssignmentSubmission.casSubmitterUid != ?\n               AND CourseAssignmentSubmission.casSubmitterUid != ?\n               AND CourseAssignmentSubmission.casAssignmentUid = ?\n               AND CourseAssignmentMark.camUid IS NULL\n               AND (ClazzAssignment.caMarkingType = 1 \n                    OR PeerReviewerAllocation.praMarkerSubmitterUid = ?)\n          GROUP BY casSubmitterUid\n         LIMIT 1),0)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n         SELECT COALESCE((\n            SELECT casSubmitterUid\n              FROM CourseAssignmentSubmission\n              \n                   JOIN ClazzAssignment\n                   ON ClazzAssignment.caUid = CourseAssignmentSubmission.casAssignmentUid\n              \n                   LEFT JOIN CourseAssignmentMark\n                   ON CourseAssignmentMark.camSubmitterUid = CourseAssignmentSubmission.casSubmitterUid\n                   AND CourseAssignmentMark.camAssignmentUid = ClazzAssignment.caUid\n                   \n                   LEFT JOIN PeerReviewerAllocation\n                   ON praAssignmentUid = ClazzAssignment.caUid\n                   AND praToMarkerSubmitterUid = ?\n                   \n             WHERE CourseAssignmentSubmission.casSubmitterUid != ?\n               AND CourseAssignmentSubmission.casSubmitterUid != ?\n               AND CourseAssignmentSubmission.casAssignmentUid = ?\n               AND CourseAssignmentMark.camUid IS NULL\n               AND (ClazzAssignment.caMarkingType = 1 \n                    OR PeerReviewerAllocation.praMarkerSubmitterUid = ?)\n          GROUP BY casSubmitterUid\n         LIMIT 1),0)\n    ", (int)5);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, submitterUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, submitterUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, markerUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, markerUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Long call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentMarkDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Long _result2;
                    if (_cursor.moveToFirst()) {
                        long _tmp = _cursor.getLong(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0L;
                    }
                    Long l = _result2;
                    return l;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

