package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.replication.withRepoChangeMonitorAsync
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.PersonAuth2
import io.ktor.client.HttpClient
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class PersonAuth2Dao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: PersonAuth2Dao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : PersonAuth2Dao() {
  override suspend fun insertListAsync(auths: List<PersonAuth2>) {
    _repo.withRepoChangeMonitorAsync("PersonAuth2") {
      _dao.insertListAsync(auths)
    }
  }

  override suspend fun insertAsync(auth: PersonAuth2): Long {
    val _result = _repo.withRepoChangeMonitorAsync("PersonAuth2") {
      _dao.insertAsync(auth)
    }
    return _result
  }

  override suspend fun findByPersonUid(personUid: Long): PersonAuth2? {
    val _result = _dao.findByPersonUid(personUid)
    return _result
  }

  override suspend fun findByUsername(username: String): PersonAuth2? {
    val _result = _dao.findByUsername(username)
    return _result
  }
}
