/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

public class CodespaceRange {
    private final int[] start;
    private final int[] end;
    private final int codeLength;

    public CodespaceRange(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = byArray;
        if (byArray.length != byArray2.length && byArray.length == 1 && byArray[0] == 0) {
            byArray3 = new byte[byArray2.length];
        } else if (byArray.length != byArray2.length) {
            throw new IllegalArgumentException("The start and the end values must not have different lengths.");
        }
        this.start = new int[byArray3.length];
        this.end = new int[byArray2.length];
        for (int i = 0; i < byArray3.length; ++i) {
            this.start[i] = byArray3[i] & 0xFF;
            this.end[i] = byArray2[i] & 0xFF;
        }
        this.codeLength = byArray2.length;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public boolean matches(byte[] byArray) {
        return this.isFullMatch(byArray, byArray.length);
    }

    public boolean isFullMatch(byte[] byArray, int n) {
        if (this.codeLength != n) {
            return false;
        }
        for (n = 0; n < this.codeLength; ++n) {
            int n2 = byArray[n] & 0xFF;
            if (n2 >= this.start[n] && n2 <= this.end[n]) continue;
            return false;
        }
        return true;
    }
}

